/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders.fragments.specular;

import android.graphics.Color;
import android.opengl.GLES20;
import java.util.List;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.methods.DiffuseMethod;
import org.rajawali3d.materials.methods.SpecularMethod;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.materials.shaders.fragments.LightsVertexShaderFragment;
import org.rajawali3d.materials.shaders.fragments.texture.ATextureFragmentShaderFragment;
import org.rajawali3d.materials.textures.ATexture;

public class PhongFragmentShaderFragment
extends ATextureFragmentShaderFragment
implements IShaderFragment {
    public static final String SHADER_ID = "PHONG_FRAGMENT";
    private AShaderBase.RVec3 muSpecularColor;
    private AShaderBase.RFloat muShininess;
    private AShaderBase.RFloat muSpecularIntensity;
    private float[] mSpecularColor = new float[]{1.0f, 1.0f, 1.0f};
    private float mShininess;
    private float mSpecularIntensity;
    private int muSpecularColorHandle;
    private int muShininessHandle;
    private int muSpecularIntensityHandle;
    private List<ALight> mLights;

    public PhongFragmentShaderFragment(List<ALight> lights, int specularColor, float shininess) {
        this(lights, specularColor, shininess, 1.0f, null);
    }

    public PhongFragmentShaderFragment(List<ALight> lights, int specularColor, float shininess, float specularIntensity, List<ATexture> textures) {
        super(textures);
        this.mSpecularColor[0] = (float)Color.red((int)specularColor) / 255.0f;
        this.mSpecularColor[1] = (float)Color.green((int)specularColor) / 255.0f;
        this.mSpecularColor[2] = (float)Color.blue((int)specularColor) / 255.0f;
        this.mShininess = shininess;
        this.mSpecularIntensity = specularIntensity;
        this.mLights = lights;
        this.mTextures = textures;
        this.initialize();
    }

    @Override
    public String getShaderId() {
        return SHADER_ID;
    }

    @Override
    public void main() {
        AShaderBase.RFloat specular = (AShaderBase)this.new AShaderBase.RFloat("specular");
        AShaderBase.RFloat gSpecularValue = (AShaderBase.RFloat)this.getGlobal(AShaderBase.DefaultShaderVar.G_SPECULAR_VALUE);
        specular.assign(0.0f);
        for (int i = 0; i < this.mLights.size(); ++i) {
            AShaderBase.RFloat attenuation = (AShaderBase.RFloat)this.getGlobal(LightsVertexShaderFragment.LightsShaderVar.V_LIGHT_ATTENUATION, i);
            AShaderBase.RFloat lightPower = (AShaderBase.RFloat)this.getGlobal(LightsVertexShaderFragment.LightsShaderVar.U_LIGHT_POWER, i);
            AShaderBase.RFloat nDotL = (AShaderBase.RFloat)this.getGlobal(DiffuseMethod.DiffuseShaderVar.L_NDOTL, i);
            AShaderBase.RFloat spec = (AShaderBase)this.new AShaderBase.RFloat("spec" + i);
            spec.assign(this.pow(nDotL, this.muShininess));
            spec.assign(spec.multiply(attenuation).multiply(lightPower));
            specular.assignAdd(spec);
        }
        specular.assignMultiply(this.muSpecularIntensity.multiply(gSpecularValue));
        AShaderBase.RVec2 textureCoord = (AShaderBase.RVec2)this.getGlobal(AShaderBase.DefaultShaderVar.G_TEXTURE_COORD);
        AShaderBase.RVec4 color = (AShaderBase.RVec4)this.getGlobal(AShaderBase.DefaultShaderVar.G_COLOR);
        if (this.mTextures != null && this.mTextures.size() > 0) {
            AShaderBase.RVec4 specMapColor = (AShaderBase)this.new AShaderBase.RVec4("specMapColor");
            specMapColor.assign(this.castVec4(0.0f));
            for (int i = 0; i < this.mTextures.size(); ++i) {
                AShaderBase.RVec4 specColor = (AShaderBase)this.new AShaderBase.RVec4("specColor" + i);
                specColor.assign(this.texture2D(this.muTextures[i], textureCoord));
                specColor.assignMultiply(this.muInfluence[i]);
                specMapColor.assignAdd(specColor);
            }
            color.rgb().assignAdd(specular.multiply(this.muSpecularColor).multiply(specMapColor.rgb()));
        } else {
            color.rgb().assignAdd(specular.multiply(this.muSpecularColor));
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.muSpecularColor = (AShaderBase.RVec3)this.addUniform(SpecularMethod.SpecularShaderVar.U_SPECULAR_COLOR);
        this.muShininess = (AShaderBase.RFloat)this.addUniform(SpecularMethod.SpecularShaderVar.U_SHININESS);
        this.muSpecularIntensity = (AShaderBase.RFloat)this.addUniform(SpecularMethod.SpecularShaderVar.U_SPECULAR_INTENSITY);
    }

    @Override
    public void setLocations(int programHandle) {
        super.setLocations(programHandle);
        this.muSpecularColorHandle = this.getUniformLocation(programHandle, SpecularMethod.SpecularShaderVar.U_SPECULAR_COLOR);
        this.muShininessHandle = this.getUniformLocation(programHandle, SpecularMethod.SpecularShaderVar.U_SHININESS);
        this.muSpecularIntensityHandle = this.getUniformLocation(programHandle, SpecularMethod.SpecularShaderVar.U_SPECULAR_INTENSITY);
    }

    @Override
    public void applyParams() {
        super.applyParams();
        GLES20.glUniform3fv((int)this.muSpecularColorHandle, (int)1, (float[])this.mSpecularColor, (int)0);
        GLES20.glUniform1f((int)this.muShininessHandle, (float)this.mShininess);
        GLES20.glUniform1f((int)this.muSpecularIntensityHandle, (float)this.mSpecularIntensity);
    }

    public void setSpecularColor(int color) {
        this.mSpecularColor[0] = (float)Color.red((int)color) / 255.0f;
        this.mSpecularColor[1] = (float)Color.green((int)color) / 255.0f;
        this.mSpecularColor[2] = (float)Color.blue((int)color) / 255.0f;
    }

    public void setSpecularIntensity(float specularIntensity) {
        this.mSpecularIntensity = specularIntensity;
    }

    public void setShininess(float shininess) {
        this.mShininess = shininess;
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.IGNORE;
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }
}

