/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders.fragments.effects;

import android.opengl.GLES20;
import java.util.List;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.methods.DiffuseMethod;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.materials.shaders.fragments.LightsVertexShaderFragment;

public class ToonFragmentShaderFragment
extends AShader
implements IShaderFragment {
    public static final String SHADER_ID = "TOON_FRAGMENT";
    private AShaderBase.RFloat[] mgNdotL;
    private AShaderBase.RVec4 muToonColor0;
    private AShaderBase.RVec4 muToonColor1;
    private AShaderBase.RVec4 muToonColor2;
    private AShaderBase.RVec4 muToonColor3;
    private float[] mToonColor0;
    private float[] mToonColor1;
    private float[] mToonColor2;
    private float[] mToonColor3;
    private int muToonColor0Handle;
    private int muToonColor1Handle;
    private int muToonColor2Handle;
    private int muToonColor3Handle;
    private List<ALight> mLights;

    public ToonFragmentShaderFragment(List<ALight> lights) {
        super(AShader.ShaderType.FRAGMENT_SHADER_FRAGMENT);
        this.mLights = lights;
        this.initialize();
    }

    @Override
    public String getShaderId() {
        return SHADER_ID;
    }

    @Override
    public void main() {
        AShaderBase.RVec4 color = (AShaderBase.RVec4)this.getGlobal(AShaderBase.DefaultShaderVar.G_COLOR);
        AShaderBase.RFloat intensity = (AShaderBase)this.new AShaderBase.RFloat("intensity");
        AShaderBase.RVec3 normal = (AShaderBase.RVec3)this.getGlobal(AShaderBase.DefaultShaderVar.G_NORMAL);
        AShaderBase.RFloat power = (AShaderBase)this.new AShaderBase.RFloat("power");
        power.assign(0.0f);
        intensity.assign(0.0f);
        for (int i = 0; i < this.mLights.size(); ++i) {
            AShaderBase.RFloat attenuation = (AShaderBase.RFloat)this.getGlobal(LightsVertexShaderFragment.LightsShaderVar.V_LIGHT_ATTENUATION, i);
            AShaderBase.RFloat lightPower = (AShaderBase.RFloat)this.getGlobal(LightsVertexShaderFragment.LightsShaderVar.U_LIGHT_POWER, i);
            AShaderBase.RVec3 lightDir = (AShaderBase)this.new AShaderBase.RVec3("lightDir" + i);
            AShaderBase.RFloat nDotL = this.mgNdotL[i];
            nDotL.assign(this.max(this.dot(normal, lightDir), 0.1f));
            power.assign(lightPower.multiply(nDotL).multiply(attenuation));
            intensity.assignAdd(power);
        }
        this.startif(new AShader.Condition((AShaderBase.ShaderVar)intensity, AShader.Operator.GREATER_THAN, 0.95f));
        color.assign(this.muToonColor0);
        this.ifelseif(new AShader.Condition((AShaderBase.ShaderVar)intensity, AShader.Operator.GREATER_THAN, 0.5f));
        color.assign(this.muToonColor1);
        this.ifelseif(new AShader.Condition((AShaderBase.ShaderVar)intensity, AShader.Operator.GREATER_THAN, 0.25f));
        color.assign(this.muToonColor2);
        this.ifelse();
        color.assign(this.muToonColor3);
        this.endif();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.muToonColor0 = (AShaderBase.RVec4)this.addUniform(ToonShaderVar.U_TOON_COLOR0);
        this.muToonColor1 = (AShaderBase.RVec4)this.addUniform(ToonShaderVar.U_TOON_COLOR1);
        this.muToonColor2 = (AShaderBase.RVec4)this.addUniform(ToonShaderVar.U_TOON_COLOR2);
        this.muToonColor3 = (AShaderBase.RVec4)this.addUniform(ToonShaderVar.U_TOON_COLOR3);
        this.mgNdotL = new AShaderBase.RFloat[this.mLights.size()];
        for (int i = 0; i < this.mLights.size(); ++i) {
            this.mgNdotL[i] = (AShaderBase.RFloat)this.addGlobal(DiffuseMethod.DiffuseShaderVar.L_NDOTL, i);
        }
    }

    @Override
    public void setLocations(int programHandle) {
        super.setLocations(programHandle);
        this.muToonColor0Handle = this.getUniformLocation(programHandle, ToonShaderVar.U_TOON_COLOR0);
        this.muToonColor1Handle = this.getUniformLocation(programHandle, ToonShaderVar.U_TOON_COLOR1);
        this.muToonColor2Handle = this.getUniformLocation(programHandle, ToonShaderVar.U_TOON_COLOR2);
        this.muToonColor3Handle = this.getUniformLocation(programHandle, ToonShaderVar.U_TOON_COLOR3);
    }

    @Override
    public void applyParams() {
        super.applyParams();
        GLES20.glUniform4fv((int)this.muToonColor0Handle, (int)1, (float[])this.mToonColor0, (int)0);
        GLES20.glUniform4fv((int)this.muToonColor1Handle, (int)1, (float[])this.mToonColor1, (int)0);
        GLES20.glUniform4fv((int)this.muToonColor2Handle, (int)1, (float[])this.mToonColor2, (int)0);
        GLES20.glUniform4fv((int)this.muToonColor3Handle, (int)1, (float[])this.mToonColor3, (int)0);
    }

    public void setToonColors(float[] toonColor0, float[] toonColor1, float[] toonColor2, float[] toonColor3) {
        this.mToonColor0 = toonColor0;
        this.mToonColor1 = toonColor1;
        this.mToonColor2 = toonColor2;
        this.mToonColor3 = toonColor3;
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.IGNORE;
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }

    public static enum ToonShaderVar implements AShaderBase.IGlobalShaderVar
    {
        U_TOON_COLOR0("uToonColor0", AShaderBase.DataType.VEC4),
        U_TOON_COLOR1("uToonColor1", AShaderBase.DataType.VEC4),
        U_TOON_COLOR2("uToonColor2", AShaderBase.DataType.VEC4),
        U_TOON_COLOR3("uToonColor3", AShaderBase.DataType.VEC4);

        private String mVarString;
        private AShaderBase.DataType mDataType;

        private ToonShaderVar(String varString, AShaderBase.DataType dataType) {
            this.mVarString = varString;
            this.mDataType = dataType;
        }

        @Override
        public String getVarString() {
            return this.mVarString;
        }

        @Override
        public AShaderBase.DataType getDataType() {
            return this.mDataType;
        }
    }
}

