/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders.fragments.diffuse;

import java.util.List;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.methods.DiffuseMethod;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.materials.shaders.fragments.LightsVertexShaderFragment;

public class LambertFragmentShaderFragment
extends AShader
implements IShaderFragment {
    public static final String SHADER_ID = "LAMBERT_FRAGMENT";
    private List<ALight> mLights;
    private AShaderBase.RFloat[] mgNdotL;

    public LambertFragmentShaderFragment(List<ALight> lights) {
        super(AShader.ShaderType.FRAGMENT_SHADER_FRAGMENT);
        this.mLights = lights;
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.mgNdotL = new AShaderBase.RFloat[this.mLights.size()];
        for (int i = 0; i < this.mLights.size(); ++i) {
            this.mgNdotL[i] = (AShaderBase.RFloat)this.addGlobal(DiffuseMethod.DiffuseShaderVar.L_NDOTL, i);
        }
    }

    @Override
    public String getShaderId() {
        return SHADER_ID;
    }

    @Override
    public void main() {
        AShaderBase.RVec3 diffuse = (AShaderBase)this.new AShaderBase.RVec3("diffuse");
        diffuse.assign(0.0f);
        AShaderBase.RVec3 normal = (AShaderBase.RVec3)this.getGlobal(AShaderBase.DefaultShaderVar.G_NORMAL);
        AShaderBase.RFloat power = (AShaderBase)this.new AShaderBase.RFloat("power");
        power.assign(0.0f);
        for (int i = 0; i < this.mLights.size(); ++i) {
            AShaderBase.RFloat attenuation = (AShaderBase.RFloat)this.getGlobal(LightsVertexShaderFragment.LightsShaderVar.V_LIGHT_ATTENUATION, i);
            AShaderBase.RFloat lightPower = (AShaderBase.RFloat)this.getGlobal(LightsVertexShaderFragment.LightsShaderVar.U_LIGHT_POWER, i);
            AShaderBase.RVec3 lightColor = (AShaderBase.RVec3)this.getGlobal(LightsVertexShaderFragment.LightsShaderVar.U_LIGHT_COLOR, i);
            AShaderBase.RVec3 lightDir = (AShaderBase)this.new AShaderBase.RVec3("lightDir" + i);
            AShaderBase.RFloat nDotL = this.mgNdotL[i];
            nDotL.assign(this.max(this.dot(normal, lightDir), 0.1f));
            power.assign(lightPower.multiply(nDotL).multiply(attenuation));
            diffuse.assignAdd(lightColor.multiply(power));
        }
        AShaderBase.RVec4 color = (AShaderBase.RVec4)this.getGlobal(AShaderBase.DefaultShaderVar.G_COLOR);
        AShaderBase.RVec3 ambientColor = (AShaderBase.RVec3)this.getGlobal(LightsVertexShaderFragment.LightsShaderVar.V_AMBIENT_COLOR);
        color.rgb().assign(this.enclose(diffuse.multiply(color.rgb())).add(ambientColor));
        AShaderBase.ShaderVar gShadowValue = this.getGlobal(AShaderBase.DefaultShaderVar.G_SHADOW_VALUE);
        color.rgb().assign(color.rgb().multiply(this.enclose((AShaderBase)this.new AShaderBase.RFloat("1.0").subtract(gShadowValue))));
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.IGNORE;
    }
}

