/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders.fragments.animation;

import android.opengl.GLES20;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.plugins.VertexAnimationMaterialPlugin;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;

public class VertexAnimationVertexShaderFragment
extends AShader
implements IShaderFragment {
    public static final String SHADER_ID = "VERTEX_ANIMATION_VERTEX";
    private AShaderBase.RVec4 maNextFramePosition;
    private AShaderBase.RVec3 maNextFrameNormal;
    private AShaderBase.RFloat muInterpolation;
    private int maNextFramePositionHandle;
    private int maNextFrameNormalHandle;
    private int muInterpolationHandle;

    public VertexAnimationVertexShaderFragment() {
        super(AShader.ShaderType.VERTEX_SHADER_FRAGMENT);
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.maNextFramePosition = (AShaderBase.RVec4)this.addAttribute(VertexAnimationMaterialPlugin.VertexAnimationShaderVar.A_NEXT_FRAME_POSITION);
        this.maNextFrameNormal = (AShaderBase.RVec3)this.addAttribute(VertexAnimationMaterialPlugin.VertexAnimationShaderVar.A_NEXT_FRAME_NORMAL);
        this.muInterpolation = (AShaderBase.RFloat)this.addUniform(VertexAnimationMaterialPlugin.VertexAnimationShaderVar.U_INTERPOLATION);
    }

    @Override
    public String getShaderId() {
        return SHADER_ID;
    }

    @Override
    public void main() {
        AShaderBase.RVec4 position = (AShaderBase.RVec4)this.getGlobal(AShaderBase.DefaultShaderVar.G_POSITION);
        AShaderBase.RVec3 normal = (AShaderBase.RVec3)this.getGlobal(AShaderBase.DefaultShaderVar.G_NORMAL);
        AShaderBase.RVec4 aPosition = (AShaderBase.RVec4)this.getGlobal(AShaderBase.DefaultShaderVar.A_POSITION);
        AShaderBase.RVec3 aNormal = (AShaderBase.RVec3)this.getGlobal(AShaderBase.DefaultShaderVar.A_NORMAL);
        position.assign(aPosition.add(this.muInterpolation.multiply(this.enclose(this.maNextFramePosition.subtract(aPosition)))));
        normal.assign(aNormal.add(this.muInterpolation.multiply(this.enclose(this.maNextFrameNormal.subtract(aNormal)))));
    }

    @Override
    public void setLocations(int programHandle) {
        this.maNextFramePositionHandle = this.getAttribLocation(programHandle, VertexAnimationMaterialPlugin.VertexAnimationShaderVar.A_NEXT_FRAME_POSITION);
        this.maNextFrameNormalHandle = this.getAttribLocation(programHandle, VertexAnimationMaterialPlugin.VertexAnimationShaderVar.A_NEXT_FRAME_NORMAL);
        this.muInterpolationHandle = this.getUniformLocation(programHandle, VertexAnimationMaterialPlugin.VertexAnimationShaderVar.U_INTERPOLATION);
    }

    public void setNextFrameVertices(int vertexBufferHandle) {
        GLES20.glBindBuffer((int)34962, (int)vertexBufferHandle);
        GLES20.glEnableVertexAttribArray((int)this.maNextFramePositionHandle);
        GLES20.glVertexAttribPointer((int)this.maNextFramePositionHandle, (int)3, (int)5126, (boolean)false, (int)0, (int)0);
    }

    public void setNextFrameNormals(int normalBufferHandle) {
        GLES20.glBindBuffer((int)34962, (int)normalBufferHandle);
        GLES20.glEnableVertexAttribArray((int)this.maNextFrameNormalHandle);
        GLES20.glVertexAttribPointer((int)this.maNextFrameNormalHandle, (int)3, (int)5126, (boolean)false, (int)0, (int)0);
    }

    public void setInterpolation(double interpolation) {
        GLES20.glUniform1f((int)this.muInterpolationHandle, (float)((float)interpolation));
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.IGNORE;
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }
}

