/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders.fragments.animation;

import android.opengl.GLES20;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.plugins.SkeletalAnimationMaterialPlugin;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.util.ArrayUtils;

public class SkeletalAnimationVertexShaderFragment
extends AShader
implements IShaderFragment {
    public static final String SHADER_ID = "SKELETAL_ANIMATION_VERTEX";
    private AShaderBase.RMat4 muBoneMatrix;
    private AShaderBase.RMat4 mgBoneTransfMatrix;
    private AShaderBase.RVec4 maBoneIndex1;
    private AShaderBase.RVec4 maBoneWeight1;
    private AShaderBase.RVec4 maBoneIndex2;
    private AShaderBase.RVec4 maBoneWeight2;
    private int muBoneMatrixHandle;
    private int maBoneIndex1Handle;
    private int maBoneWeight1Handle;
    private int maBoneIndex2Handle;
    private int maBoneWeight2Handle;
    private int mNumJoints;
    private int mVertexWeight;
    protected float[] mTempBoneArray = null;

    public SkeletalAnimationVertexShaderFragment(int numJoints, int numVertexWeights) {
        super(AShader.ShaderType.VERTEX_SHADER_FRAGMENT);
        this.mNumJoints = numJoints;
        this.mVertexWeight = numVertexWeights;
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.mgBoneTransfMatrix = (AShaderBase.RMat4)this.addGlobal(SkeletalAnimationMaterialPlugin.SkeletalAnimationShaderVar.G_BONE_TRANSF_MATRIX);
        this.muBoneMatrix = (AShaderBase.RMat4)this.addUniform(SkeletalAnimationMaterialPlugin.SkeletalAnimationShaderVar.U_BONE_MATRIX);
        this.muBoneMatrix.isArray(this.mNumJoints);
        this.maBoneIndex1 = (AShaderBase.RVec4)this.addAttribute(SkeletalAnimationMaterialPlugin.SkeletalAnimationShaderVar.A_BONE_INDEX1);
        this.maBoneWeight1 = (AShaderBase.RVec4)this.addAttribute(SkeletalAnimationMaterialPlugin.SkeletalAnimationShaderVar.A_BONE_WEIGHT1);
        if (this.mVertexWeight > 4) {
            this.maBoneIndex2 = (AShaderBase.RVec4)this.addAttribute(SkeletalAnimationMaterialPlugin.SkeletalAnimationShaderVar.A_BONE_INDEX2);
            this.maBoneWeight2 = (AShaderBase.RVec4)this.addAttribute(SkeletalAnimationMaterialPlugin.SkeletalAnimationShaderVar.A_BONE_WEIGHT2);
        }
    }

    @Override
    public String getShaderId() {
        return SHADER_ID;
    }

    @Override
    public void main() {
        this.mgBoneTransfMatrix.assign(this.enclose(this.maBoneWeight1.x().multiply(this.muBoneMatrix.elementAt(this.castInt(this.maBoneIndex1.x())))).add(this.enclose(this.maBoneWeight1.y().multiply(this.muBoneMatrix.elementAt(this.castInt(this.maBoneIndex1.y())))).add(this.enclose(this.maBoneWeight1.z().multiply(this.muBoneMatrix.elementAt(this.castInt(this.maBoneIndex1.z())))).add(this.enclose(this.maBoneWeight1.w().multiply(this.muBoneMatrix.elementAt(this.castInt(this.maBoneIndex1.w()))))))));
        if (this.mVertexWeight > 4) {
            this.mgBoneTransfMatrix.assignAdd(this.enclose(this.maBoneWeight2.x().multiply(this.muBoneMatrix.elementAt(this.castInt(this.maBoneIndex2.x())))).add(this.enclose(this.maBoneWeight2.y().multiply(this.muBoneMatrix.elementAt(this.castInt(this.maBoneIndex2.y())))).add(this.enclose(this.maBoneWeight2.z().multiply(this.muBoneMatrix.elementAt(this.castInt(this.maBoneIndex2.z())))).add(this.enclose(this.maBoneWeight2.w().multiply(this.muBoneMatrix.elementAt(this.castInt(this.maBoneIndex2.w()))))))));
        }
    }

    @Override
    public void setLocations(int programHandle) {
        this.muBoneMatrixHandle = this.getUniformLocation(programHandle, SkeletalAnimationMaterialPlugin.SkeletalAnimationShaderVar.U_BONE_MATRIX);
        this.maBoneIndex1Handle = this.getAttribLocation(programHandle, SkeletalAnimationMaterialPlugin.SkeletalAnimationShaderVar.A_BONE_INDEX1);
        this.maBoneWeight1Handle = this.getAttribLocation(programHandle, SkeletalAnimationMaterialPlugin.SkeletalAnimationShaderVar.A_BONE_WEIGHT1);
        if (this.mVertexWeight > 4) {
            this.maBoneIndex2Handle = this.getAttribLocation(programHandle, SkeletalAnimationMaterialPlugin.SkeletalAnimationShaderVar.A_BONE_INDEX2);
            this.maBoneWeight2Handle = this.getAttribLocation(programHandle, SkeletalAnimationMaterialPlugin.SkeletalAnimationShaderVar.A_BONE_WEIGHT2);
        }
    }

    public void setBone1Indices(int boneIndex1BufferHandle) {
        GLES20.glBindBuffer((int)34962, (int)boneIndex1BufferHandle);
        GLES20.glEnableVertexAttribArray((int)this.maBoneIndex1Handle);
        GLES20.glVertexAttribPointer((int)this.maBoneIndex1Handle, (int)4, (int)5126, (boolean)false, (int)0, (int)0);
    }

    public void setBone2Indices(int boneIndex2BufferHandle) {
        GLES20.glBindBuffer((int)34962, (int)boneIndex2BufferHandle);
        GLES20.glEnableVertexAttribArray((int)this.maBoneIndex2Handle);
        GLES20.glVertexAttribPointer((int)this.maBoneIndex2Handle, (int)4, (int)5126, (boolean)false, (int)0, (int)0);
    }

    public void setBone1Weights(int boneWeights1BufferHandle) {
        GLES20.glBindBuffer((int)34962, (int)boneWeights1BufferHandle);
        GLES20.glEnableVertexAttribArray((int)this.maBoneWeight1Handle);
        GLES20.glVertexAttribPointer((int)this.maBoneWeight1Handle, (int)4, (int)5126, (boolean)false, (int)0, (int)0);
    }

    public void setBone2Weights(int boneWeights2BufferHandle) {
        GLES20.glBindBuffer((int)34962, (int)boneWeights2BufferHandle);
        GLES20.glEnableVertexAttribArray((int)this.maBoneWeight2Handle);
        GLES20.glVertexAttribPointer((int)this.maBoneWeight2Handle, (int)4, (int)5126, (boolean)false, (int)0, (int)0);
    }

    public void setBoneMatrix(double[] boneMatrix) {
        if (this.mTempBoneArray == null) {
            this.mTempBoneArray = new float[boneMatrix.length];
        }
        GLES20.glUniformMatrix4fv((int)this.muBoneMatrixHandle, (int)this.mNumJoints, (boolean)false, (float[])ArrayUtils.convertDoublesToFloats(boneMatrix, this.mTempBoneArray), (int)0);
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.IGNORE;
    }
}

