/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders.fragments;

import android.opengl.GLES20;
import java.util.List;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.lights.DirectionalLight;
import org.rajawali3d.lights.PointLight;
import org.rajawali3d.lights.SpotLight;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.util.ArrayUtils;

public class LightsVertexShaderFragment
extends AShader
implements IShaderFragment {
    public static final String SHADER_ID = "LIGHTS_VERTEX";
    private AShaderBase.RVec3[] muLightColor;
    private AShaderBase.RVec3[] muLightPosition;
    private AShaderBase.RVec3[] muLightDirection;
    private AShaderBase.RVec3 muAmbientColor;
    private AShaderBase.RVec3 muAmbientIntensity;
    private AShaderBase.RVec3 mvAmbientColor;
    private AShaderBase.RVec4[] muLightAttenuation;
    private AShaderBase.RFloat[] muLightPower;
    private AShaderBase.RFloat[] muSpotExponent;
    private AShaderBase.RFloat[] muSpotCutoffAngle;
    private AShaderBase.RFloat[] muSpotFalloff;
    private AShaderBase.RFloat[] mvAttenuation;
    private AShaderBase.RVec4 mvEye;
    private AShaderBase.RFloat mgLightDistance;
    private int[] muLightColorHandles;
    private int[] muLightPowerHandles;
    private int[] muLightPositionHandles;
    private int[] muLightDirectionHandles;
    private int[] muLightAttenuationHandles;
    private int[] muSpotExponentHandles;
    private int[] muSpotCutoffAngleHandles;
    private int[] muSpotFalloffHandles;
    protected int muAmbientColorHandle;
    protected int muAmbientIntensityHandle;
    private int mDirLightCount;
    private int mSpotLightCount;
    private int mPointLightCount;
    private List<ALight> mLights;
    protected final float[] mTemp3Floats = new float[3];
    protected final float[] mTemp4Floats = new float[4];
    protected float[] mAmbientColor;
    protected float[] mAmbientIntensity;

    public LightsVertexShaderFragment(List<ALight> lights) {
        super(AShader.ShaderType.VERTEX_SHADER_FRAGMENT);
        this.mLights = lights;
        this.mAmbientColor = new float[]{0.2f, 0.2f, 0.2f};
        this.mAmbientIntensity = new float[]{0.3f, 0.3f, 0.3f};
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        int lightCount = this.mLights.size();
        for (int i = 0; i < lightCount; ++i) {
            if (this.mLights.get(i).getLightType() == 0) {
                ++this.mDirLightCount;
                continue;
            }
            if (this.mLights.get(i).getLightType() == 2) {
                ++this.mSpotLightCount;
                continue;
            }
            if (this.mLights.get(i).getLightType() != 1) continue;
            ++this.mPointLightCount;
        }
        this.muLightColor = new AShaderBase.RVec3[lightCount];
        this.muLightColorHandles = new int[this.muLightColor.length];
        this.muLightPower = new AShaderBase.RFloat[lightCount];
        this.muLightPowerHandles = new int[this.muLightPower.length];
        this.muLightPosition = new AShaderBase.RVec3[lightCount];
        this.muLightPositionHandles = new int[this.muLightPosition.length];
        this.muLightDirection = new AShaderBase.RVec3[this.mDirLightCount + this.mSpotLightCount];
        this.muLightDirectionHandles = new int[this.muLightDirection.length];
        this.muLightAttenuation = new AShaderBase.RVec4[this.mSpotLightCount + this.mPointLightCount];
        this.muLightAttenuationHandles = new int[this.muLightAttenuation.length];
        this.mvAttenuation = new AShaderBase.RFloat[lightCount];
        this.muSpotExponent = new AShaderBase.RFloat[this.mSpotLightCount];
        this.muSpotExponentHandles = new int[this.muSpotExponent.length];
        this.muSpotCutoffAngle = new AShaderBase.RFloat[this.mSpotLightCount];
        this.muSpotCutoffAngleHandles = new int[this.muSpotCutoffAngle.length];
        this.muSpotFalloff = new AShaderBase.RFloat[this.mSpotLightCount];
        this.muSpotFalloffHandles = new int[this.muSpotFalloff.length];
        this.mgLightDistance = (AShaderBase.RFloat)this.addGlobal(LightsShaderVar.G_LIGHT_DISTANCE);
        this.mvEye = (AShaderBase.RVec4)this.addVarying(LightsShaderVar.V_EYE);
        int lightDirCount = 0;
        int lightAttCount = 0;
        int spotCount = 0;
        for (int i = 0; i < this.mLights.size(); ++i) {
            ALight light = this.mLights.get(i);
            int t = light.getLightType();
            this.muLightColor[i] = (AShaderBase.RVec3)this.addUniform((AShaderBase.IGlobalShaderVar)LightsShaderVar.U_LIGHT_COLOR, i);
            this.muLightPower[i] = (AShaderBase.RFloat)this.addUniform((AShaderBase.IGlobalShaderVar)LightsShaderVar.U_LIGHT_POWER, i);
            this.muLightPosition[i] = (AShaderBase.RVec3)this.addUniform((AShaderBase.IGlobalShaderVar)LightsShaderVar.U_LIGHT_POSITION, i);
            this.mvAttenuation[i] = (AShaderBase.RFloat)this.addVarying(LightsShaderVar.V_LIGHT_ATTENUATION, i);
            if (t == 0 || t == 2) {
                this.muLightDirection[lightDirCount] = (AShaderBase.RVec3)this.addUniform((AShaderBase.IGlobalShaderVar)LightsShaderVar.U_LIGHT_DIRECTION, lightDirCount);
                ++lightDirCount;
            }
            if (t == 2 || t == 1) {
                this.muLightAttenuation[lightAttCount] = (AShaderBase.RVec4)this.addUniform((AShaderBase.IGlobalShaderVar)LightsShaderVar.U_LIGHT_ATTENUATION, lightAttCount);
                ++lightAttCount;
            }
            if (t != 2) continue;
            this.muSpotExponent[spotCount] = (AShaderBase.RFloat)this.addUniform((AShaderBase.IGlobalShaderVar)LightsShaderVar.U_SPOT_EXPONENT, spotCount);
            this.muSpotCutoffAngle[spotCount] = (AShaderBase.RFloat)this.addUniform((AShaderBase.IGlobalShaderVar)LightsShaderVar.U_SPOT_CUTOFF_ANGLE, spotCount);
            this.muSpotFalloff[spotCount] = (AShaderBase.RFloat)this.addUniform((AShaderBase.IGlobalShaderVar)LightsShaderVar.U_SPOT_FALLOFF, spotCount);
            ++spotCount;
        }
        this.muAmbientColor = (AShaderBase.RVec3)this.addUniform(LightsShaderVar.U_AMBIENT_COLOR);
        this.muAmbientIntensity = (AShaderBase.RVec3)this.addUniform(LightsShaderVar.U_AMBIENT_INTENSITY);
        this.mvAmbientColor = (AShaderBase.RVec3)this.addVarying(LightsShaderVar.V_AMBIENT_COLOR);
    }

    @Override
    public void main() {
        int lightAttCount = 0;
        AShaderBase.RMat4 modelMatrix = (AShaderBase.RMat4)this.getGlobal(AShaderBase.DefaultShaderVar.U_MODEL_MATRIX);
        AShaderBase.RVec4 position = (AShaderBase.RVec4)this.getGlobal(AShaderBase.DefaultShaderVar.G_POSITION);
        this.mvEye.assign(this.enclose(modelMatrix.multiply(position)));
        this.mvAmbientColor.rgb().assign(this.muAmbientColor.rgb().multiply(this.muAmbientIntensity.rgb()));
        for (int i = 0; i < this.mLights.size(); ++i) {
            ALight light = this.mLights.get(i);
            int t = light.getLightType();
            if (t == 2 || t == 1) {
                this.mgLightDistance.assign(this.distance(this.mvEye.xyz(), this.muLightPosition[i]));
                this.mvAttenuation[i].assign((AShaderBase)this.new AShaderBase.RFloat(1.0).divide(this.enclose(this.muLightAttenuation[lightAttCount].index(1).add(this.muLightAttenuation[lightAttCount].index(2)).multiply(this.mgLightDistance).add(this.muLightAttenuation[lightAttCount].index(3)).multiply(this.mgLightDistance).multiply(this.mgLightDistance))));
                ++lightAttCount;
                continue;
            }
            if (t != 0) continue;
            this.mvAttenuation[i].assign(1.0f);
        }
    }

    @Override
    public String getShaderId() {
        return SHADER_ID;
    }

    @Override
    public void setLocations(int programHandle) {
        int lightDirCount = 0;
        int lightAttCount = 0;
        int spotCount = 0;
        for (int i = 0; i < this.mLights.size(); ++i) {
            ALight light = this.mLights.get(i);
            int t = light.getLightType();
            this.muLightColorHandles[i] = this.getUniformLocation(programHandle, (AShaderBase.IGlobalShaderVar)LightsShaderVar.U_LIGHT_COLOR, i);
            this.muLightPowerHandles[i] = this.getUniformLocation(programHandle, (AShaderBase.IGlobalShaderVar)LightsShaderVar.U_LIGHT_POWER, i);
            this.muLightPositionHandles[i] = this.getUniformLocation(programHandle, (AShaderBase.IGlobalShaderVar)LightsShaderVar.U_LIGHT_POSITION, i);
            if (t == 0 || t == 2) {
                this.muLightDirectionHandles[lightDirCount] = this.getUniformLocation(programHandle, (AShaderBase.IGlobalShaderVar)LightsShaderVar.U_LIGHT_DIRECTION, lightDirCount);
                ++lightDirCount;
            }
            if (t == 2 || t == 1) {
                this.muLightAttenuationHandles[lightAttCount] = this.getUniformLocation(programHandle, (AShaderBase.IGlobalShaderVar)LightsShaderVar.U_LIGHT_ATTENUATION, lightAttCount);
                ++lightAttCount;
            }
            if (t == 2) {
                this.muSpotExponentHandles[spotCount] = this.getUniformLocation(programHandle, (AShaderBase.IGlobalShaderVar)LightsShaderVar.U_SPOT_EXPONENT, spotCount);
                this.muSpotCutoffAngleHandles[spotCount] = this.getUniformLocation(programHandle, (AShaderBase.IGlobalShaderVar)LightsShaderVar.U_SPOT_CUTOFF_ANGLE, spotCount);
                this.muSpotFalloffHandles[spotCount] = this.getUniformLocation(programHandle, (AShaderBase.IGlobalShaderVar)LightsShaderVar.U_SPOT_FALLOFF, spotCount);
                ++spotCount;
            }
            this.muAmbientColorHandle = this.getUniformLocation(programHandle, LightsShaderVar.U_AMBIENT_COLOR);
            this.muAmbientIntensityHandle = this.getUniformLocation(programHandle, LightsShaderVar.U_AMBIENT_INTENSITY);
        }
    }

    @Override
    public void applyParams() {
        super.applyParams();
        int lightCount = this.mLights.size();
        int dirCount = 0;
        int spotCount = 0;
        int attCount = 0;
        for (int i = 0; i < lightCount; ++i) {
            ALight l;
            ALight light = this.mLights.get(i);
            int t = light.getLightType();
            GLES20.glUniform3fv((int)this.muLightColorHandles[i], (int)1, (float[])light.getColor(), (int)0);
            GLES20.glUniform1f((int)this.muLightPowerHandles[i], (float)light.getPower());
            GLES20.glUniform3fv((int)this.muLightPositionHandles[i], (int)1, (float[])ArrayUtils.convertDoublesToFloats(light.getPositionArray(), this.mTemp3Floats), (int)0);
            if (t == 2) {
                l = (SpotLight)light;
                GLES20.glUniform3fv((int)this.muLightDirectionHandles[spotCount], (int)1, (float[])ArrayUtils.convertDoublesToFloats(((DirectionalLight)l).getDirection(), this.mTemp3Floats), (int)0);
                GLES20.glUniform4fv((int)this.muLightAttenuationHandles[attCount], (int)1, (float[])((SpotLight)l).getAttenuation(), (int)0);
                GLES20.glUniform1f((int)this.muSpotCutoffAngleHandles[spotCount], (float)((SpotLight)l).getCutoffAngle());
                GLES20.glUniform1f((int)this.muSpotFalloffHandles[spotCount], (float)((SpotLight)l).getFalloff());
                ++spotCount;
                ++dirCount;
                ++attCount;
                continue;
            }
            if (t == 1) {
                l = (PointLight)light;
                GLES20.glUniform4fv((int)this.muLightAttenuationHandles[attCount], (int)1, (float[])((PointLight)l).getAttenuation(), (int)0);
                ++attCount;
                continue;
            }
            if (t != 0) continue;
            l = (DirectionalLight)light;
            GLES20.glUniform3fv((int)this.muLightDirectionHandles[dirCount], (int)1, (float[])ArrayUtils.convertDoublesToFloats(((DirectionalLight)l).getDirection(), this.mTemp3Floats), (int)0);
            ++dirCount;
        }
        GLES20.glUniform3fv((int)this.muAmbientColorHandle, (int)1, (float[])this.mAmbientColor, (int)0);
        GLES20.glUniform3fv((int)this.muAmbientIntensityHandle, (int)1, (float[])this.mAmbientIntensity, (int)0);
    }

    public void setAmbientColor(float[] ambientColor) {
        this.mAmbientColor[0] = ambientColor[0];
        this.mAmbientColor[1] = ambientColor[1];
        this.mAmbientColor[2] = ambientColor[2];
    }

    public void setAmbientIntensity(float[] ambientIntensity) {
        this.mAmbientIntensity[0] = ambientIntensity[0];
        this.mAmbientIntensity[1] = ambientIntensity[1];
        this.mAmbientIntensity[2] = ambientIntensity[2];
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.IGNORE;
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }

    public static enum LightsShaderVar implements AShaderBase.IGlobalShaderVar
    {
        U_LIGHT_COLOR("uLightColor", AShaderBase.DataType.VEC3),
        U_LIGHT_POWER("uLightPower", AShaderBase.DataType.FLOAT),
        U_LIGHT_POSITION("uLightPosition", AShaderBase.DataType.VEC3),
        U_LIGHT_DIRECTION("uLightDirection", AShaderBase.DataType.VEC3),
        U_LIGHT_ATTENUATION("uLightAttenuation", AShaderBase.DataType.VEC4),
        U_SPOT_EXPONENT("uSpotExponent", AShaderBase.DataType.FLOAT),
        U_SPOT_CUTOFF_ANGLE("uSpotCutoffAngle", AShaderBase.DataType.FLOAT),
        U_SPOT_FALLOFF("uSpotFalloff", AShaderBase.DataType.FLOAT),
        U_AMBIENT_COLOR("uAmbientColor", AShaderBase.DataType.VEC3),
        U_AMBIENT_INTENSITY("uAmbientIntensity", AShaderBase.DataType.VEC3),
        V_LIGHT_ATTENUATION("vLightAttenuation", AShaderBase.DataType.FLOAT),
        V_EYE("vEye", AShaderBase.DataType.VEC4),
        V_AMBIENT_COLOR("vAmbientColor", AShaderBase.DataType.VEC3),
        G_LIGHT_DISTANCE("gLightDistance", AShaderBase.DataType.FLOAT),
        G_LIGHT_DIRECTION("gLightDirection", AShaderBase.DataType.VEC3);

        private String mVarString;
        private AShaderBase.DataType mDataType;

        private LightsShaderVar(String varString, AShaderBase.DataType dataType) {
            this.mVarString = varString;
            this.mDataType = dataType;
        }

        @Override
        public String getVarString() {
            return this.mVarString;
        }

        @Override
        public AShaderBase.DataType getDataType() {
            return this.mDataType;
        }
    }
}

