/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders.fragments;

import java.util.List;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.materials.shaders.fragments.LightsVertexShaderFragment;

public class LightsFragmentShaderFragment
extends AShader
implements IShaderFragment {
    public static final String SHADER_ID = "LIGHTS_FRAGMENT";
    private List<ALight> mLights;
    private AShaderBase.RVec3[] muLightColor;
    private AShaderBase.RVec3[] muLightPosition;
    private AShaderBase.RVec3[] muLightDirection;
    private AShaderBase.RFloat[] mvAttenuation;
    private AShaderBase.RVec4 mvEye;
    private AShaderBase.RFloat[] muLightPower;
    private AShaderBase.RFloat[] muSpotCutoffAngle;
    private AShaderBase.RFloat[] muSpotFalloff;

    public LightsFragmentShaderFragment(List<ALight> lights) {
        super(AShader.ShaderType.FRAGMENT_SHADER_FRAGMENT);
        this.mLights = lights;
        this.initialize();
    }

    @Override
    public void initialize() {
        int i;
        super.initialize();
        int lightCount = this.mLights.size();
        int dirLightCount = 0;
        int spotLightCount = 0;
        int pointLightCount = 0;
        for (i = 0; i < lightCount; ++i) {
            if (this.mLights.get(i).getLightType() == 0) {
                ++dirLightCount;
                continue;
            }
            if (this.mLights.get(i).getLightType() == 2) {
                ++spotLightCount;
                continue;
            }
            if (this.mLights.get(i).getLightType() != 1) continue;
            ++pointLightCount;
        }
        this.muLightPosition = new AShaderBase.RVec3[lightCount];
        this.muLightColor = new AShaderBase.RVec3[lightCount];
        this.muLightPower = new AShaderBase.RFloat[lightCount];
        this.muLightDirection = new AShaderBase.RVec3[dirLightCount + spotLightCount];
        this.muSpotCutoffAngle = new AShaderBase.RFloat[spotLightCount];
        this.muSpotFalloff = new AShaderBase.RFloat[spotLightCount];
        this.mvAttenuation = new AShaderBase.RFloat[lightCount];
        this.mvEye = (AShaderBase.RVec4)this.addVarying(LightsVertexShaderFragment.LightsShaderVar.V_EYE);
        dirLightCount = 0;
        spotLightCount = 0;
        pointLightCount = 0;
        for (i = 0; i < this.mLights.size(); ++i) {
            ALight light = this.mLights.get(i);
            int t = light.getLightType();
            this.muLightPosition[i] = (AShaderBase.RVec3)this.addUniform((AShaderBase.IGlobalShaderVar)LightsVertexShaderFragment.LightsShaderVar.U_LIGHT_POSITION, i);
            this.muLightPower[i] = (AShaderBase.RFloat)this.addUniform((AShaderBase.IGlobalShaderVar)LightsVertexShaderFragment.LightsShaderVar.U_LIGHT_POWER, i);
            this.muLightColor[i] = (AShaderBase.RVec3)this.addUniform((AShaderBase.IGlobalShaderVar)LightsVertexShaderFragment.LightsShaderVar.U_LIGHT_COLOR, i);
            if (t == 0 || t == 2) {
                this.muLightDirection[dirLightCount] = (AShaderBase.RVec3)this.addUniform((AShaderBase.IGlobalShaderVar)LightsVertexShaderFragment.LightsShaderVar.U_LIGHT_DIRECTION, dirLightCount);
                ++dirLightCount;
            }
            if (t == 2) {
                this.muSpotCutoffAngle[spotLightCount] = (AShaderBase.RFloat)this.addUniform((AShaderBase.IGlobalShaderVar)LightsVertexShaderFragment.LightsShaderVar.U_SPOT_CUTOFF_ANGLE, spotLightCount);
                this.muSpotFalloff[spotLightCount] = (AShaderBase.RFloat)this.addUniform((AShaderBase.IGlobalShaderVar)LightsVertexShaderFragment.LightsShaderVar.U_SPOT_FALLOFF, spotLightCount);
                ++spotLightCount;
            }
            this.mvAttenuation[i] = (AShaderBase.RFloat)this.addVarying(LightsVertexShaderFragment.LightsShaderVar.V_LIGHT_ATTENUATION, i);
        }
        this.addVarying(LightsVertexShaderFragment.LightsShaderVar.V_AMBIENT_COLOR);
    }

    @Override
    public void main() {
        int lightDirCount = 0;
        boolean lightAttCount = false;
        int spotCount = 0;
        for (int i = 0; i < this.mLights.size(); ++i) {
            ALight light = this.mLights.get(i);
            int t = light.getLightType();
            AShaderBase.RVec3 lightDir = (AShaderBase)this.new AShaderBase.RVec3("lightDir" + i);
            if (t == 2 || t == 1) {
                lightDir.assign(this.normalize(this.muLightPosition[i].subtract(this.mvEye.xyz())));
                if (t != 2) continue;
                AShaderBase.RVec3 spotDir = (AShaderBase)this.new AShaderBase.RVec3("spotDir" + spotCount);
                spotDir.assign(this.normalize(this.muLightDirection[lightDirCount].multiply(-1.0f)));
                ++lightDirCount;
                AShaderBase.RFloat spotFactor = (AShaderBase)this.new AShaderBase.RFloat("spotFactor" + spotCount);
                spotFactor.assign(this.dot(lightDir, spotDir));
                this.startif(new AShader.Condition((AShaderBase.ShaderVar)this.muSpotCutoffAngle[spotCount], AShader.Operator.LESS_THAN, 180.0f));
                this.startif(new AShader.Condition((AShaderBase.ShaderVar)spotFactor, AShader.Operator.GREATER_THAN_EQUALS, this.cos(this.radians(this.muSpotCutoffAngle[spotCount]))));
                AShaderBase.RFloat exponent = (AShaderBase)this.new AShaderBase.RFloat("exponent");
                exponent.assign(this.subtract(1.0f, this.cos(this.radians(this.muSpotCutoffAngle[spotCount]))));
                exponent.assign(this.divide(Float.valueOf(1.0f), (AShaderBase.ShaderVar)exponent));
                AShaderBase.RFloat facInv = (AShaderBase)this.new AShaderBase.RFloat("facInv");
                facInv.assign(this.subtract(1.0f, (AShaderBase.ShaderVar)spotFactor));
                exponent.assign(facInv.multiply(exponent));
                exponent.assign(this.subtract(1.0f, (AShaderBase.ShaderVar)exponent));
                spotFactor.assign(this.pow(exponent, this.multiply(this.muSpotFalloff[spotCount], this.divide(Float.valueOf(1.0f), (AShaderBase.ShaderVar)exponent))));
                this.ifelse();
                spotFactor.assign(0.0f);
                this.endif();
                lightDir.assign(this.multiply(this.castVec3(lightDir), spotFactor));
                this.endif();
                ++spotCount;
                continue;
            }
            if (t != 0) continue;
            lightDir.assign(this.normalize(this.muLightDirection[lightDirCount].multiply(-1.0f)));
            ++lightDirCount;
        }
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }

    @Override
    public String getShaderId() {
        return SHADER_ID;
    }

    @Override
    public void setLocations(int programHandle) {
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.IGNORE;
    }

    @Override
    public void applyParams() {
    }
}

