/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders;

import android.graphics.Color;
import android.opengl.GLES20;
import java.util.List;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.plugins.SkeletalAnimationMaterialPlugin;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.math.Matrix4;

public class VertexShader
extends AShader {
    private AShaderBase.RMat4 muMVPMatrix;
    private AShaderBase.RMat3 muNormalMatrix;
    private AShaderBase.RMat4 muModelMatrix;
    private AShaderBase.RMat4 muInverseViewMatrix;
    private AShaderBase.RMat4 muModelViewMatrix;
    private AShaderBase.RVec4 muColor;
    private AShaderBase.RVec2 maTextureCoord;
    private AShaderBase.RVec3 maNormal;
    private AShaderBase.RVec4 maPosition;
    private AShaderBase.RVec4 maVertexColor;
    private AShaderBase.RVec2 mvTextureCoord;
    private AShaderBase.RVec3 mvCubeTextureCoord;
    private AShaderBase.RVec3 mvNormal;
    private AShaderBase.RVec4 mvColor;
    private AShaderBase.RVec3 mvEyeDir;
    private AShaderBase.RVec4 mgPosition;
    private AShaderBase.RVec3 mgNormal;
    private AShaderBase.RVec4 mgColor;
    private AShaderBase.RVec2 mgTextureCoord;
    private int muMVPMatrixHandle;
    private int muNormalMatrixHandle;
    private int muModelMatrixHandle;
    private int muInverseViewMatrixHandle;
    private int muModelViewMatrixHandle;
    private int muColorHandle;
    private int muTimeHandle;
    private int maTextureCoordHandle;
    private int maCubeTextureCoordHandle;
    private int maNormalHandle;
    private int maPositionHandle;
    private int maVertexColorBufferHandle;
    private float[] mColor = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
    private float mTime;
    private List<ALight> mLights;
    private boolean mHasCubeMaps;
    private boolean mHasSkyTexture;
    private boolean mUseVertexColors;
    private boolean mTimeEnabled;

    public VertexShader() {
        super(AShader.ShaderType.VERTEX);
    }

    public VertexShader(int resourceId) {
        super(AShader.ShaderType.VERTEX, resourceId);
    }

    public VertexShader(String shaderString) {
        super(AShader.ShaderType.VERTEX, shaderString);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addPreprocessorDirective("#ifdef GL_FRAGMENT_PRECISION_HIGH\n\rprecision highp float;\n\r#else\n\rprecision mediump float;\n\r#endif\n\r");
        this.muMVPMatrix = (AShaderBase.RMat4)this.addUniform(AShaderBase.DefaultShaderVar.U_MVP_MATRIX);
        this.muNormalMatrix = (AShaderBase.RMat3)this.addUniform(AShaderBase.DefaultShaderVar.U_NORMAL_MATRIX);
        this.muModelMatrix = (AShaderBase.RMat4)this.addUniform(AShaderBase.DefaultShaderVar.U_MODEL_MATRIX);
        this.muInverseViewMatrix = (AShaderBase.RMat4)this.addUniform(AShaderBase.DefaultShaderVar.U_INVERSE_VIEW_MATRIX);
        this.muModelViewMatrix = (AShaderBase.RMat4)this.addUniform(AShaderBase.DefaultShaderVar.U_MODEL_VIEW_MATRIX);
        this.muColor = (AShaderBase.RVec4)this.addUniform(AShaderBase.DefaultShaderVar.U_COLOR);
        if (this.mTimeEnabled) {
            this.addUniform(AShaderBase.DefaultShaderVar.U_TIME);
        }
        this.maTextureCoord = (AShaderBase.RVec2)this.addAttribute(AShaderBase.DefaultShaderVar.A_TEXTURE_COORD);
        this.maNormal = (AShaderBase.RVec3)this.addAttribute(AShaderBase.DefaultShaderVar.A_NORMAL);
        this.maPosition = (AShaderBase.RVec4)this.addAttribute(AShaderBase.DefaultShaderVar.A_POSITION);
        if (this.mUseVertexColors) {
            this.maVertexColor = (AShaderBase.RVec4)this.addAttribute(AShaderBase.DefaultShaderVar.A_VERTEX_COLOR);
        }
        this.mvTextureCoord = (AShaderBase.RVec2)this.addVarying(AShaderBase.DefaultShaderVar.V_TEXTURE_COORD);
        if (this.mHasCubeMaps) {
            this.mvCubeTextureCoord = (AShaderBase.RVec3)this.addVarying(AShaderBase.DefaultShaderVar.V_CUBE_TEXTURE_COORD);
        }
        this.mvNormal = (AShaderBase.RVec3)this.addVarying(AShaderBase.DefaultShaderVar.V_NORMAL);
        this.mvColor = (AShaderBase.RVec4)this.addVarying(AShaderBase.DefaultShaderVar.V_COLOR);
        this.mvEyeDir = (AShaderBase.RVec3)this.addVarying(AShaderBase.DefaultShaderVar.V_EYE_DIR);
        this.mgPosition = (AShaderBase.RVec4)this.addGlobal(AShaderBase.DefaultShaderVar.G_POSITION);
        this.mgNormal = (AShaderBase.RVec3)this.addGlobal(AShaderBase.DefaultShaderVar.G_NORMAL);
        this.mgColor = (AShaderBase.RVec4)this.addGlobal(AShaderBase.DefaultShaderVar.G_COLOR);
        this.mgTextureCoord = (AShaderBase.RVec2)this.addGlobal(AShaderBase.DefaultShaderVar.G_TEXTURE_COORD);
    }

    @Override
    public void main() {
        IShaderFragment fragment;
        this.mgPosition.assign(this.maPosition);
        this.mgNormal.assign(this.maNormal);
        this.mgTextureCoord.assign(this.maTextureCoord);
        if (this.mUseVertexColors) {
            this.mgColor.assign(this.maVertexColor);
        } else {
            this.mgColor.assign(this.muColor);
        }
        boolean hasSkeletalAnimation = false;
        for (int i = 0; i < this.mShaderFragments.size(); ++i) {
            fragment = (IShaderFragment)this.mShaderFragments.get(i);
            if (fragment.getInsertLocation() == Material.PluginInsertLocation.POST_TRANSFORM) continue;
            fragment.setStringBuilder(this.mShaderSB);
            fragment.main();
            if (!fragment.getShaderId().equals("SKELETAL_ANIMATION_VERTEX")) continue;
            hasSkeletalAnimation = true;
        }
        if (hasSkeletalAnimation) {
            AShaderBase.RMat4 transfMatrix = (AShaderBase.RMat4)this.getGlobal(SkeletalAnimationMaterialPlugin.SkeletalAnimationShaderVar.G_BONE_TRANSF_MATRIX);
            this.GL_POSITION.assign(this.muMVPMatrix.multiply(transfMatrix).multiply(this.mgPosition));
            this.mvNormal.assign(this.normalize(this.muNormalMatrix.multiply(this.castMat3(transfMatrix)).multiply(this.mgNormal)));
        } else {
            this.GL_POSITION.assign(this.muMVPMatrix.multiply(this.mgPosition));
            this.mvNormal.assign(this.normalize(this.muNormalMatrix.multiply(this.mgNormal)));
        }
        this.mvTextureCoord.assign(this.mgTextureCoord);
        if (this.mHasCubeMaps) {
            this.mvCubeTextureCoord.assign(this.castVec3(this.maPosition));
            if (this.mHasSkyTexture) {
                this.mvCubeTextureCoord.x().assignMultiply(-1.0f);
            }
        }
        this.mvColor.assign(this.mgColor);
        this.mvEyeDir.assign(this.castVec3(this.muModelViewMatrix.multiply(this.mgPosition)));
        for (int i = 0; i < this.mShaderFragments.size(); ++i) {
            fragment = (IShaderFragment)this.mShaderFragments.get(i);
            if (fragment.getInsertLocation() != Material.PluginInsertLocation.POST_TRANSFORM) continue;
            fragment.setStringBuilder(this.mShaderSB);
            fragment.main();
        }
    }

    @Override
    public void applyParams() {
        super.applyParams();
        GLES20.glUniform4fv((int)this.muColorHandle, (int)1, (float[])this.mColor, (int)0);
        GLES20.glUniform1f((int)this.muTimeHandle, (float)this.mTime);
    }

    @Override
    public void setLocations(int programHandle) {
        this.maTextureCoordHandle = this.getAttribLocation(programHandle, AShaderBase.DefaultShaderVar.A_TEXTURE_COORD);
        this.maNormalHandle = this.getAttribLocation(programHandle, AShaderBase.DefaultShaderVar.A_NORMAL);
        this.maPositionHandle = this.getAttribLocation(programHandle, AShaderBase.DefaultShaderVar.A_POSITION);
        if (this.mUseVertexColors) {
            this.maVertexColorBufferHandle = this.getAttribLocation(programHandle, AShaderBase.DefaultShaderVar.A_VERTEX_COLOR);
        }
        this.muMVPMatrixHandle = this.getUniformLocation(programHandle, AShaderBase.DefaultShaderVar.U_MVP_MATRIX);
        this.muNormalMatrixHandle = this.getUniformLocation(programHandle, AShaderBase.DefaultShaderVar.U_NORMAL_MATRIX);
        this.muModelMatrixHandle = this.getUniformLocation(programHandle, AShaderBase.DefaultShaderVar.U_MODEL_MATRIX);
        this.muInverseViewMatrixHandle = this.getUniformLocation(programHandle, AShaderBase.DefaultShaderVar.U_INVERSE_VIEW_MATRIX);
        this.muModelViewMatrixHandle = this.getUniformLocation(programHandle, AShaderBase.DefaultShaderVar.U_MODEL_VIEW_MATRIX);
        this.muColorHandle = this.getUniformLocation(programHandle, AShaderBase.DefaultShaderVar.U_COLOR);
        this.muTimeHandle = this.getUniformLocation(programHandle, AShaderBase.DefaultShaderVar.U_TIME);
        super.setLocations(programHandle);
    }

    public void setVertices(int vertexBufferHandle) {
        this.setVertices(vertexBufferHandle, 5126, 0, 0);
    }

    public void setVertices(int vertexBufferHandle, int type, int stride, int offset) {
        GLES20.glBindBuffer((int)34962, (int)vertexBufferHandle);
        GLES20.glEnableVertexAttribArray((int)this.maPositionHandle);
        GLES20.glVertexAttribPointer((int)this.maPositionHandle, (int)3, (int)type, (boolean)false, (int)stride, (int)offset);
    }

    public void setTextureCoords(int textureCoordBufferHandle) {
        this.setTextureCoords(textureCoordBufferHandle, 5126, 0, 0);
    }

    public void setTextureCoords(int textureCoordBufferHandle, int type, int stride, int offset) {
        if (this.maTextureCoordHandle < 0) {
            return;
        }
        GLES20.glBindBuffer((int)34962, (int)textureCoordBufferHandle);
        GLES20.glEnableVertexAttribArray((int)this.maTextureCoordHandle);
        GLES20.glVertexAttribPointer((int)this.maTextureCoordHandle, (int)2, (int)type, (boolean)false, (int)stride, (int)offset);
    }

    public void setNormals(int normalBufferHandle) {
        this.setNormals(normalBufferHandle, 5126, 0, 0);
    }

    public void setNormals(int normalBufferHandle, int type, int stride, int offset) {
        if (this.maNormalHandle < 0) {
            return;
        }
        GLES20.glBindBuffer((int)34962, (int)normalBufferHandle);
        GLES20.glEnableVertexAttribArray((int)this.maNormalHandle);
        GLES20.glVertexAttribPointer((int)this.maNormalHandle, (int)3, (int)type, (boolean)false, (int)stride, (int)offset);
    }

    public void setVertexColors(int vertexColorBufferHandle) {
        this.setVertexColors(vertexColorBufferHandle, 5126, 0, 0);
    }

    public void setVertexColors(int vertexColorBufferHandle, int type, int stride, int offset) {
        if (this.maVertexColorBufferHandle < 0) {
            return;
        }
        GLES20.glBindBuffer((int)34962, (int)vertexColorBufferHandle);
        GLES20.glEnableVertexAttribArray((int)this.maVertexColorBufferHandle);
        GLES20.glVertexAttribPointer((int)this.maVertexColorBufferHandle, (int)4, (int)type, (boolean)false, (int)stride, (int)offset);
    }

    public void setMVPMatrix(float[] mvpMatrix) {
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixHandle, (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
    }

    public void setModelMatrix(Matrix4 modelMatrix) {
        GLES20.glUniformMatrix4fv((int)this.muModelMatrixHandle, (int)1, (boolean)false, (float[])modelMatrix.getFloatValues(), (int)0);
    }

    public void setNormalMatrix(float[] normalMatrix) {
        GLES20.glUniformMatrix3fv((int)this.muNormalMatrixHandle, (int)1, (boolean)false, (float[])normalMatrix, (int)0);
    }

    public void setInverseViewMatrix(float[] inverseViewMatrix) {
        GLES20.glUniformMatrix4fv((int)this.muInverseViewMatrixHandle, (int)1, (boolean)false, (float[])inverseViewMatrix, (int)0);
    }

    public void setModelViewMatrix(float[] modelViewMatrix) {
        GLES20.glUniformMatrix4fv((int)this.muModelViewMatrixHandle, (int)1, (boolean)false, (float[])modelViewMatrix, (int)0);
    }

    public void setColor(int color) {
        this.mColor[0] = (float)Color.red((int)color) / 255.0f;
        this.mColor[1] = (float)Color.green((int)color) / 255.0f;
        this.mColor[2] = (float)Color.blue((int)color) / 255.0f;
        this.mColor[3] = (float)Color.alpha((int)color) / 255.0f;
    }

    public void setColor(float[] color) {
        this.mColor[0] = color[0];
        this.mColor[1] = color[1];
        this.mColor[2] = color[2];
        this.mColor[3] = color[3];
    }

    public int getColor() {
        return Color.argb((int)((int)(this.mColor[3] * 255.0f)), (int)((int)(this.mColor[0] * 255.0f)), (int)((int)(this.mColor[1] * 255.0f)), (int)((int)(this.mColor[2] * 255.0f)));
    }

    public void setLights(List<ALight> lights) {
        this.mLights = lights;
    }

    public void hasCubeMaps(boolean value) {
        this.mHasCubeMaps = value;
    }

    public void hasSkyTexture(boolean value) {
        this.mHasSkyTexture = value;
    }

    public void useVertexColors(boolean value) {
        this.mUseVertexColors = value;
    }

    public void enableTime(boolean value) {
        this.mTimeEnabled = value;
    }

    public void setTime(float time) {
        this.mTime = time;
    }
}

