/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders;

import android.opengl.GLES20;
import java.util.List;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;

public class FragmentShader
extends AShader {
    private AShaderBase.RFloat muColorInfluence;
    private AShaderBase.RVec2 mvTextureCoord;
    private AShaderBase.RVec3 mvCubeTextureCoord;
    private AShaderBase.RVec3 mvNormal;
    private AShaderBase.RVec4 mvColor;
    private AShaderBase.RVec4 mgColor;
    private AShaderBase.RVec3 mgNormal;
    private AShaderBase.RVec2 mgTextureCoord;
    private AShaderBase.RFloat mgShadowValue;
    private AShaderBase.RFloat mgSpecularValue;
    private int muColorInfluenceHandle;
    private AShaderBase.RMat4 mmInverseView;
    private float mColorInfluence;
    private List<ALight> mLights;
    private boolean mHasCubeMaps;
    private boolean mTimeEnabled;

    public FragmentShader() {
        super(AShader.ShaderType.FRAGMENT);
    }

    public FragmentShader(int resourceId) {
        super(AShader.ShaderType.FRAGMENT, resourceId);
    }

    public FragmentShader(String shaderString) {
        super(AShader.ShaderType.FRAGMENT, shaderString);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addPrecisionQualifier(AShaderBase.DataType.FLOAT, AShaderBase.Precision.HIGHP);
        this.muColorInfluence = (AShaderBase.RFloat)this.addUniform(AShaderBase.DefaultShaderVar.U_COLOR_INFLUENCE);
        if (this.mTimeEnabled) {
            this.addUniform(AShaderBase.DefaultShaderVar.U_TIME);
        }
        this.addUniform(AShaderBase.DefaultShaderVar.U_INVERSE_VIEW_MATRIX);
        this.mvTextureCoord = (AShaderBase.RVec2)this.addVarying(AShaderBase.DefaultShaderVar.V_TEXTURE_COORD);
        if (this.mHasCubeMaps) {
            this.mvCubeTextureCoord = (AShaderBase.RVec3)this.addVarying(AShaderBase.DefaultShaderVar.V_CUBE_TEXTURE_COORD);
        }
        this.mvNormal = (AShaderBase.RVec3)this.addVarying(AShaderBase.DefaultShaderVar.V_NORMAL);
        this.mvColor = (AShaderBase.RVec4)this.addVarying(AShaderBase.DefaultShaderVar.V_COLOR);
        this.addVarying(AShaderBase.DefaultShaderVar.V_EYE_DIR);
        this.mgColor = (AShaderBase.RVec4)this.addGlobal(AShaderBase.DefaultShaderVar.G_COLOR);
        this.mgNormal = (AShaderBase.RVec3)this.addGlobal(AShaderBase.DefaultShaderVar.G_NORMAL);
        this.mgTextureCoord = (AShaderBase.RVec2)this.addGlobal(AShaderBase.DefaultShaderVar.G_TEXTURE_COORD);
        this.mgShadowValue = (AShaderBase.RFloat)this.addGlobal(AShaderBase.DefaultShaderVar.G_SHADOW_VALUE);
        this.mgSpecularValue = (AShaderBase.RFloat)this.addGlobal(AShaderBase.DefaultShaderVar.G_SPECULAR_VALUE);
    }

    @Override
    public void main() {
        this.mgNormal.assign(this.normalize(this.mvNormal));
        this.mgTextureCoord.assign(this.mvTextureCoord);
        this.mgColor.assign(this.muColorInfluence.multiply(this.mvColor));
        this.mgShadowValue.assign(0.0f);
        this.mgSpecularValue.assign(1.0f);
        for (int i = 0; i < this.mShaderFragments.size(); ++i) {
            IShaderFragment fragment = (IShaderFragment)this.mShaderFragments.get(i);
            fragment.setStringBuilder(this.mShaderSB);
            fragment.main();
        }
        this.GL_FRAG_COLOR.assign(this.mgColor);
    }

    @Override
    public void applyParams() {
        super.applyParams();
        GLES20.glUniform1f((int)this.muColorInfluenceHandle, (float)this.mColorInfluence);
    }

    @Override
    public void setLocations(int programHandle) {
        super.setLocations(programHandle);
        this.muColorInfluenceHandle = this.getUniformLocation(programHandle, AShaderBase.DefaultShaderVar.U_COLOR_INFLUENCE);
    }

    public void setLights(List<ALight> lights) {
        this.mLights = lights;
    }

    public void setColorInfluence(float influence) {
        this.mColorInfluence = influence;
    }

    public float getColorInfluence() {
        return this.mColorInfluence;
    }

    public void hasCubeMaps(boolean value) {
        this.mHasCubeMaps = value;
    }

    public void enableTime(boolean value) {
        this.mTimeEnabled = value;
    }
}

