/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders;

import android.opengl.GLES20;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.util.RajLog;
import org.rajawali3d.util.RawShaderLoader;

public abstract class AShader
extends AShaderBase {
    public static String SHADER_ID;
    protected final AShaderBase.GLPosition GL_POSITION = new AShaderBase.GLPosition();
    protected final AShaderBase.GLFragColor GL_FRAG_COLOR = new AShaderBase.GLFragColor();
    protected final AShaderBase.GLFragCoord GL_FRAG_COORD = new AShaderBase.GLFragCoord();
    protected final AShaderBase.GLDepthRange GL_DEPTH_RANGE = new AShaderBase.GLDepthRange();
    protected String mShaderString;
    private ShaderType mShaderType;
    private List<String> mPreprocessorDirectives;
    private Hashtable<String, AShaderBase.ShaderVar> mUniforms;
    private Hashtable<String, AShaderBase.ShaderVar> mAttributes;
    private Hashtable<String, AShaderBase.ShaderVar> mVaryings;
    private Hashtable<String, AShaderBase.ShaderVar> mGlobals;
    private Hashtable<String, AShaderBase.Precision> mPrecisionQualifier;
    private Hashtable<String, AShaderBase.ShaderVar> mConstants;
    protected List<IShaderFragment> mShaderFragments;
    protected int mProgramHandle;
    protected boolean mNeedsBuild = true;

    public AShader() {
    }

    public AShader(ShaderType shaderType) {
        this.mShaderType = shaderType;
    }

    public AShader(ShaderType shaderType, int resourceId) {
        this(shaderType, RawShaderLoader.fetch(resourceId));
    }

    public AShader(ShaderType shaderType, String shaderString) {
        this.mShaderType = shaderType;
        this.mShaderString = shaderString;
        this.mNeedsBuild = false;
    }

    public void initialize() {
        this.mUniforms = new Hashtable();
        this.mAttributes = new Hashtable();
        this.mVaryings = new Hashtable();
        this.mGlobals = new Hashtable();
        this.mPrecisionQualifier = new Hashtable();
        this.mConstants = new Hashtable();
        this.mShaderFragments = new ArrayList<IShaderFragment>();
    }

    public void main() {
    }

    public void addPreprocessorDirective(String directive) {
        if (this.mPreprocessorDirectives == null) {
            this.mPreprocessorDirectives = new ArrayList<String>();
        }
        this.mPreprocessorDirectives.add(directive);
    }

    protected void addPrecisionQualifier(AShaderBase.DataType dataType, AShaderBase.Precision precision) {
        this.mPrecisionQualifier.put(dataType.getTypeString(), precision);
    }

    protected AShaderBase.ShaderVar addUniform(AShaderBase.IGlobalShaderVar var) {
        return this.addUniform(var.getVarString(), var.getDataType());
    }

    protected AShaderBase.ShaderVar addUniform(AShaderBase.IGlobalShaderVar var, int index) {
        return this.addUniform(var.getVarString() + Integer.toString(index), var.getDataType());
    }

    protected AShaderBase.ShaderVar addUniform(AShaderBase.IGlobalShaderVar var, String suffix) {
        return this.addUniform(var.getVarString() + suffix, var.getDataType());
    }

    protected AShaderBase.ShaderVar addUniform(String name, AShaderBase.DataType dataType) {
        AShaderBase.ShaderVar v = this.getInstanceForDataType(name, dataType);
        v.isGlobal(true);
        this.mUniforms.put(v.getName(), v);
        return v;
    }

    public void setUniform1f(String name, float value) {
        int handle = this.getUniformLocation(this.mProgramHandle, name);
        GLES20.glUniform1f((int)handle, (float)value);
    }

    public void setUniform2fv(String name, float[] value) {
        int handle = this.getUniformLocation(this.mProgramHandle, name);
        GLES20.glUniform2fv((int)handle, (int)1, (float[])value, (int)0);
    }

    public void setUniform3fv(String name, float[] value) {
        int handle = this.getUniformLocation(this.mProgramHandle, name);
        GLES20.glUniform3fv((int)handle, (int)1, (float[])value, (int)0);
    }

    public void setUniform1i(String name, int value) {
        int handle = this.getUniformLocation(this.mProgramHandle, name);
        GLES20.glUniform1i((int)handle, (int)value);
    }

    public List<String> getPreprocessorDirectives() {
        return this.mPreprocessorDirectives;
    }

    public Hashtable<String, AShaderBase.ShaderVar> getUniforms() {
        return this.mUniforms;
    }

    protected AShaderBase.ShaderVar addAttribute(AShaderBase.IGlobalShaderVar var) {
        return this.addAttribute(var.getVarString(), var.getDataType());
    }

    protected AShaderBase.ShaderVar addAttribute(String name, AShaderBase.DataType dataType) {
        AShaderBase.ShaderVar v = this.getInstanceForDataType(name, dataType);
        v.isGlobal(true);
        this.mAttributes.put(v.getName(), v);
        return v;
    }

    public Hashtable<String, AShaderBase.ShaderVar> getAttributes() {
        return this.mAttributes;
    }

    protected AShaderBase.ShaderVar addVarying(AShaderBase.IGlobalShaderVar var) {
        return this.addVarying(var.getVarString(), var.getDataType());
    }

    protected AShaderBase.ShaderVar addVarying(AShaderBase.IGlobalShaderVar var, int index) {
        return this.addVarying(var.getVarString() + Integer.toString(index), var.getDataType());
    }

    protected AShaderBase.ShaderVar addVarying(String name, AShaderBase.DataType dataType) {
        AShaderBase.ShaderVar v = this.getInstanceForDataType(name, dataType);
        v.isGlobal(true);
        this.mVaryings.put(v.getName(), v);
        return v;
    }

    public Hashtable<String, AShaderBase.ShaderVar> getVaryings() {
        return this.mVaryings;
    }

    protected AShaderBase.ShaderVar addGlobal(AShaderBase.IGlobalShaderVar var) {
        return this.addGlobal(var.getVarString(), var.getDataType());
    }

    protected AShaderBase.ShaderVar addGlobal(AShaderBase.IGlobalShaderVar var, int index) {
        return this.addGlobal(var.getVarString() + Integer.toString(index), var.getDataType());
    }

    protected AShaderBase.ShaderVar addGlobal(String name, AShaderBase.DataType dataType) {
        AShaderBase.ShaderVar v = this.getInstanceForDataType(name, dataType);
        v.isGlobal(true);
        this.mGlobals.put(v.getName(), v);
        return v;
    }

    public Hashtable<String, AShaderBase.ShaderVar> getGlobals() {
        return this.mGlobals;
    }

    public AShaderBase.ShaderVar getGlobal(AShaderBase.IGlobalShaderVar var) {
        AShaderBase.ShaderVar v = this.getInstanceForDataType(var.getVarString(), var.getDataType());
        v.mInitialized = true;
        return v;
    }

    public AShaderBase.ShaderVar getGlobal(AShaderBase.IGlobalShaderVar var, int index) {
        AShaderBase.ShaderVar v = this.getInstanceForDataType(var.getVarString() + Integer.toString(index), var.getDataType());
        v.mInitialized = true;
        return v;
    }

    protected AShaderBase.ShaderVar addConst(String name, int value) {
        return this.addConst(name, (AShaderBase)this.new AShaderBase.RInt(value));
    }

    protected AShaderBase.ShaderVar addConst(String name, float value) {
        return this.addConst(name, (AShaderBase)this.new AShaderBase.RFloat(value));
    }

    protected AShaderBase.ShaderVar addConst(String name, double value) {
        return this.addConst(name, (float)value);
    }

    protected AShaderBase.ShaderVar addConst(String name, AShaderBase.ShaderVar var) {
        AShaderBase.ShaderVar v = this.getInstanceForDataType(name, var.getDataType());
        v.setValue(var.getValue());
        v.isGlobal(true);
        this.mConstants.put(v.getName(), v);
        return v;
    }

    public Hashtable<String, AShaderBase.ShaderVar> getConsts() {
        return this.mConstants;
    }

    public void setLocations(int programHandle) {
        this.mProgramHandle = programHandle;
        if (this.mShaderFragments != null) {
            for (int i = 0; i < this.mShaderFragments.size(); ++i) {
                this.mShaderFragments.get(i).setLocations(programHandle);
            }
        }
    }

    protected int getUniformLocation(int programHandle, AShaderBase.IGlobalShaderVar var) {
        return this.getUniformLocation(programHandle, var.getVarString());
    }

    protected int getUniformLocation(int programHandle, AShaderBase.IGlobalShaderVar var, int index) {
        return this.getUniformLocation(programHandle, var.getVarString() + Integer.toString(index));
    }

    protected int getUniformLocation(int programHandle, AShaderBase.IGlobalShaderVar var, String suffix) {
        return this.getUniformLocation(programHandle, var.getVarString() + suffix);
    }

    protected int getUniformLocation(int programHandle, String name) {
        int result = GLES20.glGetUniformLocation((int)programHandle, (String)name);
        if (result < 0 && RajLog.isDebugEnabled()) {
            RajLog.e("Getting location of uniform: " + name + " returned -1!");
        }
        return result;
    }

    protected int getAttribLocation(int programHandle, AShaderBase.IGlobalShaderVar var) {
        return this.getAttribLocation(programHandle, var.getVarString());
    }

    protected int getAttribLocation(int programHandle, AShaderBase.IGlobalShaderVar var, int index) {
        return this.getAttribLocation(programHandle, var.getVarString() + Integer.toString(index));
    }

    protected int getAttribLocation(int programHandle, String name) {
        int result = GLES20.glGetAttribLocation((int)programHandle, (String)name);
        return result;
    }

    public void addShaderFragment(IShaderFragment fragment) {
        if (fragment == null) {
            return;
        }
        this.mShaderFragments.add(fragment);
    }

    public IShaderFragment getShaderFragment(String shaderId) {
        for (IShaderFragment frag : this.mShaderFragments) {
            if (!frag.getShaderId().equals(shaderId)) continue;
            return frag;
        }
        return null;
    }

    public ShaderType getShaderType() {
        return this.mShaderType;
    }

    public void setStringBuilder(StringBuilder stringBuilder) {
        this.mShaderSB = stringBuilder;
    }

    public String getShaderString() {
        return this.mShaderString;
    }

    public void buildShader() {
        StringBuilder s = this.mShaderSB = new StringBuilder();
        if (this.mPreprocessorDirectives != null) {
            for (String directive : this.mPreprocessorDirectives) {
                s.append(directive).append("\n");
            }
        }
        for (IShaderFragment frag : this.mShaderFragments) {
            List<String> preprocessorDirectives;
            if (!(frag instanceof AShader) || (preprocessorDirectives = frag.getPreprocessorDirectives()) == null) continue;
            for (String directive : preprocessorDirectives) {
                s.append(directive).append("\n");
            }
        }
        Set<Map.Entry<String, AShaderBase.Precision>> precisionSet = this.mPrecisionQualifier.entrySet();
        for (Map.Entry<String, AShaderBase.Precision> e : precisionSet) {
            s.append("precision ").append(e.getValue().getPrecisionString()).append(" ").append(e.getKey()).append(";\n");
        }
        Hashtable<String, AShaderBase.ShaderVar> consts = new Hashtable<String, AShaderBase.ShaderVar>(this.mConstants);
        for (int i = 0; i < this.mShaderFragments.size(); ++i) {
            IShaderFragment fragment = this.mShaderFragments.get(i);
            if (fragment.getConsts() == null) continue;
            consts.putAll(fragment.getConsts());
        }
        Set<Map.Entry<String, AShaderBase.ShaderVar>> set = consts.entrySet();
        for (Map.Entry<String, AShaderBase.ShaderVar> e : set) {
            AShaderBase.ShaderVar var = e.getValue();
            String arrayStr = var.isArray() ? "[" + var.getArraySize() + "]" : "";
            s.append("const ").append(var.mDataType.getTypeString()).append(" ").append(var.mName).append(arrayStr).append(" = ").append(var.getValue()).append(";\n");
        }
        Hashtable<String, AShaderBase.ShaderVar> uniforms = new Hashtable<String, AShaderBase.ShaderVar>(this.mUniforms);
        for (int i = 0; i < this.mShaderFragments.size(); ++i) {
            IShaderFragment fragment = this.mShaderFragments.get(i);
            if (fragment.getUniforms() == null) continue;
            uniforms.putAll(fragment.getUniforms());
        }
        set = uniforms.entrySet();
        for (Map.Entry<String, AShaderBase.ShaderVar> e : set) {
            AShaderBase.ShaderVar var = e.getValue();
            String arrayStr = var.isArray() ? "[" + var.getArraySize() + "]" : "";
            s.append("uniform ").append(var.mDataType.getTypeString()).append(" ").append(var.mName).append(arrayStr).append(";\n");
        }
        Hashtable<String, AShaderBase.ShaderVar> attributes = new Hashtable<String, AShaderBase.ShaderVar>(this.mAttributes);
        for (int i = 0; i < this.mShaderFragments.size(); ++i) {
            IShaderFragment fragment = this.mShaderFragments.get(i);
            if (fragment.getAttributes() == null) continue;
            attributes.putAll(fragment.getAttributes());
        }
        set = attributes.entrySet();
        for (Map.Entry<String, AShaderBase.ShaderVar> e : set) {
            AShaderBase.ShaderVar var = e.getValue();
            s.append("attribute ").append(var.mDataType.getTypeString()).append(" ").append(var.mName).append(";\n");
        }
        Hashtable<String, AShaderBase.ShaderVar> varyings = new Hashtable<String, AShaderBase.ShaderVar>(this.mVaryings);
        for (int i = 0; i < this.mShaderFragments.size(); ++i) {
            IShaderFragment fragment = this.mShaderFragments.get(i);
            if (fragment.getVaryings() == null) continue;
            varyings.putAll(fragment.getVaryings());
        }
        set = varyings.entrySet();
        for (Map.Entry<String, AShaderBase.ShaderVar> e : set) {
            AShaderBase.ShaderVar var = e.getValue();
            String arrayStr = var.isArray() ? "[" + var.getArraySize() + "]" : "";
            s.append("varying ").append(var.mDataType.getTypeString()).append(" ").append(var.mName).append(arrayStr).append(";\n");
        }
        Hashtable<String, AShaderBase.ShaderVar> globals = new Hashtable<String, AShaderBase.ShaderVar>(this.mGlobals);
        for (int i = 0; i < this.mShaderFragments.size(); ++i) {
            IShaderFragment fragment = this.mShaderFragments.get(i);
            if (fragment.getGlobals() == null) continue;
            globals.putAll(fragment.getGlobals());
        }
        set = globals.entrySet();
        for (Map.Entry<String, AShaderBase.ShaderVar> e : set) {
            AShaderBase.ShaderVar var = e.getValue();
            String arrayStr = var.isArray() ? "[" + var.getArraySize() + "]" : "";
            s.append(var.mDataType.getTypeString()).append(" ").append(var.mName).append(arrayStr).append(";\n");
        }
        s.append("\nvoid main() {\n");
        this.main();
        s.append("}\n");
        this.mShaderString = s.toString();
        s = null;
    }

    public void applyParams() {
        if (this.mShaderFragments != null) {
            for (int i = 0; i < this.mShaderFragments.size(); ++i) {
                this.mShaderFragments.get(i).applyParams();
            }
        }
    }

    public int getProgramHandle() {
        return this.mProgramHandle;
    }

    public AShaderBase.ShaderVar subtract(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar var = this.getInstanceForDataType(var1.getDataType());
        var.setName(var1.getName() + " - " + var2.getName());
        var.mInitialized = true;
        return var;
    }

    public AShaderBase.ShaderVar subtract(float value1, AShaderBase.ShaderVar var2) {
        return this.subtract((AShaderBase)this.new AShaderBase.RFloat(Float.toString(value1)), var2);
    }

    public AShaderBase.ShaderVar divide(Float value1, AShaderBase.ShaderVar var2) {
        return this.divide((AShaderBase)this.new AShaderBase.RFloat(Float.toString(value1.floatValue())), var2);
    }

    public AShaderBase.ShaderVar divide(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar var = this.getInstanceForDataType(var1.getDataType());
        var.setName(var1.getName() + " / " + var2.getName());
        var.mInitialized = true;
        return var;
    }

    public AShaderBase.ShaderVar multiply(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar var = this.getInstanceForDataType(var1.getDataType());
        var.setName(var1.getName() + " * " + var2.getName());
        var.mInitialized = true;
        return var;
    }

    public AShaderBase.ShaderVar max(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar var = this.getInstanceForDataType(var1.getDataType());
        var.setName("max(" + var1.getName() + ", " + var2.getName() + ")");
        var.mInitialized = true;
        return var;
    }

    public AShaderBase.ShaderVar max(AShaderBase.ShaderVar var1, float value2) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("max(" + var1.getName() + ", " + Float.toString(value2) + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar min(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar var = this.getInstanceForDataType(var1.getDataType());
        var.setName("min(" + var1.getName() + ", " + var2.getName() + ")");
        var.mInitialized = true;
        return var;
    }

    public AShaderBase.ShaderVar min(AShaderBase.ShaderVar var1, float value2) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("min(" + var1.getName() + ", " + Float.toString(value2) + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public String normalize(String value) {
        return "normalize(" + value + ")";
    }

    public String normalize(AShaderBase.ShaderVar value) {
        return this.normalize(value.getName());
    }

    public AShaderBase.ShaderVar sqrt(AShaderBase.ShaderVar var) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("sqrt(" + var.getName() + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar inversesqrt(AShaderBase.ShaderVar var) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("inversesqrt(" + var.getName() + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar texture1D(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("texture1D(" + var1.getName() + ", " + var2.getName() + ")", AShaderBase.DataType.VEC4);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar texture2D(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("texture2D(" + var1.getName() + ", " + var2.getName() + ")", AShaderBase.DataType.VEC4);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar texture3D(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("texture3D(" + var1.getName() + ", " + var2.getName() + ")", AShaderBase.DataType.VEC4);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar textureCube(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("textureCube(" + var1.getName() + ", " + var2.getName() + ")", AShaderBase.DataType.VEC4);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.RVec4 texture2DProj(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.RVec4 s = (AShaderBase)this.new AShaderBase.RVec4("texture2DProj(" + var1.getName() + ", " + var2.getName() + ")", AShaderBase.DataType.VEC4);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar distance(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("distance(" + var1.getName() + ", " + var2.getName() + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar clamp(AShaderBase.ShaderVar var, float value1, float value2) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("clamp(" + var.getName() + ", " + Float.toString(value1) + ", " + Float.toString(value2) + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar mix(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2, float value) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("mix(" + var1.getName() + ", " + var2.getName() + ", " + Float.toString(value) + ")", AShaderBase.DataType.VEC3);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar mix(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2, AShaderBase.ShaderVar var3) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("mix(" + var1.getName() + ", " + var2.getName() + ", " + var3.getName() + ")", AShaderBase.DataType.VEC3);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar dot(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("dot(" + var1.getName() + ", " + var2.getName() + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar cos(AShaderBase.ShaderVar var) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("cos(" + var.getName() + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar acos(AShaderBase.ShaderVar var) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("acos(" + var.getName() + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar sin(AShaderBase.ShaderVar var) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("sin(" + var.getName() + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar tan(AShaderBase.ShaderVar var) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("tan(" + var.getName() + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar atan(AShaderBase.ShaderVar y, AShaderBase.ShaderVar x) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("atan(" + y.getName() + ", " + x.getName() + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar pow(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("pow(" + var1.getName() + ", " + var2.getName() + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar mod(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("mod(" + var1.getName() + ", " + var2.getName() + ")", var1.getDataType());
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar length(AShaderBase.ShaderVar var) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("length(" + var.getName() + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar floor(AShaderBase.ShaderVar var) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("floor(" + var.getName() + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar radians(AShaderBase.ShaderVar var) {
        AShaderBase.ShaderVar s = (AShaderBase)this.new AShaderBase.ShaderVar("radians(" + var.getName() + ")", AShaderBase.DataType.FLOAT);
        s.mInitialized = true;
        return s;
    }

    public AShaderBase.ShaderVar reflect(AShaderBase.ShaderVar var1, AShaderBase.ShaderVar var2) {
        AShaderBase.ShaderVar var = this.getInstanceForDataType(var1.getDataType());
        var.setName("reflect(" + var1.getName() + ", " + var2.getName() + ")");
        var.mInitialized = true;
        return var;
    }

    public void discard() {
        this.mShaderSB.append("discard;\n");
    }

    public void startif(Condition ... conditions) {
        this.mShaderSB.append("if(");
        for (int i = 0; i < conditions.length; ++i) {
            Condition condition = conditions[i];
            if (i > 0) {
                this.mShaderSB.append(condition.getJoinOperator().getOperatorString());
            }
            this.mShaderSB.append(condition.getLeftValue().getVarName());
            this.mShaderSB.append(condition.getOperator().getOperatorString());
            this.mShaderSB.append(condition.getRightValue());
        }
        this.mShaderSB.append(")\n{\n");
    }

    public void startif(Condition condition) {
        this.mShaderSB.append("if(");
        this.mShaderSB.append(condition.getLeftValue().getVarName());
        this.mShaderSB.append(condition.getOperator().getOperatorString());
        this.mShaderSB.append(condition.getRightValue());
        this.mShaderSB.append(")\n{\n");
    }

    public void ifelseif(Condition ... conditions) {
        this.mShaderSB.append("} else ");
        this.mShaderSB.append("if(");
        for (int i = 0; i < conditions.length; ++i) {
            Condition condition = conditions[i];
            if (i > 0) {
                this.mShaderSB.append(condition.getJoinOperator().getOperatorString());
            }
            this.mShaderSB.append(condition.getLeftValue().getVarName());
            this.mShaderSB.append(condition.getOperator().getOperatorString());
            this.mShaderSB.append(condition.getRightValue());
        }
        this.mShaderSB.append(")\n{\n");
    }

    public void ifelseif(Condition condition) {
        this.mShaderSB.append("} else ");
        this.mShaderSB.append("if(");
        this.mShaderSB.append(condition.getLeftValue().getVarName());
        this.mShaderSB.append(condition.getOperator().getOperatorString());
        this.mShaderSB.append(condition.getRightValue());
        this.mShaderSB.append(")\n{\n");
    }

    public void ifelse() {
        this.mShaderSB.append("} else {\n");
    }

    public void endif() {
        this.mShaderSB.append("}\n");
    }

    public AShaderBase.ShaderVar castInt(float value) {
        return this.castInt(Float.toString(value));
    }

    public AShaderBase.ShaderVar castInt(AShaderBase.ShaderVar value) {
        return this.castInt(value.getVarName());
    }

    public AShaderBase.ShaderVar castInt(String value) {
        AShaderBase.ShaderVar v = (AShaderBase)this.new AShaderBase.ShaderVar("int(" + value + ")", AShaderBase.DataType.INT);
        v.mInitialized = true;
        return v;
    }

    public AShaderBase.ShaderVar castVec2(float x) {
        return this.castVec2(Float.toString(x));
    }

    public AShaderBase.ShaderVar castVec2(float x, float y) {
        return this.castVec2(Float.toString(x), Float.toString(y));
    }

    public AShaderBase.ShaderVar castVec2(String x, String y) {
        AShaderBase.ShaderVar v = (AShaderBase)this.new AShaderBase.ShaderVar("vec2(" + x + ", " + y + ")", AShaderBase.DataType.VEC2);
        v.mInitialized = true;
        return v;
    }

    public AShaderBase.ShaderVar castVec2(AShaderBase.ShaderVar x, AShaderBase.ShaderVar y) {
        return this.castVec2(x.getVarName(), y.getVarName());
    }

    public AShaderBase.ShaderVar castVec2(String x) {
        AShaderBase.ShaderVar v = (AShaderBase)this.new AShaderBase.ShaderVar("vec2(" + x + ")", AShaderBase.DataType.VEC2);
        v.mInitialized = true;
        return v;
    }

    public AShaderBase.ShaderVar castVec2(AShaderBase.ShaderVar x) {
        return this.castVec2(x.getVarName());
    }

    public AShaderBase.ShaderVar castVec3(float x, float y, float z) {
        return this.castVec3((AShaderBase)this.new AShaderBase.RFloat(x), (AShaderBase)this.new AShaderBase.RFloat(y), (AShaderBase)this.new AShaderBase.RFloat(z));
    }

    public AShaderBase.ShaderVar castVec3(AShaderBase.ShaderVar x, AShaderBase.ShaderVar y, AShaderBase.ShaderVar z) {
        AShaderBase.ShaderVar v = new AShaderBase.ShaderVar(AShaderBase.DataType.VEC3);
        v.setValue("vec3(" + x.getName() + ", " + y.getName() + ", " + z.getName() + ")");
        v.mInitialized = true;
        return v;
    }

    public AShaderBase.ShaderVar castVec3(String var) {
        AShaderBase.ShaderVar v = (AShaderBase)this.new AShaderBase.ShaderVar("vec3(" + var + ")", AShaderBase.DataType.VEC3);
        v.mInitialized = true;
        return v;
    }

    public AShaderBase.ShaderVar castVec3(AShaderBase.ShaderVar var) {
        return this.castVec3(var.getVarName());
    }

    public AShaderBase.ShaderVar castVec4(float value) {
        return this.castVec4(Float.toString(value));
    }

    public AShaderBase.ShaderVar castVec4(AShaderBase.ShaderVar var) {
        return this.castVec4(var.getVarName());
    }

    public AShaderBase.ShaderVar castVec4(String var) {
        AShaderBase.ShaderVar v = (AShaderBase)this.new AShaderBase.ShaderVar("vec4(" + var + ")", AShaderBase.DataType.VEC4);
        v.mInitialized = true;
        return v;
    }

    public AShaderBase.ShaderVar castVec4(AShaderBase.ShaderVar var, float value) {
        return this.castVec4(var.getVarName(), value);
    }

    public AShaderBase.ShaderVar castVec4(String var, float value) {
        AShaderBase.ShaderVar v = (AShaderBase)this.new AShaderBase.ShaderVar("vec4(" + var + ", " + value + ")", AShaderBase.DataType.VEC4);
        v.mInitialized = true;
        return v;
    }

    public AShaderBase.ShaderVar castMat3(float value) {
        return this.castMat3((AShaderBase)this.new AShaderBase.RFloat(value));
    }

    public AShaderBase.ShaderVar castMat3(AShaderBase.ShaderVar var) {
        AShaderBase.ShaderVar v = (AShaderBase)this.new AShaderBase.ShaderVar("mat3(" + var.getName() + ")", AShaderBase.DataType.MAT3);
        v.mInitialized = true;
        return v;
    }

    public AShaderBase.ShaderVar castMat4(float value) {
        return this.castMat4((AShaderBase)this.new AShaderBase.RFloat(Float.toString(value)));
    }

    public AShaderBase.ShaderVar castMat4(AShaderBase.ShaderVar var) {
        AShaderBase.ShaderVar v = (AShaderBase)this.new AShaderBase.ShaderVar("mat4(" + var.getName() + ")", AShaderBase.DataType.MAT3);
        v.mInitialized = true;
        return v;
    }

    public AShaderBase.ShaderVar enclose(AShaderBase.ShaderVar value) {
        AShaderBase.ShaderVar var = this.getReturnTypeForOperation(value.getDataType(), value.getDataType());
        var.setValue("(" + value.getName() + ")");
        var.setName(var.getValue());
        return var;
    }

    public boolean needsBuild() {
        return this.mNeedsBuild;
    }

    public void setNeedsBuild(boolean needsBuild) {
        this.mNeedsBuild = needsBuild;
    }

    public static class Condition {
        private AShaderBase.ShaderVar mLeftValue;
        private Operator mOperator;
        private String mRightValue;
        private Operator mJoinOperator;

        public Condition(Operator joinOperator, AShaderBase.ShaderVar leftValue, Operator operator, String rightValue) {
            this.mJoinOperator = joinOperator;
            this.mLeftValue = leftValue;
            this.mOperator = operator;
            this.mRightValue = rightValue;
        }

        public Condition(Operator joinOperator, AShaderBase.ShaderVar leftValue, Operator operator, AShaderBase.ShaderVar rightValue) {
            this(joinOperator, leftValue, operator, rightValue.getName());
        }

        public Condition(Operator joinOperator, AShaderBase.ShaderVar leftValue, Operator operator, float rightValue) {
            this(joinOperator, leftValue, operator, Float.toString(rightValue));
        }

        public Condition(Operator joinOperator, AShaderBase.ShaderVar leftValue, Operator operator, boolean rightValue) {
            this(joinOperator, leftValue, operator, rightValue ? "true" : "false");
        }

        public Condition(AShaderBase.ShaderVar leftValue, Operator operator, String rightValue) {
            this(null, leftValue, operator, rightValue);
        }

        public Condition(AShaderBase.ShaderVar leftValue, Operator operator, AShaderBase.ShaderVar rightValue) {
            this(leftValue, operator, rightValue.getName());
        }

        public Condition(AShaderBase.ShaderVar leftValue, Operator operator, float rightValue) {
            this(leftValue, operator, Float.toString(rightValue));
        }

        public Condition(AShaderBase.ShaderVar leftValue, Operator operator, boolean rightValue) {
            this(leftValue, operator, rightValue ? "true" : "false");
        }

        public AShaderBase.ShaderVar getLeftValue() {
            return this.mLeftValue;
        }

        public Operator getOperator() {
            return this.mOperator;
        }

        public String getRightValue() {
            return this.mRightValue;
        }

        public Operator getJoinOperator() {
            return this.mJoinOperator;
        }
    }

    public static enum Operator {
        LESS_THAN("<"),
        LESS_THAN_EQUALS("<="),
        GREATER_THAN(">"),
        GREATER_THAN_EQUALS(">="),
        EQUALS("=="),
        NOT_EQUALS("!="),
        AND("&&"),
        OR("||"),
        XOR("^^");

        private String mOperatorString;

        private Operator(String operatorString) {
            this.mOperatorString = operatorString;
        }

        public String getOperatorString() {
            return this.mOperatorString;
        }
    }

    public static enum ShaderType {
        VERTEX,
        FRAGMENT,
        VERTEX_SHADER_FRAGMENT,
        FRAGMENT_SHADER_FRAGMENT;

    }
}

