/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.plugins;

import android.opengl.GLES20;
import android.os.SystemClock;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.plugins.IMaterialPlugin;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;

public class SpriteSheetMaterialPlugin
implements IMaterialPlugin {
    private SpriteSheetVertexShaderFragment mVertexShader = new SpriteSheetVertexShaderFragment();

    public SpriteSheetMaterialPlugin(int numTilesX, int numTilesY, float fps, int numFrames) {
        this.mVertexShader.setNumTiles(numTilesX, numTilesY);
        this.mVertexShader.setFPS(fps);
        this.mVertexShader.setNumFrames(numFrames);
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.PRE_LIGHTING;
    }

    @Override
    public IShaderFragment getVertexShaderFragment() {
        return this.mVertexShader;
    }

    @Override
    public IShaderFragment getFragmentShaderFragment() {
        return null;
    }

    public void play() {
        this.mVertexShader.play();
    }

    public void pause() {
        this.mVertexShader.pause();
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }

    private final class SpriteSheetVertexShaderFragment
    extends AShader
    implements IShaderFragment {
        public static final String SHADER_ID = "SPRITE_SHEET_VERTEX_SHADER_FRAGMENT";
        private static final String U_CURRENT_FRAME = "uCurrentFrame";
        private static final String U_NUM_TILES = "uNumTiles";
        private AShaderBase.RFloat muCurrentFrame;
        private AShaderBase.RVec2 muNumTiles;
        private int muCurrentFrameHandle;
        private int muNumTilesHandle;
        private float mCurrentFrame;
        private float[] mNumTiles;
        private long mStartTime;
        private boolean mIsPlaying;
        private float mFPS;
        private int mNumFrames;

        public SpriteSheetVertexShaderFragment() {
            super(AShader.ShaderType.VERTEX_SHADER_FRAGMENT);
            this.mNumTiles = new float[2];
            this.mIsPlaying = false;
            this.mFPS = 30.0f;
            this.initialize();
        }

        @Override
        public void initialize() {
            super.initialize();
            this.muCurrentFrame = (AShaderBase.RFloat)this.addUniform(U_CURRENT_FRAME, AShaderBase.DataType.FLOAT);
            this.muNumTiles = (AShaderBase.RVec2)this.addUniform(U_NUM_TILES, AShaderBase.DataType.VEC2);
        }

        @Override
        public void setLocations(int programHandle) {
            this.muCurrentFrameHandle = this.getUniformLocation(programHandle, U_CURRENT_FRAME);
            this.muNumTilesHandle = this.getUniformLocation(programHandle, U_NUM_TILES);
        }

        @Override
        public void applyParams() {
            super.applyParams();
            if (this.mIsPlaying) {
                this.mCurrentFrame = (int)Math.floor((float)(SystemClock.elapsedRealtime() - this.mStartTime) * (this.mFPS / 1000.0f)) % this.mNumFrames;
            }
            GLES20.glUniform1f((int)this.muCurrentFrameHandle, (float)this.mCurrentFrame);
            GLES20.glUniform2fv((int)this.muNumTilesHandle, (int)1, (float[])this.mNumTiles, (int)0);
        }

        @Override
        public void main() {
            AShaderBase.RVec2 gTextureCoord = (AShaderBase.RVec2)this.getGlobal(AShaderBase.DefaultShaderVar.G_TEXTURE_COORD);
            AShaderBase.RFloat tileSizeX = (AShaderBase)this.new AShaderBase.RFloat("tileSizeX");
            tileSizeX.assign(1.0f / this.mNumTiles[0]);
            AShaderBase.RFloat tileSizeY = (AShaderBase)this.new AShaderBase.RFloat("tileSizeY");
            tileSizeY.assign(1.0f / this.mNumTiles[1]);
            AShaderBase.RFloat texSOffset = (AShaderBase)this.new AShaderBase.RFloat("texSOffset", gTextureCoord.s().multiply(tileSizeX));
            AShaderBase.RFloat texTOffset = (AShaderBase)this.new AShaderBase.RFloat("texTOffset", gTextureCoord.t().multiply(tileSizeY));
            gTextureCoord.s().assign(this.mod(this.muCurrentFrame, this.muNumTiles.x()).multiply(tileSizeX).add(texSOffset));
            gTextureCoord.t().assign(tileSizeY.multiply(this.floor(this.muCurrentFrame.divide(this.muNumTiles.y()))).add(texTOffset));
        }

        public void setNumTiles(float numTilesX, float numTilesY) {
            this.mNumTiles[0] = numTilesX;
            this.mNumTiles[1] = numTilesY;
        }

        public void setFPS(float fps) {
            this.mFPS = fps;
        }

        public void setNumFrames(int numFrames) {
            this.mNumFrames = numFrames;
        }

        public void play() {
            this.mStartTime = SystemClock.elapsedRealtime();
            this.mIsPlaying = true;
        }

        public void pause() {
            this.mIsPlaying = false;
        }

        @Override
        public String getShaderId() {
            return SHADER_ID;
        }

        @Override
        public Material.PluginInsertLocation getInsertLocation() {
            return Material.PluginInsertLocation.IGNORE;
        }

        @Override
        public void bindTextures(int nextIndex) {
        }

        @Override
        public void unbindTextures() {
        }
    }
}

