/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.plugins;

import android.opengl.GLES20;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.plugins.IMaterialPlugin;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.vector.Vector3;

public class ShadowMapMaterialPlugin
implements IMaterialPlugin {
    private static final String U_LIGHT_MVP_MATRIX = "uLightMVPMatrix";
    private static final String U_SHADOW_MAP_TEX = "uShadowMapTex";
    private static final String U_SHADOW_INFLUENCE = "uShadowInfluence";
    private static final String U_SHADOW_LIGHT_DIR = "uShadowLightDir";
    private static final String V_SHADOW_TEX_COORD = "vShadowTexCoord";
    private static final String C_BIAS_MATRIX = "cBiasMatrix";
    private static final String C_SHADOW_BIAS = "cShadowBias";
    private ShadowMapVertexShaderFragment mVertexShader = new ShadowMapVertexShaderFragment();
    private ShadowMapFragmentShaderFragment mFragmentShader = new ShadowMapFragmentShaderFragment();
    private float mShadowInfluence;
    private Vector3 mLightDir;

    public ShadowMapMaterialPlugin() {
        this(0.4f);
    }

    public ShadowMapMaterialPlugin(float shadowInfluence) {
        this.mShadowInfluence = shadowInfluence;
    }

    public void setShadowInfluence(float influence) {
        this.mShadowInfluence = influence;
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.PRE_LIGHTING;
    }

    @Override
    public IShaderFragment getVertexShaderFragment() {
        return this.mVertexShader;
    }

    @Override
    public IShaderFragment getFragmentShaderFragment() {
        return this.mFragmentShader;
    }

    public void setShadowMapTexture(ATexture shadowMapTexture) {
        this.mFragmentShader.setShadowMapTexture(shadowMapTexture);
    }

    public void setLightModelViewProjectionMatrix(Matrix4 lightModelViewProjectionMatrix) {
        this.mVertexShader.setLightModelViewProjectionMatrix(lightModelViewProjectionMatrix);
    }

    @Override
    public void bindTextures(int nextIndex) {
        this.mFragmentShader.bindTextures(nextIndex);
    }

    @Override
    public void unbindTextures() {
        this.mFragmentShader.unbindTextures();
    }

    public void setLightDirection(Vector3 lightDirection) {
        this.mLightDir = lightDirection;
    }

    private final class ShadowMapFragmentShaderFragment
    extends AShader
    implements IShaderFragment {
        public static final String SHADER_ID = "SHADOW_MAP_FRAGMENT_SHADER_FRAGMENT";
        private AShaderBase.RSampler2D muShadowMapTexture;
        private AShaderBase.RFloat muShadowInfluence;
        private AShaderBase.RVec3 muShadowLightDir;
        private AShaderBase.RVec4 mvShadowTexCoord;
        private AShaderBase.RFloat mcShadowBias;
        private int muShadowMapTextureHandle;
        private int muShadowInfluenceHandle;
        private int muShadowLightDirHandle;
        private ATexture mShadowMapTexture;

        public ShadowMapFragmentShaderFragment() {
            super(AShader.ShaderType.FRAGMENT_SHADER_FRAGMENT);
            this.initialize();
        }

        @Override
        public Material.PluginInsertLocation getInsertLocation() {
            return Material.PluginInsertLocation.PRE_LIGHTING;
        }

        @Override
        public String getShaderId() {
            return SHADER_ID;
        }

        public void setShadowMapTexture(ATexture shadowMapTexture) {
            this.mShadowMapTexture = shadowMapTexture;
        }

        @Override
        public void initialize() {
            super.initialize();
            this.mvShadowTexCoord = (AShaderBase.RVec4)this.addVarying(ShadowMapMaterialPlugin.V_SHADOW_TEX_COORD, AShaderBase.DataType.VEC4);
            this.muShadowMapTexture = (AShaderBase.RSampler2D)this.addUniform(ShadowMapMaterialPlugin.U_SHADOW_MAP_TEX, AShaderBase.DataType.SAMPLER2D);
            this.muShadowInfluence = (AShaderBase.RFloat)this.addUniform(ShadowMapMaterialPlugin.U_SHADOW_INFLUENCE, AShaderBase.DataType.FLOAT);
            this.muShadowLightDir = (AShaderBase.RVec3)this.addUniform(ShadowMapMaterialPlugin.U_SHADOW_LIGHT_DIR, AShaderBase.DataType.VEC3);
            this.mcShadowBias = (AShaderBase.RFloat)this.addConst(ShadowMapMaterialPlugin.C_SHADOW_BIAS, 0.005f);
        }

        @Override
        public void applyParams() {
            super.applyParams();
            GLES20.glUniform1f((int)this.muShadowInfluenceHandle, (float)ShadowMapMaterialPlugin.this.mShadowInfluence);
            GLES20.glUniform3f((int)this.muShadowLightDirHandle, (float)((float)((ShadowMapMaterialPlugin)ShadowMapMaterialPlugin.this).mLightDir.x), (float)((float)((ShadowMapMaterialPlugin)ShadowMapMaterialPlugin.this).mLightDir.y), (float)((float)((ShadowMapMaterialPlugin)ShadowMapMaterialPlugin.this).mLightDir.z));
        }

        @Override
        public void setLocations(int programHandle) {
            this.muShadowMapTextureHandle = this.getUniformLocation(programHandle, ShadowMapMaterialPlugin.U_SHADOW_MAP_TEX);
            this.muShadowInfluenceHandle = this.getUniformLocation(programHandle, ShadowMapMaterialPlugin.U_SHADOW_INFLUENCE);
            this.muShadowLightDirHandle = this.getUniformLocation(programHandle, ShadowMapMaterialPlugin.U_SHADOW_LIGHT_DIR);
        }

        @Override
        public void main() {
            AShaderBase.RVec4 lightDepthCol = (AShaderBase)this.new AShaderBase.RVec4("lightDepthCol");
            lightDepthCol.assign(this.texture2D(this.muShadowMapTexture, this.mvShadowTexCoord.xy()));
            AShaderBase.ShaderVar gShadowValue = this.getGlobal(AShaderBase.DefaultShaderVar.G_SHADOW_VALUE);
            AShaderBase.ShaderVar gSpecularValue = this.getGlobal(AShaderBase.DefaultShaderVar.G_SPECULAR_VALUE);
            AShaderBase.RVec3 gNormal = (AShaderBase.RVec3)this.getGlobal(AShaderBase.DefaultShaderVar.G_NORMAL);
            AShaderBase.RFloat shadowLightAngle = (AShaderBase)this.new AShaderBase.RFloat("shadowLightAngle");
            shadowLightAngle.assign(this.dot(gNormal, this.muShadowLightDir));
            this.startif(new AShader.Condition(lightDepthCol.z(), AShader.Operator.LESS_THAN, this.mvShadowTexCoord.z().subtract(this.mcShadowBias)), new AShader.Condition(AShader.Operator.AND, (AShaderBase.ShaderVar)shadowLightAngle, AShader.Operator.LESS_THAN_EQUALS, -0.15f));
            gShadowValue.assign(this.muShadowInfluence);
            gSpecularValue.assign(0.0f);
            this.endif();
        }

        @Override
        public void bindTextures(int nextIndex) {
            if (this.mShadowMapTexture != null) {
                GLES20.glActiveTexture((int)(33984 + nextIndex));
                GLES20.glBindTexture((int)this.mShadowMapTexture.getGLTextureType(), (int)this.mShadowMapTexture.getTextureId());
                GLES20.glUniform1i((int)this.muShadowMapTextureHandle, (int)nextIndex);
            }
        }

        @Override
        public void unbindTextures() {
            if (this.mShadowMapTexture != null) {
                GLES20.glBindTexture((int)this.mShadowMapTexture.getGLTextureType(), (int)0);
            }
        }
    }

    private final class ShadowMapVertexShaderFragment
    extends AShader
    implements IShaderFragment {
        public static final String SHADER_ID = "SHADOW_MAP_VERTEX_SHADER_FRAGMENT";
        private AShaderBase.RMat4 mcBiasMatrix;
        private AShaderBase.RMat4 muLightModelViewProjectionMatrix;
        private AShaderBase.RVec4 mvShadowTexCoord;
        private int muLightModelViewProjectionMatrixHandle;
        private float[] mLightModelViewProjectionMatrix;
        private Matrix4 mLightModelViewProjectionMatrix4;

        public ShadowMapVertexShaderFragment() {
            super(AShader.ShaderType.VERTEX_SHADER_FRAGMENT);
            this.mLightModelViewProjectionMatrix = new float[16];
            this.initialize();
        }

        @Override
        public Material.PluginInsertLocation getInsertLocation() {
            return Material.PluginInsertLocation.PRE_TRANSFORM;
        }

        @Override
        public String getShaderId() {
            return SHADER_ID;
        }

        public void setLightModelViewProjectionMatrix(Matrix4 lightModelViewProjectionMatrix) {
            this.mLightModelViewProjectionMatrix4 = lightModelViewProjectionMatrix;
        }

        @Override
        public void initialize() {
            super.initialize();
            AShaderBase.RMat4 biasMatrix = new AShaderBase.RMat4();
            biasMatrix.setValue(0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f);
            this.mcBiasMatrix = (AShaderBase.RMat4)this.addConst(ShadowMapMaterialPlugin.C_BIAS_MATRIX, biasMatrix);
            this.muLightModelViewProjectionMatrix = (AShaderBase.RMat4)this.addUniform(ShadowMapMaterialPlugin.U_LIGHT_MVP_MATRIX, AShaderBase.DataType.MAT4);
            this.mvShadowTexCoord = (AShaderBase.RVec4)this.addVarying(ShadowMapMaterialPlugin.V_SHADOW_TEX_COORD, AShaderBase.DataType.VEC4);
        }

        @Override
        public void setLocations(int programHandle) {
            this.muLightModelViewProjectionMatrixHandle = this.getUniformLocation(programHandle, ShadowMapMaterialPlugin.U_LIGHT_MVP_MATRIX);
        }

        @Override
        public void applyParams() {
            super.applyParams();
            this.mLightModelViewProjectionMatrix4.toFloatArray(this.mLightModelViewProjectionMatrix);
            GLES20.glUniformMatrix4fv((int)this.muLightModelViewProjectionMatrixHandle, (int)1, (boolean)false, (float[])this.mLightModelViewProjectionMatrix, (int)0);
        }

        @Override
        public void main() {
            AShaderBase.ShaderVar position = this.getGlobal(AShaderBase.DefaultShaderVar.A_POSITION);
            AShaderBase.ShaderVar modelMatrix = this.getGlobal(AShaderBase.DefaultShaderVar.U_MODEL_MATRIX);
            this.mvShadowTexCoord.assign(this.muLightModelViewProjectionMatrix.multiply(modelMatrix.multiply(position)));
            this.mvShadowTexCoord.assign(this.mcBiasMatrix.multiply(this.mvShadowTexCoord));
        }

        @Override
        public void bindTextures(int nextIndex) {
            ShadowMapMaterialPlugin.this.mFragmentShader.bindTextures(nextIndex);
        }

        @Override
        public void unbindTextures() {
            ShadowMapMaterialPlugin.this.mFragmentShader.unbindTextures();
        }
    }
}

