/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.plugins;

import android.graphics.Color;
import android.opengl.GLES20;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.plugins.IMaterialPlugin;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;

public class FogMaterialPlugin
implements IMaterialPlugin {
    private FogVertexShaderFragment mVertexShader = new FogVertexShaderFragment();
    private FogFragmentShaderFragment mFragmentShader;

    public FogMaterialPlugin(FogParams fogParams) {
        this.mVertexShader.setFogParams(fogParams);
        this.mFragmentShader = new FogFragmentShaderFragment();
        this.mFragmentShader.setFogParams(fogParams);
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.POST_TRANSFORM;
    }

    @Override
    public IShaderFragment getVertexShaderFragment() {
        return this.mVertexShader;
    }

    @Override
    public IShaderFragment getFragmentShaderFragment() {
        return this.mFragmentShader;
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }

    private final class FogFragmentShaderFragment
    extends AShader
    implements IShaderFragment {
        public static final String SHADER_ID = "FOG_FRAGMENT_SHADER_FRAGMENT";
        private static final String V_FOG_DENSITY = "vFogDensity";
        private static final String U_FOG_COLOR = "uFogColor";
        private AShaderBase.RVec3 muFogColor;
        private AShaderBase.RFloat mvFogDensity;
        private int muFogColorHandle;
        private FogParams mFogParams;

        public FogFragmentShaderFragment() {
            super(AShader.ShaderType.FRAGMENT_SHADER_FRAGMENT);
            this.initialize();
        }

        public void setFogParams(FogParams fogParams) {
            this.mFogParams = fogParams;
        }

        @Override
        public void initialize() {
            super.initialize();
            this.muFogColor = (AShaderBase.RVec3)this.addUniform(U_FOG_COLOR, AShaderBase.DataType.VEC3);
            this.mvFogDensity = (AShaderBase.RFloat)this.addVarying(V_FOG_DENSITY, AShaderBase.DataType.FLOAT);
        }

        @Override
        public void setLocations(int programHandle) {
            this.muFogColorHandle = this.getUniformLocation(programHandle, U_FOG_COLOR);
        }

        @Override
        public void applyParams() {
            super.applyParams();
            GLES20.glUniform3fv((int)this.muFogColorHandle, (int)1, (float[])this.mFogParams.mFogColor, (int)0);
        }

        @Override
        public void main() {
            AShaderBase.RVec4 color = (AShaderBase.RVec4)this.getGlobal(AShaderBase.DefaultShaderVar.G_COLOR);
            color.rgb().assign(this.mix(color.rgb(), (AShaderBase.ShaderVar)this.muFogColor, this.mvFogDensity));
        }

        @Override
        public Material.PluginInsertLocation getInsertLocation() {
            return Material.PluginInsertLocation.PRE_TRANSFORM;
        }

        @Override
        public String getShaderId() {
            return SHADER_ID;
        }

        @Override
        public void bindTextures(int nextIndex) {
        }

        @Override
        public void unbindTextures() {
        }
    }

    private final class FogVertexShaderFragment
    extends AShader
    implements IShaderFragment {
        public static final String SHADER_ID = "FOG_VERTEX_SHADER_FRAGMENT";
        private static final String U_FOG_NEAR = "uFogNear";
        private static final String U_FOG_FAR = "uFogFar";
        private static final String U_FOG_ENABLED = "uFogEnabled";
        private static final String V_FOG_DENSITY = "vFogDensity";
        private AShaderBase.RFloat muFogNear;
        private AShaderBase.RFloat muFogFar;
        private AShaderBase.RBool muFogEnabled;
        private AShaderBase.RFloat mvFogDensity;
        private int muFogNearHandle;
        private int muFogFarHandle;
        private int muFogEnabledHandle;
        private FogParams mFogParams;
        private boolean mFogEnabled;

        public FogVertexShaderFragment() {
            super(AShader.ShaderType.VERTEX_SHADER_FRAGMENT);
            this.mFogEnabled = true;
            this.initialize();
        }

        public void setFogParams(FogParams fogParams) {
            this.mFogParams = fogParams;
        }

        @Override
        public void initialize() {
            super.initialize();
            this.muFogNear = (AShaderBase.RFloat)this.addUniform(U_FOG_NEAR, AShaderBase.DataType.FLOAT);
            this.muFogFar = (AShaderBase.RFloat)this.addUniform(U_FOG_FAR, AShaderBase.DataType.FLOAT);
            this.muFogEnabled = (AShaderBase.RBool)this.addUniform(U_FOG_ENABLED, AShaderBase.DataType.BOOL);
            this.mvFogDensity = (AShaderBase.RFloat)this.addVarying(V_FOG_DENSITY, AShaderBase.DataType.FLOAT);
        }

        @Override
        public void setLocations(int programHandle) {
            this.muFogNearHandle = this.getUniformLocation(programHandle, U_FOG_NEAR);
            this.muFogFarHandle = this.getUniformLocation(programHandle, U_FOG_FAR);
            this.muFogEnabledHandle = this.getUniformLocation(programHandle, U_FOG_ENABLED);
        }

        @Override
        public void applyParams() {
            super.applyParams();
            GLES20.glUniform1f((int)this.muFogNearHandle, (float)this.mFogParams.mNear);
            GLES20.glUniform1f((int)this.muFogFarHandle, (float)this.mFogParams.mFar);
            GLES20.glUniform1i((int)this.muFogEnabledHandle, (int)1);
        }

        @Override
        public void main() {
            this.mvFogDensity.assign(0.0f);
            this.startif(new AShader.Condition((AShaderBase.ShaderVar)this.muFogEnabled, AShader.Operator.EQUALS, true));
            this.mvFogDensity.assign(this.enclose(this.GL_POSITION.z().subtract(this.muFogNear)).divide(this.enclose(this.muFogFar.subtract(this.muFogNear))));
            this.mvFogDensity.assign(this.clamp(this.mvFogDensity, 0.0f, 1.0f));
            this.endif();
        }

        @Override
        public Material.PluginInsertLocation getInsertLocation() {
            return Material.PluginInsertLocation.POST_TRANSFORM;
        }

        @Override
        public String getShaderId() {
            return SHADER_ID;
        }

        @Override
        public void bindTextures(int nextIndex) {
        }

        @Override
        public void unbindTextures() {
        }
    }

    public static final class FogParams {
        private FogType mFogType;
        private float mNear;
        private float mFar;
        private float[] mFogColor;

        public FogParams(FogType fogType, int fogColor, float near, float far) {
            this.mFogType = fogType;
            this.mFogColor = new float[]{(float)Color.red((int)fogColor) / 255.0f, (float)Color.green((int)fogColor) / 255.0f, (float)Color.blue((int)fogColor) / 255.0f};
            this.mNear = near;
            this.mFar = far;
        }
    }

    public static enum FogType {
        LINEAR;

    }
}

