/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.plugins;

import android.opengl.GLES20;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.plugins.IMaterialPlugin;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;

public class DepthMaterialPlugin
implements IMaterialPlugin {
    private DepthFragmentShaderFragment mFragmentShader = new DepthFragmentShaderFragment();

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.PRE_TRANSFORM;
    }

    @Override
    public IShaderFragment getVertexShaderFragment() {
        return null;
    }

    @Override
    public IShaderFragment getFragmentShaderFragment() {
        return this.mFragmentShader;
    }

    public void setFarPlane(float farPlane) {
        this.mFragmentShader.setFarPlane(farPlane);
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }

    private final class DepthFragmentShaderFragment
    extends AShader
    implements IShaderFragment {
        public static final String SHADER_ID = "DEPTH_FRAGMENT_SHADER_FRAGMENT";
        private static final String U_FAR_PLANE = "uFarPlane";
        private AShaderBase.RFloat muFarPlane;
        private int muFarPlaneHandle;
        private float mFarPlane;

        public DepthFragmentShaderFragment() {
            super(AShader.ShaderType.FRAGMENT_SHADER_FRAGMENT);
            this.initialize();
        }

        @Override
        public void bindTextures(int nextIndex) {
        }

        @Override
        public void unbindTextures() {
        }

        @Override
        public void initialize() {
            super.initialize();
            this.muFarPlane = (AShaderBase.RFloat)this.addUniform(U_FAR_PLANE, AShaderBase.DataType.FLOAT);
        }

        @Override
        public void setLocations(int programHandle) {
            this.muFarPlaneHandle = this.getUniformLocation(programHandle, U_FAR_PLANE);
        }

        @Override
        public void applyParams() {
            super.applyParams();
            GLES20.glUniform1f((int)this.muFarPlaneHandle, (float)this.mFarPlane);
        }

        @Override
        public void main() {
            AShaderBase.RVec4 color = (AShaderBase.RVec4)this.getGlobal(AShaderBase.DefaultShaderVar.G_COLOR);
            AShaderBase.RFloat depth = (AShaderBase)this.new AShaderBase.RFloat("depth");
            depth.assign(1.0f);
            depth.assignSubtract(this.enclose(this.GL_FRAG_COORD.z().divide(this.GL_FRAG_COORD.w())).divide(this.muFarPlane));
            color.r().assign(depth);
            color.g().assign(depth);
            color.b().assign(depth);
        }

        @Override
        public Material.PluginInsertLocation getInsertLocation() {
            return Material.PluginInsertLocation.PRE_TRANSFORM;
        }

        @Override
        public String getShaderId() {
            return SHADER_ID;
        }

        public void setFarPlane(float farPlane) {
            this.mFarPlane = farPlane;
        }
    }
}

