/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.plugins;

import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.plugins.IMaterialPlugin;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;

public class AlphaMaskMaterialPlugin
implements IMaterialPlugin {
    private float mAlphaThreshold = 0.5f;
    private IShaderFragment mFragmentShader;

    public AlphaMaskMaterialPlugin(float alphaThreshold) {
        this.mAlphaThreshold = alphaThreshold;
        this.mFragmentShader = new AlphaMaskShaderFragment();
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.PRE_LIGHTING;
    }

    @Override
    public IShaderFragment getVertexShaderFragment() {
        return null;
    }

    @Override
    public IShaderFragment getFragmentShaderFragment() {
        return this.mFragmentShader;
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }

    private final class AlphaMaskShaderFragment
    extends AShader
    implements IShaderFragment {
        public static final String SHADER_ID = "ALPHA_MASK_FRAGMENT_SHADER_FRAGMENT";

        private AlphaMaskShaderFragment() {
        }

        @Override
        public Material.PluginInsertLocation getInsertLocation() {
            return Material.PluginInsertLocation.PRE_LIGHTING;
        }

        @Override
        public String getShaderId() {
            return SHADER_ID;
        }

        @Override
        public void bindTextures(int nextIndex) {
        }

        @Override
        public void unbindTextures() {
        }

        @Override
        public void main() {
            AShaderBase.RVec4 color = (AShaderBase.RVec4)this.getGlobal(AShaderBase.DefaultShaderVar.G_COLOR);
            this.startif(new AShader.Condition(color.a(), AShader.Operator.LESS_THAN_EQUALS, AlphaMaskMaterialPlugin.this.mAlphaThreshold));
            this.discard();
            this.endif();
        }
    }
}

