/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.methods;

import java.util.List;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.materials.methods.ISpecularMethod;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.materials.shaders.fragments.specular.PhongFragmentShaderFragment;
import org.rajawali3d.materials.textures.ATexture;

public abstract class SpecularMethod {

    public static final class Phong
    implements ISpecularMethod {
        private int mSpecularColor;
        private float mShininess;
        private float mIntensity = 1.0f;
        private List<ALight> mLights;
        private List<ATexture> mTextures;
        private PhongFragmentShaderFragment mFragmentShader;

        public Phong() {
            this(-1, 96.0f);
        }

        public Phong(int specularColor) {
            this(specularColor, 96.0f);
        }

        public Phong(int specularColor, float shininess) {
            this(specularColor, shininess, 1.0f);
        }

        public Phong(int specularColor, float shininess, float intensity) {
            this.mSpecularColor = specularColor;
            this.mShininess = shininess;
            this.mIntensity = intensity;
        }

        @Override
        public IShaderFragment getVertexShaderFragment() {
            return null;
        }

        @Override
        public IShaderFragment getFragmentShaderFragment() {
            if (this.mFragmentShader == null) {
                this.mFragmentShader = new PhongFragmentShaderFragment(this.mLights, this.mSpecularColor, this.mShininess, this.mIntensity, this.mTextures);
            }
            return this.mFragmentShader;
        }

        @Override
        public void setLights(List<ALight> lights) {
            this.mLights = lights;
        }

        public void setSpecularColor(int specularColor) {
            this.mSpecularColor = specularColor;
            if (this.mFragmentShader != null) {
                this.mFragmentShader.setSpecularColor(specularColor);
            }
        }

        public int getSpecularColor() {
            return this.mSpecularColor;
        }

        public void setShininess(float shininess) {
            this.mShininess = shininess;
            if (this.mFragmentShader != null) {
                this.mFragmentShader.setShininess(shininess);
            }
        }

        public float getShininess() {
            return this.mShininess;
        }

        public void setIntensity(float intensity) {
            this.mIntensity = intensity;
        }

        public float getIntensity() {
            return this.mIntensity;
        }

        @Override
        public void setTextures(List<ATexture> textures) {
            this.mTextures = textures;
        }
    }

    public static enum SpecularShaderVar implements AShaderBase.IGlobalShaderVar
    {
        U_SPECULAR_COLOR("uSpecularColor", AShaderBase.DataType.VEC3),
        U_SPECULAR_INTENSITY("uSpecularIntensity", AShaderBase.DataType.FLOAT),
        U_SHININESS("uShininess", AShaderBase.DataType.FLOAT);

        private String mVarString;
        private AShaderBase.DataType mDataType;

        private SpecularShaderVar(String varString, AShaderBase.DataType dataType) {
            this.mVarString = varString;
            this.mDataType = dataType;
        }

        @Override
        public String getVarString() {
            return this.mVarString;
        }

        @Override
        public AShaderBase.DataType getDataType() {
            return this.mDataType;
        }
    }
}

