/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.methods;

import android.graphics.Color;
import android.support.annotation.NonNull;
import java.util.List;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.materials.methods.IDiffuseMethod;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.materials.shaders.fragments.diffuse.LambertFragmentShaderFragment;
import org.rajawali3d.materials.shaders.fragments.diffuse.LambertVertexShaderFragment;
import org.rajawali3d.materials.shaders.fragments.effects.ToonFragmentShaderFragment;

public abstract class DiffuseMethod {

    public static final class Toon
    implements IDiffuseMethod {
        private float[] mToonColor0 = new float[]{1.0f, 0.5f, 0.5f, 1.0f};
        private float[] mToonColor1 = new float[]{0.6f, 0.3f, 0.3f, 1.0f};
        private float[] mToonColor2 = new float[]{0.4f, 0.2f, 0.2f, 1.0f};
        private float[] mToonColor3 = new float[]{0.2f, 0.1f, 0.1f, 1.0f};
        private List<ALight> mLights;
        private ToonFragmentShaderFragment mFragmentShader;

        public Toon() {
        }

        public Toon(int toonColor0, int toonColor1, int toonColor2, int toonColor3) {
            this();
            this.setToonColors(toonColor0, toonColor1, toonColor2, toonColor3);
        }

        @Override
        public IShaderFragment getVertexShaderFragment() {
            return null;
        }

        @Override
        public IShaderFragment getFragmentShaderFragment() {
            if (this.mFragmentShader == null) {
                this.mFragmentShader = new ToonFragmentShaderFragment(this.mLights);
                this.mFragmentShader.setToonColors(this.mToonColor0, this.mToonColor1, this.mToonColor2, this.mToonColor3);
            }
            return this.mFragmentShader;
        }

        @Override
        public void setLights(List<ALight> lights) {
            this.mLights = lights;
        }

        public void setToonColors(int color0, int color1, int color2, int color3) {
            this.mToonColor0[0] = (float)Color.red((int)color0) / 255.0f;
            this.mToonColor0[1] = (float)Color.green((int)color0) / 255.0f;
            this.mToonColor0[2] = (float)Color.blue((int)color0) / 255.0f;
            this.mToonColor0[3] = (float)Color.alpha((int)color0) / 255.0f;
            this.mToonColor1[0] = (float)Color.red((int)color1) / 255.0f;
            this.mToonColor1[1] = (float)Color.green((int)color1) / 255.0f;
            this.mToonColor1[2] = (float)Color.blue((int)color1) / 255.0f;
            this.mToonColor1[3] = (float)Color.alpha((int)color1) / 255.0f;
            this.mToonColor2[0] = (float)Color.red((int)color2) / 255.0f;
            this.mToonColor2[1] = (float)Color.green((int)color2) / 255.0f;
            this.mToonColor2[2] = (float)Color.blue((int)color2) / 255.0f;
            this.mToonColor2[3] = (float)Color.alpha((int)color2) / 255.0f;
            this.mToonColor3[0] = (float)Color.red((int)color3) / 255.0f;
            this.mToonColor3[1] = (float)Color.green((int)color3) / 255.0f;
            this.mToonColor3[2] = (float)Color.blue((int)color3) / 255.0f;
            this.mToonColor3[3] = (float)Color.alpha((int)color3) / 255.0f;
            if (this.mFragmentShader != null) {
                this.mFragmentShader.setToonColors(this.mToonColor0, this.mToonColor1, this.mToonColor2, this.mToonColor3);
            }
        }

        @NonNull
        public String toString() {
            return "[" + this.mToonColor0[0] + "," + this.mToonColor0[1] + "," + this.mToonColor0[2] + "," + this.mToonColor0[3] + "]\n[" + this.mToonColor1[0] + "," + this.mToonColor1[1] + "," + this.mToonColor1[2] + "," + this.mToonColor1[3] + "]\n[" + this.mToonColor2[0] + "," + this.mToonColor2[1] + "," + this.mToonColor2[2] + "," + this.mToonColor2[3] + "]\n[" + this.mToonColor3[0] + "," + this.mToonColor3[1] + "," + this.mToonColor3[2] + "," + this.mToonColor3[3] + "]\n";
        }
    }

    public static final class Lambert
    implements IDiffuseMethod {
        private float mIntensity;
        private List<ALight> mLights;

        public Lambert() {
            this(0.8f);
        }

        public Lambert(float intensity) {
            this.mIntensity = intensity;
        }

        public float getIntensity() {
            return this.mIntensity;
        }

        public void setIntensity(float intensity) {
            this.mIntensity = intensity;
        }

        @Override
        public IShaderFragment getVertexShaderFragment() {
            return new LambertVertexShaderFragment();
        }

        @Override
        public IShaderFragment getFragmentShaderFragment() {
            return new LambertFragmentShaderFragment(this.mLights);
        }

        @Override
        public void setLights(List<ALight> lights) {
            this.mLights = lights;
        }
    }

    public static enum DiffuseShaderVar implements AShaderBase.IGlobalShaderVar
    {
        L_NDOTL("NdotL", AShaderBase.DataType.FLOAT);

        private String mVarString;
        private AShaderBase.DataType mDataType;

        private DiffuseShaderVar(String varString, AShaderBase.DataType dataType) {
            this.mVarString = varString;
            this.mDataType = dataType;
        }

        @Override
        public String getVarString() {
            return this.mVarString;
        }

        @Override
        public AShaderBase.DataType getDataType() {
            return this.mDataType;
        }
    }
}

