/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.rajawali3d.materials.AResourceManager;
import org.rajawali3d.materials.Material;
import org.rajawali3d.renderer.Renderer;

public class MaterialManager
extends AResourceManager {
    private static MaterialManager instance = null;
    private List<Material> mMaterialList = Collections.synchronizedList(new CopyOnWriteArrayList());

    private MaterialManager() {
        this.mRenderers = Collections.synchronizedList(new CopyOnWriteArrayList());
    }

    public static MaterialManager getInstance() {
        if (instance == null) {
            instance = new MaterialManager();
        }
        return instance;
    }

    public Material addMaterial(Material material) {
        if (material == null) {
            return null;
        }
        for (Material mat : this.mMaterialList) {
            if (mat != material) continue;
            return material;
        }
        this.mRenderer.addMaterial(material);
        this.mMaterialList.add(material);
        return material;
    }

    public void taskAdd(Material material) {
        material.setOwnerIdentity(this.mRenderer.getClass().toString());
        material.add();
    }

    public void removeMaterial(Material material) {
        if (material == null) {
            return;
        }
        this.mRenderer.removeMaterial(material);
    }

    public void taskRemove(Material material) {
        material.remove();
        this.mMaterialList.remove(material);
    }

    public void reload() {
        this.mRenderer.reloadMaterials();
    }

    public void taskReload() {
        for (Material material : this.mMaterialList) {
            material.reload();
        }
    }

    public void reset() {
        this.mRenderer.resetMaterials();
    }

    public void taskReset() {
        int count = this.mMaterialList.size();
        for (int i = 0; i < count; ++i) {
            Material material = this.mMaterialList.get(i);
            if (material.getOwnerIdentity() == null || !material.getOwnerIdentity().equals(this.mRenderer.getClass().toString())) continue;
            material.remove();
            this.mMaterialList.remove(i);
            --i;
            --count;
        }
        if (this.mRenderers.size() > 0) {
            this.mRenderer = (Renderer)this.mRenderers.get(this.mRenderers.size() - 1);
            this.reload();
        } else {
            this.mMaterialList.clear();
        }
    }

    public void taskReset(Renderer renderer) {
        if (this.mRenderers.size() == 0) {
            this.taskReset();
        }
    }

    public int getMaterialCount() {
        return this.mMaterialList.size();
    }
}

