/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials;

import android.graphics.Color;
import android.opengl.GLES20;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rajawali3d.BufferInfo;
import org.rajawali3d.Object3D;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.materials.methods.IDiffuseMethod;
import org.rajawali3d.materials.methods.ISpecularMethod;
import org.rajawali3d.materials.plugins.IMaterialPlugin;
import org.rajawali3d.materials.shaders.FragmentShader;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.materials.shaders.VertexShader;
import org.rajawali3d.materials.shaders.fragments.LightsFragmentShaderFragment;
import org.rajawali3d.materials.shaders.fragments.LightsVertexShaderFragment;
import org.rajawali3d.materials.shaders.fragments.texture.AlphaMapFragmentShaderFragment;
import org.rajawali3d.materials.shaders.fragments.texture.DiffuseTextureFragmentShaderFragment;
import org.rajawali3d.materials.shaders.fragments.texture.EnvironmentMapFragmentShaderFragment;
import org.rajawali3d.materials.shaders.fragments.texture.NormalMapFragmentShaderFragment;
import org.rajawali3d.materials.shaders.fragments.texture.SkyTextureFragmentShaderFragment;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.CubeMapTexture;
import org.rajawali3d.materials.textures.SphereMapTexture;
import org.rajawali3d.materials.textures.TextureManager;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.util.Capabilities;
import org.rajawali3d.util.RajLog;

public class Material {
    private final boolean mCapabilitiesCheckDeferred;
    private VertexShader mVertexShader;
    private FragmentShader mFragmentShader;
    private LightsVertexShaderFragment mLightsVertexShaderFragment;
    private IDiffuseMethod mDiffuseMethod;
    private ISpecularMethod mSpecularMethod;
    private boolean mUseVertexColors;
    private boolean mLightingEnabled;
    private boolean mTimeEnabled;
    private boolean mIsDirty = true;
    private int mProgramHandle = -1;
    private int mVShaderHandle;
    private int mFShaderHandle;
    private Matrix4 mModelMatrix;
    private float[] mInverseViewMatrix;
    private float[] mModelViewMatrix;
    private float[] mColor;
    private float[] mAmbientColor;
    private float[] mAmbientIntensity;
    private float mColorInfluence = 1.0f;
    private float mTime;
    protected List<ALight> mLights;
    protected List<IMaterialPlugin> mPlugins;
    protected String mOwnerIdentity;
    private int mMaxTextures;
    protected ArrayList<ATexture> mTextureList;
    protected Map<String, Integer> mTextureHandles;
    protected final float[] mNormalFloats = new float[9];
    protected Matrix4 mNormalMatrix = new Matrix4();
    protected VertexShader mCustomVertexShader;
    protected FragmentShader mCustomFragmentShader;

    public Material() {
        this(false);
    }

    public Material(boolean deferCapabilitiesCheck) {
        this.mCapabilitiesCheckDeferred = deferCapabilitiesCheck;
        this.mTextureList = new ArrayList();
        this.mTextureHandles = new HashMap<String, Integer>();
        this.mMaxTextures = this.mCapabilitiesCheckDeferred ? Integer.MAX_VALUE : Capabilities.getInstance().getMaxTextureImageUnits();
        this.mColor = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
        this.mAmbientColor = new float[]{0.2f, 0.2f, 0.2f};
        this.mAmbientIntensity = new float[]{0.3f, 0.3f, 0.3f};
    }

    public Material(VertexShader customVertexShader, FragmentShader customFragmentShader) {
        this(customVertexShader, customFragmentShader, false);
    }

    public Material(VertexShader customVertexShader, FragmentShader customFragmentShader, boolean deferCapabilitiesCheck) {
        this(deferCapabilitiesCheck);
        this.mCustomVertexShader = customVertexShader;
        this.mCustomFragmentShader = customFragmentShader;
    }

    public boolean usingVertexColors() {
        return this.mUseVertexColors;
    }

    public void useVertexColors(boolean value) {
        if (value != this.mUseVertexColors) {
            this.mIsDirty = true;
            this.mUseVertexColors = value;
        }
    }

    public void setColor(int color) {
        this.mColor[0] = (float)Color.red((int)color) / 255.0f;
        this.mColor[1] = (float)Color.green((int)color) / 255.0f;
        this.mColor[2] = (float)Color.blue((int)color) / 255.0f;
        this.mColor[3] = (float)Color.alpha((int)color) / 255.0f;
        if (this.mVertexShader != null) {
            this.mVertexShader.setColor(this.mColor);
        }
    }

    public void setColor(float[] color) {
        this.mColor[0] = color[0];
        this.mColor[1] = color[1];
        this.mColor[2] = color[2];
        this.mColor[3] = color[3];
        if (this.mVertexShader != null) {
            this.mVertexShader.setColor(this.mColor);
        }
    }

    public int getColor() {
        return Color.argb((int)((int)(this.mColor[3] * 255.0f)), (int)((int)(this.mColor[0] * 255.0f)), (int)((int)(this.mColor[1] * 255.0f)), (int)((int)(this.mColor[2] * 255.0f)));
    }

    public void setColorInfluence(float influence) {
        this.mColorInfluence = influence;
    }

    public float getColorInfluence() {
        return this.mColorInfluence;
    }

    public void setAmbientColor(int color) {
        this.mAmbientColor[0] = (float)Color.red((int)color) / 255.0f;
        this.mAmbientColor[1] = (float)Color.green((int)color) / 255.0f;
        this.mAmbientColor[2] = (float)Color.blue((int)color) / 255.0f;
        if (this.mLightsVertexShaderFragment != null) {
            this.mLightsVertexShaderFragment.setAmbientColor(this.mAmbientColor);
        }
    }

    public void setAmbientColor(float[] color) {
        this.mAmbientColor[0] = color[0];
        this.mAmbientColor[1] = color[1];
        this.mAmbientColor[2] = color[2];
        if (this.mLightsVertexShaderFragment != null) {
            this.mLightsVertexShaderFragment.setAmbientColor(this.mAmbientColor);
        }
    }

    public int getAmbientColor() {
        return Color.argb((int)1, (int)((int)(this.mAmbientColor[0] * 255.0f)), (int)((int)(this.mAmbientColor[1] * 255.0f)), (int)((int)(this.mAmbientColor[2] * 255.0f)));
    }

    public void setAmbientIntensity(double r, double g, double b) {
        this.setAmbientIntensity((float)r, (float)g, (float)b);
    }

    public void setAmbientIntensity(float r, float g, float b) {
        this.mAmbientIntensity[0] = r;
        this.mAmbientIntensity[1] = g;
        this.mAmbientIntensity[2] = b;
        if (this.mLightsVertexShaderFragment != null) {
            this.mLightsVertexShaderFragment.setAmbientIntensity(this.mAmbientIntensity);
        }
    }

    void add() {
        RajLog.d("Material is being added.");
        this.checkCapabilitiesIfNeeded();
        if (this.mLightingEnabled && this.mLights == null) {
            return;
        }
        this.createShaders();
    }

    void remove() {
        this.mModelMatrix = null;
        this.mInverseViewMatrix = null;
        this.mModelViewMatrix = null;
        if (this.mLights != null) {
            this.mLights.clear();
        }
        if (this.mTextureList != null) {
            this.mTextureList.clear();
        }
        if (Renderer.hasGLContext()) {
            GLES20.glDeleteShader((int)this.mVShaderHandle);
            GLES20.glDeleteShader((int)this.mFShaderHandle);
            GLES20.glDeleteProgram((int)this.mProgramHandle);
        }
    }

    void reload() {
        this.mIsDirty = true;
        this.createShaders();
    }

    protected void onPreVertexShaderInitialize(@NonNull VertexShader vertexShader) {
    }

    protected void onPreFragmentShaderInitialize(@NonNull FragmentShader fragmentShader) {
    }

    protected void createShaders() {
        if (!this.mIsDirty) {
            return;
        }
        if (this.mCustomVertexShader == null && this.mCustomFragmentShader == null) {
            Object diffuseTextures = null;
            ArrayList<ATexture> normalMapTextures = null;
            ArrayList<ATexture> envMapTextures = null;
            ArrayList<ATexture> skyTextures = null;
            ArrayList<ATexture> specMapTextures = null;
            ArrayList<ATexture> alphaMapTextures = null;
            boolean hasCubeMaps = false;
            boolean hasVideoTexture = false;
            block9: for (int i = 0; i < this.mTextureList.size(); ++i) {
                ATexture texture = this.mTextureList.get(i);
                switch (texture.getTextureType()) {
                    case VIDEO_TEXTURE: {
                        hasVideoTexture = true;
                    }
                    case DIFFUSE: 
                    case RENDER_TARGET: {
                        if (diffuseTextures == null) {
                            diffuseTextures = new ArrayList<ATexture>();
                        }
                        diffuseTextures.add(texture);
                        continue block9;
                    }
                    case NORMAL: {
                        if (normalMapTextures == null) {
                            normalMapTextures = new ArrayList<ATexture>();
                        }
                        normalMapTextures.add(texture);
                        continue block9;
                    }
                    case CUBE_MAP: {
                        hasCubeMaps = true;
                    }
                    case SPHERE_MAP: {
                        boolean isSkyTexture = false;
                        boolean isEnvironmentTexture = false;
                        if (texture.getClass() == SphereMapTexture.class) {
                            isSkyTexture = ((SphereMapTexture)texture).isSkyTexture();
                            isEnvironmentTexture = ((SphereMapTexture)texture).isEnvironmentTexture();
                        } else if (texture.getClass() == CubeMapTexture.class) {
                            isSkyTexture = ((CubeMapTexture)texture).isSkyTexture();
                            isEnvironmentTexture = ((CubeMapTexture)texture).isEnvironmentTexture();
                        }
                        if (isSkyTexture) {
                            if (skyTextures == null) {
                                skyTextures = new ArrayList<ATexture>();
                            }
                            skyTextures.add(texture);
                            continue block9;
                        }
                        if (!isEnvironmentTexture) continue block9;
                        if (envMapTextures == null) {
                            envMapTextures = new ArrayList<ATexture>();
                        }
                        envMapTextures.add(texture);
                        continue block9;
                    }
                    case SPECULAR: {
                        if (specMapTextures == null) {
                            specMapTextures = new ArrayList<ATexture>();
                        }
                        specMapTextures.add(texture);
                        continue block9;
                    }
                    case ALPHA: {
                        if (alphaMapTextures == null) {
                            alphaMapTextures = new ArrayList<ATexture>();
                        }
                        alphaMapTextures.add(texture);
                        continue block9;
                    }
                }
            }
            this.mVertexShader = new VertexShader();
            this.mVertexShader.enableTime(this.mTimeEnabled);
            this.mVertexShader.hasCubeMaps(hasCubeMaps);
            this.mVertexShader.hasSkyTexture(skyTextures != null && skyTextures.size() > 0);
            this.mVertexShader.useVertexColors(this.mUseVertexColors);
            this.onPreVertexShaderInitialize(this.mVertexShader);
            this.mVertexShader.initialize();
            this.mFragmentShader = new FragmentShader();
            this.mFragmentShader.enableTime(this.mTimeEnabled);
            this.mFragmentShader.hasCubeMaps(hasCubeMaps);
            this.onPreFragmentShaderInitialize(this.mFragmentShader);
            this.mFragmentShader.initialize();
            if (diffuseTextures != null && diffuseTextures.size() > 0) {
                DiffuseTextureFragmentShaderFragment fragment = new DiffuseTextureFragmentShaderFragment((List<ATexture>)diffuseTextures);
                this.mFragmentShader.addShaderFragment(fragment);
            }
            if (normalMapTextures != null && normalMapTextures.size() > 0) {
                NormalMapFragmentShaderFragment fragment = new NormalMapFragmentShaderFragment(normalMapTextures);
                this.mFragmentShader.addShaderFragment(fragment);
            }
            if (envMapTextures != null && envMapTextures.size() > 0) {
                EnvironmentMapFragmentShaderFragment fragment = new EnvironmentMapFragmentShaderFragment(envMapTextures);
                this.mFragmentShader.addShaderFragment(fragment);
            }
            if (skyTextures != null && skyTextures.size() > 0) {
                SkyTextureFragmentShaderFragment fragment = new SkyTextureFragmentShaderFragment(skyTextures);
                this.mFragmentShader.addShaderFragment(fragment);
            }
            if (hasVideoTexture) {
                this.mFragmentShader.addPreprocessorDirective("#extension GL_OES_EGL_image_external : require");
            }
            this.checkForPlugins(PluginInsertLocation.PRE_LIGHTING);
            if (this.mLightingEnabled && this.mLights != null && this.mLights.size() > 0) {
                this.mVertexShader.setLights(this.mLights);
                this.mFragmentShader.setLights(this.mLights);
                this.mLightsVertexShaderFragment = new LightsVertexShaderFragment(this.mLights);
                this.mLightsVertexShaderFragment.setAmbientColor(this.mAmbientColor);
                this.mLightsVertexShaderFragment.setAmbientIntensity(this.mAmbientIntensity);
                this.mVertexShader.addShaderFragment(this.mLightsVertexShaderFragment);
                this.mFragmentShader.addShaderFragment(new LightsFragmentShaderFragment(this.mLights));
                this.checkForPlugins(PluginInsertLocation.PRE_DIFFUSE);
                if (this.mDiffuseMethod != null) {
                    this.mDiffuseMethod.setLights(this.mLights);
                    IShaderFragment fragment = this.mDiffuseMethod.getVertexShaderFragment();
                    if (fragment != null) {
                        this.mVertexShader.addShaderFragment(fragment);
                    }
                    fragment = this.mDiffuseMethod.getFragmentShaderFragment();
                    this.mFragmentShader.addShaderFragment(fragment);
                }
                this.checkForPlugins(PluginInsertLocation.PRE_SPECULAR);
                if (this.mSpecularMethod != null) {
                    this.mSpecularMethod.setLights(this.mLights);
                    this.mSpecularMethod.setTextures(specMapTextures);
                    IShaderFragment fragment = this.mSpecularMethod.getVertexShaderFragment();
                    if (fragment != null) {
                        this.mVertexShader.addShaderFragment(fragment);
                    }
                    if ((fragment = this.mSpecularMethod.getFragmentShaderFragment()) != null) {
                        this.mFragmentShader.addShaderFragment(fragment);
                    }
                }
            }
            this.checkForPlugins(PluginInsertLocation.PRE_ALPHA);
            if (alphaMapTextures != null && alphaMapTextures.size() > 0) {
                AlphaMapFragmentShaderFragment fragment = new AlphaMapFragmentShaderFragment(alphaMapTextures);
                this.mFragmentShader.addShaderFragment(fragment);
            }
            this.checkForPlugins(PluginInsertLocation.PRE_TRANSFORM);
            this.checkForPlugins(PluginInsertLocation.POST_TRANSFORM);
            this.mVertexShader.buildShader();
            this.mFragmentShader.buildShader();
        } else {
            this.mVertexShader = this.mCustomVertexShader;
            this.mFragmentShader = this.mCustomFragmentShader;
            if (this.mVertexShader.needsBuild()) {
                this.mVertexShader.initialize();
            }
            if (this.mFragmentShader.needsBuild()) {
                this.mFragmentShader.initialize();
            }
            if (this.mVertexShader.needsBuild()) {
                this.mVertexShader.buildShader();
            }
            if (this.mFragmentShader.needsBuild()) {
                this.mFragmentShader.buildShader();
            }
        }
        if (RajLog.isDebugEnabled()) {
            RajLog.d("-=-=-=- VERTEX SHADER -=-=-=-");
            RajLog.d(this.mVertexShader.getShaderString());
            RajLog.d("-=-=-=- FRAGMENT SHADER -=-=-=-");
            RajLog.d(this.mFragmentShader.getShaderString());
        }
        this.mProgramHandle = this.createProgram(this.mVertexShader.getShaderString(), this.mFragmentShader.getShaderString());
        if (this.mProgramHandle == 0) {
            this.mIsDirty = false;
            return;
        }
        this.mVertexShader.setLocations(this.mProgramHandle);
        this.mFragmentShader.setLocations(this.mProgramHandle);
        for (String name : this.mTextureHandles.keySet()) {
            this.setTextureHandleForName(name);
        }
        for (int i = 0; i < this.mTextureList.size(); ++i) {
            this.setTextureParameters(this.mTextureList.get(i));
        }
        this.mIsDirty = false;
    }

    private void checkCapabilitiesIfNeeded() {
        if (!this.mCapabilitiesCheckDeferred) {
            return;
        }
        this.mMaxTextures = Capabilities.getInstance().getMaxTextureImageUnits();
    }

    private void checkForPlugins(PluginInsertLocation location) {
        if (this.mPlugins == null) {
            return;
        }
        for (IMaterialPlugin plugin : this.mPlugins) {
            if (plugin.getInsertLocation() != location) continue;
            this.mVertexShader.addShaderFragment(plugin.getVertexShaderFragment());
            this.mFragmentShader.addShaderFragment(plugin.getFragmentShaderFragment());
        }
    }

    private int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        if (shader != 0) {
            GLES20.glShaderSource((int)shader, (String)source);
            GLES20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
            if (compiled[0] == 0) {
                RajLog.e("[" + this.getClass().getName() + "] Could not compile " + (shaderType == 35632 ? "fragment" : "vertex") + " shader:");
                RajLog.e("Shader log: " + GLES20.glGetShaderInfoLog((int)shader));
                GLES20.glDeleteShader((int)shader);
                shader = 0;
            }
        }
        return shader;
    }

    private int createProgram(String vertexSource, String fragmentSource) {
        this.mVShaderHandle = this.loadShader(35633, vertexSource);
        if (this.mVShaderHandle == 0) {
            return 0;
        }
        this.mFShaderHandle = this.loadShader(35632, fragmentSource);
        if (this.mFShaderHandle == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        if (program != 0) {
            GLES20.glAttachShader((int)program, (int)this.mVShaderHandle);
            GLES20.glAttachShader((int)program, (int)this.mFShaderHandle);
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                RajLog.e("Could not link program in " + this.getClass().getCanonicalName() + ": ");
                RajLog.e(GLES20.glGetProgramInfoLog((int)program));
                GLES20.glDeleteProgram((int)program);
                program = 0;
            }
        }
        return program;
    }

    public void useProgram() {
        if (this.mIsDirty) {
            this.createShaders();
        }
        GLES20.glUseProgram((int)this.mProgramHandle);
    }

    public void applyParams() {
        this.mVertexShader.setColor(this.mColor);
        this.mVertexShader.setTime(this.mTime);
        this.mVertexShader.applyParams();
        this.mFragmentShader.setColorInfluence(this.mColorInfluence);
        this.mFragmentShader.applyParams();
    }

    private void setTextureParameters(ATexture texture) {
        if (this.mTextureHandles.containsKey(texture.getTextureName())) {
            return;
        }
        int textureHandle = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)texture.getTextureName());
        if (textureHandle == -1 && RajLog.isDebugEnabled()) {
            RajLog.e("Could not get uniform location for " + texture.getTextureName() + ", " + (Object)((Object)texture.getTextureType()));
            return;
        }
        this.mTextureHandles.put(texture.getTextureName(), textureHandle);
    }

    public void setTextureHandleForName(@NonNull String name) {
        if (this.mProgramHandle < 0 || this.mTextureHandles.containsKey(name) && this.mTextureHandles.get(name) > -1) {
            return;
        }
        int textureHandle = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)name);
        if (textureHandle == -1 && RajLog.isDebugEnabled()) {
            RajLog.e("Could not get uniform location for " + name + " Program Handle: " + this.mProgramHandle);
            return;
        }
        this.mTextureHandles.put(name, textureHandle);
    }

    public void bindTextures() {
        int num = this.mTextureList.size();
        if (num > this.mMaxTextures) {
            RajLog.e(num + " textures have been added to this material but this device supports a max of " + this.mMaxTextures + " textures in the fragment shader. Only the first " + this.mMaxTextures + " will be used.");
            num = this.mMaxTextures;
        }
        for (int i = 0; i < num; ++i) {
            this.bindTextureByName(i, this.mTextureList.get(i));
        }
        if (this.mPlugins != null) {
            for (IMaterialPlugin plugin : this.mPlugins) {
                plugin.bindTextures(num);
            }
        }
    }

    public void bindTextureByName(int index, ATexture texture) {
        if (!this.mTextureHandles.containsKey(texture.getTextureName())) {
            this.setTextureParameters(texture);
        }
        GLES20.glActiveTexture((int)(33984 + index));
        GLES20.glBindTexture((int)texture.getGLTextureType(), (int)texture.getTextureId());
        GLES20.glUniform1i((int)this.mTextureHandles.get(texture.getTextureName()), (int)index);
    }

    public void bindTextureByName(String name, int index, ATexture texture) {
        if (!this.mTextureHandles.containsKey(texture.getTextureName())) {
            this.setTextureHandleForName(name);
        }
        GLES20.glActiveTexture((int)(33984 + index));
        GLES20.glBindTexture((int)texture.getGLTextureType(), (int)texture.getTextureId());
        GLES20.glUniform1i((int)this.mTextureHandles.get(name), (int)index);
    }

    public void unbindTextures() {
        int num = this.mTextureList.size();
        if (this.mPlugins != null) {
            for (IMaterialPlugin plugin : this.mPlugins) {
                plugin.unbindTextures();
            }
        }
        for (int i = 0; i < num; ++i) {
            ATexture texture = this.mTextureList.get(i);
            GLES20.glBindTexture((int)texture.getGLTextureType(), (int)0);
        }
        GLES20.glBindBuffer((int)34962, (int)0);
    }

    public void addTexture(ATexture texture) throws ATexture.TextureException {
        if (this.mTextureList.indexOf(texture) > -1) {
            return;
        }
        if (this.mTextureList.size() + 1 > this.mMaxTextures) {
            throw new ATexture.TextureException("Maximum number of textures for this material has been reached. Maximum number of textures is " + this.mMaxTextures + ".");
        }
        this.mTextureList.add(texture);
        TextureManager.getInstance().addTexture(texture);
        texture.registerMaterial(this);
        this.mIsDirty = true;
    }

    public void removeTexture(ATexture texture) {
        this.mTextureList.remove(texture);
        texture.unregisterMaterial(this);
    }

    public ArrayList<ATexture> getTextureList() {
        return this.mTextureList;
    }

    public void copyTexturesTo(Material material) throws ATexture.TextureException {
        int num = this.mTextureList.size();
        for (int i = 0; i < num; ++i) {
            material.addTexture(this.mTextureList.get(i));
        }
    }

    public void setVertices(int vertexBufferHandle) {
        this.mVertexShader.setVertices(vertexBufferHandle);
    }

    public void setVertices(BufferInfo bufferInfo) {
        this.mVertexShader.setVertices(bufferInfo.bufferHandle, bufferInfo.type, bufferInfo.stride, bufferInfo.offset);
    }

    public void setTextureCoords(int textureCoordBufferHandle) {
        this.mVertexShader.setTextureCoords(textureCoordBufferHandle);
    }

    public void setTextureCoords(BufferInfo bufferInfo) {
        this.mVertexShader.setTextureCoords(bufferInfo.bufferHandle, bufferInfo.type, bufferInfo.stride, bufferInfo.offset);
    }

    public void setNormals(int normalBufferHandle) {
        this.mVertexShader.setNormals(normalBufferHandle);
    }

    public void setNormals(BufferInfo bufferInfo) {
        this.mVertexShader.setNormals(bufferInfo.bufferHandle, bufferInfo.type, bufferInfo.stride, bufferInfo.offset);
    }

    public void setVertexColors(int vertexColorBufferHandle) {
        this.mVertexShader.setVertexColors(vertexColorBufferHandle);
    }

    public void setVertexColors(BufferInfo bufferInfo) {
        this.mVertexShader.setVertexColors(bufferInfo.bufferHandle, bufferInfo.type, bufferInfo.stride, bufferInfo.offset);
    }

    public float[] getInverseViewMatrix() {
        return this.mInverseViewMatrix;
    }

    public float[] getModelViewMatrix() {
        return this.mModelViewMatrix;
    }

    public void setMVPMatrix(Matrix4 mvpMatrix) {
        this.mVertexShader.setMVPMatrix(mvpMatrix.getFloatValues());
    }

    public void setModelMatrix(Matrix4 modelMatrix) {
        this.mModelMatrix = modelMatrix;
        this.mVertexShader.setModelMatrix(this.mModelMatrix);
        this.mNormalMatrix.setAll(modelMatrix);
        try {
            this.mNormalMatrix.setToNormalMatrix();
        }
        catch (IllegalStateException exception) {
            RajLog.d("modelMatrix is degenerate (zero scale)...");
        }
        float[] matrix = this.mNormalMatrix.getFloatValues();
        this.mNormalFloats[0] = matrix[0];
        this.mNormalFloats[1] = matrix[1];
        this.mNormalFloats[2] = matrix[2];
        this.mNormalFloats[3] = matrix[4];
        this.mNormalFloats[4] = matrix[5];
        this.mNormalFloats[5] = matrix[6];
        this.mNormalFloats[6] = matrix[8];
        this.mNormalFloats[7] = matrix[9];
        this.mNormalFloats[8] = matrix[10];
        this.mVertexShader.setNormalMatrix(this.mNormalFloats);
    }

    public void setInverseViewMatrix(Matrix4 inverseViewMatrix) {
        this.mInverseViewMatrix = inverseViewMatrix.getFloatValues();
        this.mVertexShader.setInverseViewMatrix(this.mInverseViewMatrix);
    }

    public void setModelViewMatrix(Matrix4 modelViewMatrix) {
        this.mModelViewMatrix = modelViewMatrix.getFloatValues();
        this.mVertexShader.setModelViewMatrix(this.mModelViewMatrix);
    }

    public void enableLighting(boolean value) {
        this.mLightingEnabled = value;
    }

    public boolean lightingEnabled() {
        return this.mLightingEnabled;
    }

    public void enableTime(boolean value) {
        this.mTimeEnabled = value;
    }

    public boolean timeEnabled() {
        return this.mTimeEnabled;
    }

    public void setTime(float time) {
        this.mTime = time;
    }

    public float getTime() {
        return this.mTime;
    }

    public void setLights(List<ALight> lights) {
        if (this.mLights != null) {
            for (ALight light : lights) {
                if (!this.mLights.contains(light)) break;
            }
        } else {
            this.mIsDirty = true;
            this.mLights = lights;
        }
    }

    public void setDiffuseMethod(IDiffuseMethod diffuseMethod) {
        if (this.mDiffuseMethod == diffuseMethod) {
            return;
        }
        this.mDiffuseMethod = diffuseMethod;
        this.mIsDirty = true;
    }

    public IDiffuseMethod getDiffuseMethod() {
        return this.mDiffuseMethod;
    }

    public void setSpecularMethod(ISpecularMethod specularMethod) {
        if (this.mSpecularMethod == specularMethod) {
            return;
        }
        this.mSpecularMethod = specularMethod;
        this.mIsDirty = true;
    }

    public ISpecularMethod getSpecularMethod() {
        return this.mSpecularMethod;
    }

    public void addPlugin(IMaterialPlugin plugin) {
        if (this.mPlugins == null) {
            this.mPlugins = new ArrayList<IMaterialPlugin>();
        } else {
            for (IMaterialPlugin p : this.mPlugins) {
                if (!plugin.getClass().getSimpleName().equals(p.getClass().getSimpleName())) continue;
                return;
            }
        }
        this.mPlugins.add(plugin);
        this.mIsDirty = true;
    }

    public IMaterialPlugin getPlugin(Class<?> pluginClass) {
        if (this.mPlugins == null) {
            return null;
        }
        for (IMaterialPlugin plugin : this.mPlugins) {
            if (plugin.getClass() != pluginClass) continue;
            return plugin;
        }
        return null;
    }

    public void setCurrentObject(Object3D currentObject) {
    }

    public void unsetCurrentObject(Object3D currentObject) {
    }

    public void removePlugin(IMaterialPlugin plugin) {
        if (this.mPlugins != null && this.mPlugins.contains(plugin)) {
            this.mPlugins.remove(plugin);
            this.mIsDirty = true;
        }
    }

    public void setOwnerIdentity(String identity) {
        this.mOwnerIdentity = identity;
    }

    public String getOwnerIdentity() {
        return this.mOwnerIdentity;
    }

    public static enum PluginInsertLocation {
        PRE_LIGHTING,
        PRE_DIFFUSE,
        PRE_SPECULAR,
        PRE_ALPHA,
        PRE_TRANSFORM,
        POST_TRANSFORM,
        IGNORE;

    }
}

