/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader.md5;

import android.content.res.Resources;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.rajawali3d.animation.mesh.AAnimationObject3D;
import org.rajawali3d.animation.mesh.SkeletalAnimationChildObject3D;
import org.rajawali3d.animation.mesh.SkeletalAnimationFrame;
import org.rajawali3d.animation.mesh.SkeletalAnimationObject3D;
import org.rajawali3d.loader.AMeshLoader;
import org.rajawali3d.loader.IAnimatedMeshLoader;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.methods.DiffuseMethod;
import org.rajawali3d.materials.plugins.SkeletalAnimationMaterialPlugin;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.Texture;
import org.rajawali3d.materials.textures.TextureManager;
import org.rajawali3d.math.Matrix;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.util.RajLog;

public class LoaderMD5Mesh
extends AMeshLoader
implements IAnimatedMeshLoader {
    private static final String MD5_VERSION = "MD5Version";
    private static final String COMMAND_LINE = "commandline";
    private static final String NUM_JOINTS = "numJoints";
    private static final String NUM_MESHES = "numMeshes";
    private static final String NUM_VERTS = "numverts";
    private static final String NUM_TRIS = "numtris";
    private static final String NUM_WEIGHTS = "numweights";
    private static final String JOINTS = "joints";
    private static final String MESH = "mesh";
    private static final String SHADER = "shader";
    private static final String VERT = "vert";
    private static final String TRI = "tri";
    private static final String WEIGHT = "weight";
    private int mNumJoints;
    private int mNumMeshes;
    private int mMeshIndex = 0;
    private SkeletonMeshData[] mMeshes;
    private SkeletalAnimationFrame.SkeletonJoint[] mJoints;
    public double[] mBindPoseMatrix;
    public double[][] mInverseBindPoseMatrix;

    public LoaderMD5Mesh(Renderer renderer, String fileOnSDCard) {
        super(renderer, fileOnSDCard);
    }

    public LoaderMD5Mesh(Renderer renderer, int resourceId) {
        this(renderer.getContext().getResources(), renderer.getTextureManager(), resourceId);
    }

    public LoaderMD5Mesh(Resources resources, TextureManager textureManager, int resourceId) {
        super(resources, textureManager, resourceId);
    }

    @Override
    public AAnimationObject3D getParsedAnimationObject() {
        return (AAnimationObject3D)this.mRootObject;
    }

    @Override
    public LoaderMD5Mesh parse() throws ParsingException {
        super.parse();
        BufferedReader buffer = null;
        if (this.mFile == null) {
            InputStream fileIn = this.mResources.openRawResource(this.mResourceId);
            buffer = new BufferedReader(new InputStreamReader(fileIn));
        } else {
            try {
                buffer = new BufferedReader(new FileReader(this.mFile));
            }
            catch (FileNotFoundException e) {
                RajLog.e("[" + this.getClass().getCanonicalName() + "] Could not find file.");
                throw new ParsingException(e);
            }
        }
        try {
            String line;
            while ((line = buffer.readLine()) != null) {
                StringTokenizer parts = new StringTokenizer(line, " ");
                int numTokens = parts.countTokens();
                if (numTokens == 0) continue;
                String type = parts.nextToken();
                if (type.equalsIgnoreCase(MD5_VERSION)) {
                    if (!RajLog.isDebugEnabled()) continue;
                    RajLog.d("MD5 Version: " + parts.nextToken());
                    continue;
                }
                if (type.equalsIgnoreCase(COMMAND_LINE)) continue;
                if (type.equalsIgnoreCase(NUM_JOINTS)) {
                    this.mNumJoints = Integer.parseInt(parts.nextToken());
                    this.mJoints = new SkeletalAnimationFrame.SkeletonJoint[this.mNumJoints];
                    continue;
                }
                if (type.equalsIgnoreCase(NUM_MESHES)) {
                    this.mNumMeshes = Integer.parseInt(parts.nextToken());
                    this.mMeshes = new SkeletonMeshData[this.mNumMeshes];
                    continue;
                }
                if (type.equalsIgnoreCase(JOINTS)) {
                    this.parseJoints(buffer);
                    continue;
                }
                if (!type.equals(MESH)) continue;
                this.parseMesh(buffer);
            }
            buffer.close();
            this.buildBindPose();
            this.buildMeshes();
            this.calculateNormals();
            this.createObjects();
        }
        catch (Exception tme) {
            try {
                buffer.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new ParsingException(tme);
        }
        finally {
            this.mMeshes = null;
            this.mJoints = null;
            this.mBindPoseMatrix = null;
            this.mInverseBindPoseMatrix = null;
        }
        return this;
    }

    private void parseJoints(BufferedReader buffer) {
        try {
            String line;
            int count = 0;
            while ((line = buffer.readLine()) != null) {
                SkeletalAnimationFrame.SkeletonJoint joint = new SkeletalAnimationFrame.SkeletonJoint();
                if (line.length() == 0) continue;
                if (line.indexOf(125) > -1) {
                    return;
                }
                line = line.replace('\t', ' ');
                int offset = line.lastIndexOf(34);
                joint.setName(line.substring(line.indexOf(34) + 1, offset));
                joint.setParentIndex(Integer.parseInt(line.substring(offset += 2, line.indexOf(32, offset))));
                offset = line.indexOf(41);
                String[] p = line.substring(line.indexOf(40) + 2, offset).split(" ");
                joint.setPosition(Float.parseFloat(p[0]), Float.parseFloat(p[2]), Float.parseFloat(p[1]));
                p = line.substring(line.indexOf(40, offset) + 2, line.lastIndexOf(41)).split(" ");
                joint.setOrientation(Float.parseFloat(p[0]), Float.parseFloat(p[2]), Float.parseFloat(p[1]));
                joint.getOrientation().computeW();
                this.mJoints[count++] = joint;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseMesh(BufferedReader buffer) {
        try {
            String line;
            SkeletonMeshData mesh = new SkeletonMeshData();
            while ((line = buffer.readLine()) != null) {
                line = line.replace("\t", "");
                StringTokenizer parts = new StringTokenizer(line, " ");
                int numTokens = parts.countTokens();
                if (line.indexOf(125) > -1) {
                    this.mMeshes[this.mMeshIndex++] = mesh;
                    return;
                }
                if (numTokens == 0 || line.indexOf(125) > -1) continue;
                String type = parts.nextToken();
                if (type.equalsIgnoreCase(SHADER)) {
                    int dot;
                    String shader = parts.nextToken();
                    mesh.textureName = shader = shader.replace("\"", "");
                    if (shader.length() == 0) continue;
                    int lastDelim = shader.lastIndexOf("/");
                    if (lastDelim == -1) {
                        lastDelim = shader.lastIndexOf("\\");
                    }
                    if (lastDelim > -1) {
                        mesh.textureName = shader.substring(lastDelim + 1, shader.length());
                    }
                    if ((dot = shader.lastIndexOf(".")) <= -1) continue;
                    mesh.textureName = shader.substring(0, dot);
                    continue;
                }
                if (type.equalsIgnoreCase(NUM_VERTS)) {
                    mesh.numVertices = Integer.parseInt(parts.nextToken());
                    mesh.boneVertices = new SkeletalAnimationChildObject3D.BoneVertex[mesh.numVertices];
                    continue;
                }
                if (type.equalsIgnoreCase(VERT)) {
                    int index = Integer.parseInt(parts.nextToken());
                    SkeletalAnimationChildObject3D.BoneVertex vert = new SkeletalAnimationChildObject3D.BoneVertex();
                    parts.nextToken();
                    vert.textureCoordinate.setAll(Float.parseFloat(parts.nextToken()), Float.parseFloat(parts.nextToken()));
                    parts.nextToken();
                    vert.weightIndex = Integer.parseInt(parts.nextToken());
                    vert.numWeights = Integer.parseInt(parts.nextToken());
                    mesh.numWeights += vert.numWeights;
                    mesh.maxBoneWeightsPerVertex = Math.max(mesh.maxBoneWeightsPerVertex, vert.numWeights);
                    mesh.boneVertices[index] = vert;
                    continue;
                }
                if (type.equalsIgnoreCase(NUM_TRIS)) {
                    mesh.numTriangles = Integer.parseInt(parts.nextToken());
                    mesh.triangles = new int[mesh.numTriangles][];
                    continue;
                }
                if (type.equalsIgnoreCase(TRI)) {
                    int index = Integer.parseInt(parts.nextToken());
                    mesh.triangles[index] = new int[]{Integer.parseInt(parts.nextToken()), Integer.parseInt(parts.nextToken()), Integer.parseInt(parts.nextToken())};
                    continue;
                }
                if (type.equalsIgnoreCase(NUM_WEIGHTS)) {
                    mesh.numWeights = Integer.parseInt(parts.nextToken());
                    mesh.boneWeights = new SkeletalAnimationChildObject3D.BoneWeight[mesh.numWeights];
                    continue;
                }
                if (!type.equalsIgnoreCase(WEIGHT)) continue;
                int index = Integer.parseInt(parts.nextToken());
                SkeletalAnimationChildObject3D.BoneWeight weight = new SkeletalAnimationChildObject3D.BoneWeight();
                weight.jointIndex = Integer.parseInt(parts.nextToken());
                weight.weightValue = Float.parseFloat(parts.nextToken());
                mesh.boneWeights[index] = weight;
                parts.nextToken();
                float x = Float.parseFloat(parts.nextToken());
                float z = Float.parseFloat(parts.nextToken());
                float y = Float.parseFloat(parts.nextToken());
                weight.position.setAll(x, y, z);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildMeshes() {
        for (int i = 0; i < this.mNumMeshes; ++i) {
            int boneIndex = 0;
            SkeletonMeshData mesh = this.mMeshes[i];
            mesh.vertices = new float[mesh.numVertices * 3];
            mesh.indices = new int[mesh.numWeights];
            mesh.weights = new float[mesh.numWeights];
            mesh.textureCoordinates = new float[mesh.numVertices * 2];
            int numVerts = mesh.numVertices;
            for (int j = 0; j < numVerts; ++j) {
                SkeletalAnimationChildObject3D.BoneVertex vert = mesh.boneVertices[j];
                Vector3 position = new Vector3();
                for (int k = 0; k < vert.numWeights; ++k) {
                    SkeletalAnimationChildObject3D.BoneWeight weight = mesh.boneWeights[vert.weightIndex + k];
                    SkeletalAnimationFrame.SkeletonJoint joint = this.mJoints[weight.jointIndex];
                    Vector3 rotPos = joint.getOrientation().multiply(weight.position);
                    Vector3 pos = Vector3.addAndCreate(joint.getPosition(), rotPos);
                    pos.multiply(weight.weightValue);
                    position.add(pos);
                    mesh.indices[boneIndex] = weight.jointIndex;
                    mesh.weights[boneIndex++] = weight.weightValue;
                }
                int vertIndex = j * 3;
                mesh.vertices[vertIndex] = (float)position.x;
                mesh.vertices[vertIndex + 1] = (float)position.y;
                mesh.vertices[vertIndex + 2] = (float)position.z;
                int uvIndex = j * 2;
                mesh.textureCoordinates[uvIndex] = (float)vert.textureCoordinate.getX();
                mesh.textureCoordinates[uvIndex + 1] = (float)vert.textureCoordinate.getY();
            }
        }
    }

    private void calculateNormals() {
        for (int i = 0; i < this.mNumMeshes; ++i) {
            SkeletonMeshData mesh = this.mMeshes[i];
            int numTriangles = mesh.numTriangles;
            mesh.indices = new int[numTriangles * 3];
            int index = 0;
            for (int j = 0; j < numTriangles; ++j) {
                int[] triangle = mesh.triangles[j];
                int index0 = triangle[0];
                int index1 = triangle[2];
                int index2 = triangle[1];
                mesh.indices[index++] = index0;
                mesh.indices[index++] = index1;
                mesh.indices[index++] = index2;
                int index03 = index0 * 3;
                int index13 = index1 * 3;
                int index23 = index2 * 3;
                Vector3 v0 = new Vector3(mesh.vertices[index03], mesh.vertices[index03 + 1], mesh.vertices[index03 + 2]);
                Vector3 v1 = new Vector3(mesh.vertices[index13], mesh.vertices[index13 + 1], mesh.vertices[index13 + 2]);
                Vector3 v2 = new Vector3(mesh.vertices[index23], mesh.vertices[index23 + 1], mesh.vertices[index23 + 2]);
                Vector3 normal = Vector3.crossAndCreate(Vector3.subtractAndCreate(v2, v0), Vector3.subtractAndCreate(v1, v0));
                normal.inverse();
                mesh.boneVertices[index0].normal.add(normal);
                mesh.boneVertices[index1].normal.add(normal);
                mesh.boneVertices[index2].normal.add(normal);
            }
            int numVertices = mesh.numVertices;
            if (mesh.normals == null) {
                mesh.normals = new float[numVertices * 3];
            }
            for (int j = 0; j < numVertices; ++j) {
                SkeletalAnimationChildObject3D.BoneVertex vert = mesh.boneVertices[j];
                Vector3 normal = vert.normal.clone();
                vert.normal.normalize();
                normal.normalize();
                int normIndex = j * 3;
                mesh.normals[normIndex] = (float)normal.x;
                mesh.normals[normIndex + 1] = (float)normal.y;
                mesh.normals[normIndex + 2] = (float)normal.z;
                vert.normal.setAll(0.0, 0.0, 0.0);
                for (int k = 0; k < vert.numWeights; ++k) {
                    SkeletalAnimationChildObject3D.BoneWeight weight = mesh.boneWeights[vert.weightIndex + k];
                    SkeletalAnimationFrame.SkeletonJoint joint = this.mJoints[weight.jointIndex];
                    vert.normal.add(Vector3.scaleAndCreate(joint.getOrientation().multiply(normal), weight.weightValue));
                }
            }
        }
    }

    private void buildBindPose() {
        this.mBindPoseMatrix = new double[this.mNumJoints * 16];
        this.mInverseBindPoseMatrix = new double[this.mNumJoints][];
        for (int i = 0; i < this.mNumJoints; ++i) {
            SkeletalAnimationFrame.SkeletonJoint joint = this.mJoints[i];
            double[] boneTranslation = new double[16];
            double[] boneRotation = new double[16];
            double[] boneMatrix = new double[16];
            double[] inverseBoneMatrix = new double[16];
            Matrix.setIdentityM(boneTranslation, 0);
            Matrix.setIdentityM(boneRotation, 0);
            Vector3 jointPos = joint.getPosition();
            Matrix.translateM(boneTranslation, 0, jointPos.x, jointPos.y, jointPos.z);
            joint.getOrientation().toRotationMatrix(boneRotation);
            Matrix.multiplyMM(boneMatrix, 0, boneTranslation, 0, boneRotation, 0);
            Matrix.invertM(inverseBoneMatrix, 0, boneMatrix, 0);
            for (int j = 0; j < 16; ++j) {
                this.mBindPoseMatrix[i + j] = boneMatrix[j];
            }
            this.mInverseBindPoseMatrix[i] = inverseBoneMatrix;
        }
    }

    private void createObjects() throws ATexture.TextureException, ParsingException, SkeletalAnimationObject3D.SkeletalAnimationException {
        SkeletalAnimationObject3D root = new SkeletalAnimationObject3D();
        root.uBoneMatrix = this.mBindPoseMatrix;
        root.mInverseBindPoseMatrix = this.mInverseBindPoseMatrix;
        root.setJoints(this.mJoints);
        this.mRootObject = root;
        for (int i = 0; i < this.mNumMeshes; ++i) {
            SkeletonMeshData mesh = this.mMeshes[i];
            SkeletalAnimationChildObject3D o = new SkeletalAnimationChildObject3D();
            o.setData(mesh.vertices, 35040, mesh.normals, 35040, mesh.textureCoordinates, 35044, null, 35044, mesh.indices, 35044, false);
            o.setMaxBoneWeightsPerVertex(mesh.maxBoneWeightsPerVertex);
            o.setSkeletonMeshData(mesh.numVertices, mesh.boneVertices, mesh.numWeights, mesh.boneWeights);
            o.setName("MD5Mesh_" + i);
            o.setSkeleton(this.mRootObject);
            o.setInverseZScale(true);
            boolean hasTexture = mesh.textureName != null && mesh.textureName.length() > 0;
            Material mat = new Material();
            mat.addPlugin(new SkeletalAnimationMaterialPlugin(this.mNumJoints, mesh.maxBoneWeightsPerVertex));
            mat.enableLighting(true);
            mat.setDiffuseMethod(new DiffuseMethod.Lambert());
            o.setMaterial(mat);
            if (!hasTexture) {
                o.setColor(-16777216 + (int)(Math.random() * 1.6777215E7));
            } else {
                int identifier = this.mResources.getIdentifier(mesh.textureName, "drawable", this.mResources.getResourcePackageName(this.mResourceId));
                if (identifier == 0) {
                    throw new ParsingException("Couldn't find texture " + mesh.textureName);
                }
                mat.setColorInfluence(0.0f);
                mat.addTexture(new Texture("md5tex" + i, identifier));
            }
            this.mRootObject.addChild(o);
            mesh.destroy();
            Object var3_3 = null;
        }
    }

    private class SkeletonMeshData {
        public String textureName;
        public int numVertices;
        public int numTriangles;
        public int numWeights;
        public int maxBoneWeightsPerVertex;
        public SkeletalAnimationChildObject3D.BoneVertex[] boneVertices;
        public SkeletalAnimationChildObject3D.BoneWeight[] boneWeights;
        public int[][] triangles;
        public float[] vertices;
        public float[] normals;
        public int[] indices;
        public float[] textureCoordinates;
        public float[] weights;

        private SkeletonMeshData() {
        }

        public void destroy() {
            this.boneVertices = null;
            this.boneWeights = null;
            this.triangles = null;
            this.vertices = null;
            this.normals = null;
            this.indices = null;
            this.textureCoordinates = null;
            this.weights = null;
        }
    }
}

