/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader.fbx;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.rajawali3d.Object3D;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.lights.DirectionalLight;
import org.rajawali3d.lights.PointLight;
import org.rajawali3d.lights.SpotLight;
import org.rajawali3d.loader.AMeshLoader;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.loader.fbx.FBXValues;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.methods.DiffuseMethod;
import org.rajawali3d.materials.methods.SpecularMethod;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.Texture;
import org.rajawali3d.math.vector.Vector2;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.util.RajLog;

public class LoaderFBX
extends AMeshLoader {
    private static final char COMMENT = ';';
    private static final String OBJECT_TYPE = "ObjectType:";
    private static final String MODEL = "Model:";
    private static final String PROPERTIES = "Properties";
    private static final String LAYER_ELEMENT = "LayerElement";
    private static final String LAYER = "Layer:";
    private static final String PROPERTY = "Property:";
    private static final String TYPE_VECTOR3D = "Vector3D";
    private static final String TYPE_VECTOR = "Vector";
    private static final String TYPE_COLOR = "Color";
    private static final String TYPE_COLOR_RGB = "ColorRGB";
    private static final String TYPE_LCL_TRANSLATION = "LclTranslation";
    private static final String TYPE_LCL_ROTATION = "LclRotation";
    private static final String TYPE_LCL_SCALING = "LclScaling";
    private static final String MATERIAL = "Material:";
    private static final String POSE = "Pose:";
    private static final String POSE_NODE = "PoseNode:";
    private static final String CONNECT = "Connect:";
    private static final String TEXTURE = "Texture:";
    private static final String FBX_U = "FBX";
    private static final String FBX_L = "FBX".toLowerCase(Locale.US);
    private static final String REGEX_CLEAN = "\\s|\\t|\\n";
    private static final String REGEX_NO_SPACE_NO_QUOTE = "\\\"|\\s";
    private static final String REGEX_NO_QUOTE = "\\\"";
    private static final String REGEX_NO_FUNNY_CHARS = "\\W";
    private static final String REPLACE_EMPTY = "";
    private FBXValues mFbx;
    private Stack<Object> mObjStack;
    private Renderer mRenderer;

    public LoaderFBX(Renderer renderer, String fileOnSDCard) {
        super(renderer, fileOnSDCard);
        this.mRenderer = renderer;
        this.mObjStack = new Stack();
        this.mFbx = new FBXValues();
        this.mObjStack.add(this.mFbx);
    }

    public LoaderFBX(Renderer renderer, File file) {
        super(renderer, file);
        this.mRenderer = renderer;
        this.mObjStack = new Stack();
        this.mFbx = new FBXValues();
        this.mObjStack.add(this.mFbx);
    }

    public LoaderFBX(Renderer renderer, int resourceId) {
        super(renderer.getContext().getResources(), renderer.getTextureManager(), resourceId);
        this.mRenderer = renderer;
        this.mObjStack = new Stack();
        this.mFbx = new FBXValues();
        this.mObjStack.add(this.mFbx);
    }

    @Override
    public LoaderFBX parse() throws ParsingException {
        super.parse();
        BufferedReader buffer = null;
        if (this.mFile == null) {
            InputStream fileIn = this.mResources.openRawResource(this.mResourceId);
            buffer = new BufferedReader(new InputStreamReader(fileIn));
        } else {
            try {
                buffer = new BufferedReader(new FileReader(this.mFile));
            }
            catch (FileNotFoundException e) {
                RajLog.e("[" + this.getClass().getCanonicalName() + "] Could not find file.");
                throw new ParsingException(e);
            }
        }
        try {
            String line;
            while ((line = buffer.readLine()) != null) {
                String repl = line.replaceAll(REGEX_CLEAN, REPLACE_EMPTY);
                if (repl.length() == 0 || repl.charAt(0) == ';') continue;
                this.readLine(buffer, line);
            }
            buffer.close();
        }
        catch (Exception e) {
            throw new ParsingException(e);
        }
        Stack<FBXValues.Objects.Model> lights = this.mFbx.objects.getModelsByType("Light");
        int numLights = lights.size();
        Renderer.setMaxLights(numLights == 0 ? 1 : numLights);
        Stack<ALight> sceneLights = new Stack<ALight>();
        for (int i = 0; i < numLights; ++i) {
            FBXValues.Objects.Model l = (FBXValues.Objects.Model)lights.get(i);
            sceneLights.add(this.buildLight(l));
        }
        if (numLights == 0) {
            DirectionalLight light = new DirectionalLight();
            light.setPosition(2.0, 0.0, -5.0);
            light.setPower(1.0f);
            sceneLights.add(light);
        }
        Stack<FBXValues.Objects.Model> models = this.mFbx.objects.getModelsByType("Mesh");
        try {
            for (int i = 0; i < models.size(); ++i) {
                this.buildMesh((FBXValues.Objects.Model)models.get(i), sceneLights);
            }
        }
        catch (ATexture.TextureException tme) {
            throw new ParsingException(tme);
        }
        Stack<FBXValues.Objects.Model> cameras = this.mFbx.objects.getModelsByType("Camera");
        FBXValues.Objects.Model camera = null;
        for (int i = 0; i < cameras.size(); ++i) {
            if (((FBXValues.Objects.Model)cameras.get((int)i)).hidden != null && ((FBXValues.Objects.Model)cameras.get((int)i)).hidden.equals("True")) continue;
            camera = (FBXValues.Objects.Model)cameras.get(i);
            break;
        }
        if (camera != null) {
            Camera cam = this.mRenderer.getCurrentCamera();
            cam.setPosition(camera.position);
            cam.setX(this.mRenderer.getCurrentCamera().getX() * -1.0);
            cam.setRotation(camera.properties.lclRotation);
            Vector3 lookAt = camera.lookAt;
            cam.setLookAt(lookAt);
            cam.setNearPlane(camera.properties.nearPlane.floatValue());
            cam.setFarPlane(camera.properties.farPlane.floatValue());
            cam.setFieldOfView(camera.properties.fieldOfView.floatValue());
        }
        return this;
    }

    private ALight buildLight(FBXValues.Objects.Model l) {
        int m = l.properties.lightType != null ? l.properties.lightType : 1;
        switch (m) {
            case 1: {
                PointLight light = new PointLight();
                light.setPosition(l.properties.lclTranslation);
                light.setX(light.getX() * -1.0);
                light.setRotation(l.properties.lclRotation);
                light.setPower(l.properties.intensity.floatValue() / 100.0f);
                light.setColor(l.properties.color);
                return light;
            }
            case 0: {
                DirectionalLight lD = new DirectionalLight();
                lD.setPosition(l.properties.lclTranslation);
                lD.setX(lD.getX() * -1.0);
                lD.setRotation(l.properties.lclRotation);
                lD.setPower(l.properties.intensity.floatValue() / 100.0f);
                lD.setColor(l.properties.color);
                return lD;
            }
        }
        SpotLight lS = new SpotLight();
        lS.setPosition(l.properties.lclTranslation);
        lS.setX(lS.getX() * -1.0);
        lS.setRotation(l.properties.lclRotation);
        lS.setPower(l.properties.intensity.floatValue() / 100.0f);
        lS.setCutoffAngle(l.properties.coneangle.floatValue());
        lS.setColor(l.properties.color);
        lS.setLookAt(0.0, 0.0, 0.0);
        return lS;
    }

    private void buildMesh(FBXValues.Objects.Model model, Stack<ALight> lights) throws ATexture.TextureException, ParsingException {
        Object3D o = new Object3D(model.name);
        boolean hasUVs = model.layerElementUV.uVIndex != null;
        int[] vidx = model.polygonVertexIndex.data;
        int[] uvidx = null;
        float[] modelVerts = model.vertices.data;
        float[] modelNorm = model.layerElementNormal.normals.data;
        float[] modelUv = null;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<Float> vertices = new ArrayList<Float>();
        ArrayList<Float> normals = new ArrayList<Float>();
        ArrayList<Float> uvs = null;
        if (hasUVs) {
            uvs = new ArrayList<Float>();
            uvidx = model.layerElementUV.uVIndex.data;
            modelUv = model.layerElementUV.uV.data;
        }
        int count = 0;
        int indexCount = 0;
        int[] triIds = new int[3];
        int[] quadIds = new int[6];
        int i = 0;
        int j = 0;
        int k = 0;
        int vidxLen = vidx.length;
        for (i = 0; i < vidxLen; ++i) {
            int index3;
            int index2;
            int index1;
            ++count;
            if (vidx[i] >= 0) continue;
            if (count == 3) {
                index1 = vidx[i - 2];
                index2 = vidx[i - 1];
                index3 = vidx[i] * -1 - 1;
                indices.add(indexCount++);
                indices.add(indexCount++);
                indices.add(indexCount++);
                triIds[0] = index1 * 3;
                triIds[1] = index2 * 3;
                triIds[2] = index3 * 3;
                for (j = 0; j < 3; ++j) {
                    int cid = triIds[j];
                    for (k = 0; k < 3; ++k) {
                        vertices.add(Float.valueOf(modelVerts[cid + k]));
                        int dir = i == 0 ? -1 : 1;
                        normals.add(Float.valueOf(modelNorm[cid + k] * (float)dir));
                    }
                }
                if (hasUVs) {
                    int uvIndex3 = uvidx[i] * 2;
                    int uvIndex2 = uvidx[i - 1] * 2;
                    int uvIndex1 = uvidx[i - 2] * 2;
                    uvs.add(Float.valueOf(modelUv[uvIndex1 + 0]));
                    uvs.add(Float.valueOf(1.0f - modelUv[uvIndex1 + 1]));
                    uvs.add(Float.valueOf(modelUv[uvIndex2 + 0]));
                    uvs.add(Float.valueOf(1.0f - modelUv[uvIndex2 + 1]));
                    uvs.add(Float.valueOf(modelUv[uvIndex3 + 0]));
                    uvs.add(Float.valueOf(1.0f - modelUv[uvIndex3 + 1]));
                }
            } else {
                index1 = vidx[i - 3];
                index2 = vidx[i - 2];
                index3 = vidx[i - 1];
                int index4 = vidx[i] * -1 - 1;
                indices.add(indexCount++);
                indices.add(indexCount++);
                indices.add(indexCount++);
                indices.add(indexCount++);
                indices.add(indexCount++);
                indices.add(indexCount++);
                quadIds[0] = index1 * 3;
                quadIds[1] = index2 * 3;
                quadIds[2] = index3 * 3;
                quadIds[3] = index4 * 3;
                quadIds[4] = index1 * 3;
                quadIds[5] = index3 * 3;
                for (j = 0; j < 6; ++j) {
                    int cid = quadIds[j];
                    for (k = 0; k < 3; ++k) {
                        vertices.add(Float.valueOf(modelVerts[cid + k]));
                        normals.add(Float.valueOf(modelNorm[cid + k]));
                    }
                }
                if (hasUVs) {
                    int uvIndex1 = uvidx[i - 3] * 2;
                    int uvIndex2 = uvidx[i - 2] * 2;
                    int uvIndex3 = uvidx[i - 1] * 2;
                    int uvIndex4 = uvidx[i] * 2;
                    quadIds[0] = uvIndex1;
                    quadIds[1] = uvIndex2;
                    quadIds[2] = uvIndex3;
                    quadIds[3] = uvIndex4;
                    quadIds[4] = uvIndex1;
                    quadIds[5] = uvIndex3;
                    for (j = 0; j < 6; ++j) {
                        int cid = quadIds[j];
                        for (k = 0; k < 2; ++k) {
                            if (k == 0) {
                                uvs.add(Float.valueOf(modelUv[cid + k]));
                                continue;
                            }
                            uvs.add(Float.valueOf(1.0f - modelUv[cid + k]));
                        }
                    }
                }
            }
            count = 0;
        }
        o.setData(LoaderFBX.convertFloats(vertices), LoaderFBX.convertFloats(normals), hasUVs ? LoaderFBX.convertFloats(uvs) : null, null, LoaderFBX.convertIntegers(indices), false);
        vertices.clear();
        vertices = null;
        normals.clear();
        normals = null;
        if (hasUVs) {
            uvs.clear();
            uvs = null;
        }
        indices.clear();
        indices = null;
        o.setMaterial(this.getMaterialForMesh(o, model.name));
        this.setMeshTextures(o, model.name);
        o.setPosition(model.properties.lclTranslation);
        o.setX(o.getX() * -1.0);
        o.setScale(model.properties.lclScaling);
        o.setRotation(model.properties.lclRotation);
        o.setRotZ(-o.getRotZ());
        this.mRootObject.addChild(o);
    }

    public static int[] convertIntegers(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        int len = ret.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = integers.get(i);
        }
        return ret;
    }

    public static float[] convertFloats(List<Float> floats) {
        float[] ret = new float[floats.size()];
        int len = ret.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = floats.get(i).floatValue();
        }
        return ret;
    }

    private void setMeshTextures(Object3D o, String name) throws ATexture.TextureException, ParsingException {
        Stack<FBXValues.Objects.Texture> textures = this.mFbx.objects.textures;
        Stack<FBXValues.Connections.Connect> connections = this.mFbx.connections.connections;
        int numTex = textures.size();
        int numCon = connections.size();
        for (int i = 0; i < numTex; ++i) {
            FBXValues.Objects.Texture tex = (FBXValues.Objects.Texture)textures.get(i);
            for (int j = 0; j < numCon; ++j) {
                FBXValues.Connections.Connect conn = (FBXValues.Connections.Connect)connections.get(j);
                if (!conn.object2.equals(name) || !conn.object1.equals(tex.textureName)) continue;
                String textureName = tex.fileName;
                Bitmap bitmap = null;
                if (this.mFile == null) {
                    int identifier = this.mResources.getIdentifier(this.getFileNameWithoutExtension(textureName).toLowerCase(Locale.US), "drawable", this.mResources.getResourcePackageName(this.mResourceId));
                    bitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)identifier);
                } else {
                    try {
                        String filePath = this.mFile.getParent() + File.separatorChar + this.getOnlyFileName(textureName);
                        bitmap = BitmapFactory.decodeFile((String)filePath);
                    }
                    catch (Exception e) {
                        throw new ParsingException("[" + this.getClass().getCanonicalName() + "] Could not find file " + this.getOnlyFileName(textureName));
                    }
                }
                o.getMaterial().setColorInfluence(0.0f);
                o.getMaterial().addTexture(new Texture(textureName.replaceAll("[\\W]|_", REPLACE_EMPTY), bitmap));
                return;
            }
        }
    }

    private Material getMaterialForMesh(Object3D o, String name) {
        Material mat = new Material();
        FBXValues.Objects.FBXMaterial material = null;
        Stack<FBXValues.Connections.Connect> conns = this.mFbx.connections.connections;
        int num = conns.size();
        String materialName = null;
        for (int i = 0; i < num; ++i) {
            if (!((FBXValues.Connections.Connect)conns.get((int)i)).object2.equals(name)) continue;
            materialName = ((FBXValues.Connections.Connect)conns.get((int)i)).object1;
            break;
        }
        if (materialName != null) {
            Stack<FBXValues.Objects.FBXMaterial> materials = this.mFbx.objects.materials;
            num = materials.size();
            for (int i = 0; i < num; ++i) {
                if (!((FBXValues.Objects.FBXMaterial)materials.get((int)i)).name.equals(materialName)) continue;
                material = (FBXValues.Objects.FBXMaterial)materials.get(i);
                break;
            }
        }
        if (material != null) {
            mat.setDiffuseMethod(new DiffuseMethod.Lambert());
            mat.enableLighting(true);
            Vector3 color = material.properties.diffuseColor;
            mat.setColor(Color.rgb((int)((int)(color.x * 255.0)), (int)((int)(color.y * 255.0)), (int)((int)(color.z * 255.0))));
            color = material.properties.ambientColor;
            mat.setAmbientColor(Color.rgb((int)((int)(color.x * 255.0)), (int)((int)(color.y * 255.0)), (int)((int)(color.z * 255.0))));
            float intensity = material.properties.ambientFactor.floatValue();
            mat.setAmbientIntensity(intensity, intensity, intensity);
            if (material.shadingModel.equals("phong")) {
                SpecularMethod.Phong method = new SpecularMethod.Phong();
                if (material.properties.specularColor != null) {
                    color = material.properties.specularColor;
                    method.setSpecularColor(Color.rgb((int)((int)(color.x * 255.0)), (int)((int)(color.y * 255.0)), (int)((int)(color.z * 255.0))));
                }
                if (material.properties.shininess != null) {
                    method.setShininess(material.properties.shininess.floatValue());
                }
            }
        }
        return mat;
    }

    private void readLine(BufferedReader buffer, String line) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        if (line.replaceAll(REGEX_CLEAN, REPLACE_EMPTY).length() == 0) {
            return;
        }
        if (line.contains("{")) {
            Object last = this.mObjStack.peek();
            if (line.contains(":")) {
                if (line.contains(OBJECT_TYPE)) {
                    String val = line.split(":")[1].replaceAll(REGEX_NO_FUNNY_CHARS, REPLACE_EMPTY);
                    Object ot = last.getClass().getDeclaredMethod("addObjectType", String.class).invoke(last, val);
                    this.mObjStack.push(ot);
                    return;
                }
                if (line.contains(MODEL)) {
                    String[] vals = line.split(",");
                    if (vals.length < 2) {
                        this.mObjStack.push(new Object());
                        return;
                    }
                    vals[0] = vals[0].split(": ")[1].replaceAll(REGEX_NO_QUOTE, REPLACE_EMPTY);
                    vals[1] = vals[1].replaceAll(REGEX_NO_FUNNY_CHARS, REPLACE_EMPTY);
                    Object mo = last.getClass().getDeclaredMethod("addModel", String.class, String.class).invoke(last, vals[0], vals[1]);
                    this.mObjStack.push(mo);
                    return;
                }
                if (line.contains(MATERIAL) && !line.contains(LAYER_ELEMENT)) {
                    String[] vals = line.split(": ")[1].split(",");
                    vals[0] = vals[0].replaceAll(REGEX_NO_SPACE_NO_QUOTE, REPLACE_EMPTY);
                    Object ma = last.getClass().getDeclaredMethod("addMaterial", String.class).invoke(last, vals[0]);
                    this.mObjStack.push(ma);
                    return;
                }
                if (line.contains(POSE_NODE)) {
                    Object pn = last.getClass().getDeclaredMethod("addPoseNode", new Class[0]).invoke(last, new Object[0]);
                    this.mObjStack.push(pn);
                    return;
                }
                if (line.contains(PROPERTIES)) {
                    line = PROPERTIES;
                } else if (line.contains(LAYER_ELEMENT)) {
                    line = line.replaceAll("\\W|\\d", REPLACE_EMPTY);
                } else if (line.contains(LAYER)) {
                    line = LAYER;
                } else if (line.contains(POSE)) {
                    String val = line.split(":")[1];
                    String[] vals = val.split(",");
                    last.getClass().getDeclaredMethod("setPoseName", String.class).invoke(last, vals[0].replaceAll(REGEX_NO_FUNNY_CHARS, REPLACE_EMPTY));
                    line = POSE;
                } else if (line.contains(TEXTURE)) {
                    String val = line.split(": ")[1];
                    String[] vals = val.split(",");
                    Object te = last.getClass().getDeclaredMethod("addTexture", String.class, String.class).invoke(last, vals[0].replaceAll(REGEX_NO_QUOTE, REPLACE_EMPTY), vals[1].replace(REGEX_NO_QUOTE, REPLACE_EMPTY));
                    this.mObjStack.push(te);
                    return;
                }
            }
            line = line.replaceAll(REGEX_NO_FUNNY_CHARS, REPLACE_EMPTY);
            line = line.replaceAll(FBX_U, FBX_L);
            line = line.substring(0, 1).toLowerCase(Locale.US) + line.substring(1);
            try {
                Field field = last.getClass().getField(line);
                this.mObjStack.push(field.get(last));
            }
            catch (NoSuchFieldException e) {
                this.mObjStack.push(new Object());
                return;
            }
        }
        if (line.contains("}")) {
            this.mObjStack.pop();
        } else {
            Object last = this.mObjStack.peek();
            String[] spl = line.split(": ");
            if (spl.length == 0) {
                return;
            }
            String prop = spl[0].replaceAll(REGEX_NO_FUNNY_CHARS, REPLACE_EMPTY);
            prop = prop.replaceAll(FBX_U, FBX_L);
            prop = prop.substring(0, 1).toLowerCase(Locale.US) + prop.substring(1);
            boolean processNextLine = false;
            Object obj = this.mObjStack.peek();
            try {
                if (spl.length < 2) {
                    return;
                }
                String val = spl[1];
                if (line.contains(PROPERTY)) {
                    String[] vals = val.split(",");
                    prop = vals[0].replaceAll(REGEX_NO_FUNNY_CHARS, REPLACE_EMPTY);
                    prop = prop.substring(0, 1).toLowerCase(Locale.US) + prop.substring(1);
                    String type = vals[1].replaceAll(REGEX_NO_FUNNY_CHARS, REPLACE_EMPTY);
                    if (type.equals(TYPE_VECTOR3D) || type.equals(TYPE_COLOR) || type.equals(TYPE_COLOR_RGB) || type.equals(TYPE_LCL_ROTATION) || type.equals(TYPE_LCL_SCALING) || type.equals(TYPE_LCL_TRANSLATION) || type.equals(TYPE_VECTOR)) {
                        val = vals[3] + "," + vals[4] + "," + vals[5];
                    } else {
                        if (vals.length < 4) {
                            return;
                        }
                        val = vals[3].replaceAll(REGEX_NO_QUOTE, REPLACE_EMPTY);
                    }
                } else if (line.contains(CONNECT)) {
                    String[] vals = line.substring(line.indexOf(58)).split(",");
                    last.getClass().getDeclaredMethod("addConnection", String.class, String.class, String.class).invoke(last, vals[0].replaceAll(REGEX_NO_SPACE_NO_QUOTE, REPLACE_EMPTY), vals[1].replaceAll(REGEX_NO_SPACE_NO_QUOTE, REPLACE_EMPTY), vals[2].replaceAll(REGEX_NO_SPACE_NO_QUOTE, REPLACE_EMPTY));
                    return;
                }
                Field field = obj.getClass().getField(prop);
                Class<?> clazz = field.getType();
                if (clazz.equals(Integer.class)) {
                    if (val.split(",").length > 0) {
                        val = val.split(",")[0];
                    }
                    field.set(obj, Integer.valueOf(val.replaceAll(REGEX_NO_SPACE_NO_QUOTE, REPLACE_EMPTY)));
                } else if (clazz.equals(String.class)) {
                    field.set(obj, val.replaceAll(REGEX_NO_QUOTE, REPLACE_EMPTY));
                } else if (clazz.equals(Long.class)) {
                    field.set(obj, Long.valueOf(val.replaceAll(REGEX_NO_SPACE_NO_QUOTE, REPLACE_EMPTY)));
                } else if (clazz.equals(Float.class)) {
                    field.set(obj, Float.valueOf(val.replaceAll(REGEX_NO_SPACE_NO_QUOTE, REPLACE_EMPTY)));
                } else if (clazz.equals(Vector3.class)) {
                    field.set(obj, new Vector3(val.split(",")));
                } else if (clazz.equals(FBXValues.FBXFloatBuffer.class)) {
                    StringBuffer sb = new StringBuffer(val);
                    while ((line = buffer.readLine()) != null) {
                        String noSpace = line.replaceAll("\\s", REPLACE_EMPTY);
                        if (noSpace.length() > 0 && noSpace.charAt(0) == ',') {
                            sb.append(noSpace);
                            continue;
                        }
                        processNextLine = true;
                        break;
                    }
                    field.set(obj, new FBXValues.FBXFloatBuffer(sb.toString()));
                } else if (clazz.equals(FBXValues.FBXIntBuffer.class)) {
                    StringBuffer sb = new StringBuffer(val);
                    while ((line = buffer.readLine()) != null) {
                        String noSpace = line.replaceAll("\\s", REPLACE_EMPTY);
                        if (noSpace.length() > 0 && noSpace.charAt(0) == ',') {
                            sb.append(noSpace);
                            continue;
                        }
                        processNextLine = true;
                        break;
                    }
                    field.set(obj, new FBXValues.FBXIntBuffer(sb.toString()));
                } else if (clazz.equals(FBXValues.FBXMatrix.class)) {
                    StringBuffer sb = new StringBuffer(val);
                    while ((line = buffer.readLine()) != null) {
                        String noSpace = line.replaceAll(REGEX_CLEAN, REPLACE_EMPTY);
                        if (noSpace.length() > 0 && noSpace.charAt(0) == ',') {
                            sb.append(noSpace);
                            continue;
                        }
                        processNextLine = true;
                        break;
                    }
                    field.set(obj, new FBXValues.FBXMatrix(sb.toString()));
                } else if (clazz.equals(FBXValues.FBXColor4.class)) {
                    field.set(obj, new FBXValues.FBXColor4(val));
                } else if (clazz.equals(Vector2.class)) {
                    field.set(obj, new Vector2(val.replaceAll("\\s", REPLACE_EMPTY).split(",")));
                }
                if (processNextLine && line.replaceAll(REGEX_CLEAN, REPLACE_EMPTY).length() > 0) {
                    this.readLine(buffer, line);
                }
            }
            catch (NoSuchFieldException e) {
                return;
            }
        }
    }
}

