/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader.awd;

import android.util.SparseArray;
import java.util.ArrayList;
import org.rajawali3d.Object3D;
import org.rajawali3d.animation.mesh.SkeletalAnimationChildObject3D;
import org.rajawali3d.animation.mesh.SkeletalAnimationObject3D;
import org.rajawali3d.loader.LoaderAWD;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.loader.awd.ABaseObjectBlockParser;
import org.rajawali3d.util.RajLog;

public class BlockTriangleGeometry
extends ABaseObjectBlockParser {
    protected Object3D finalObject = null;
    protected Object3D[] mBaseObjects;
    protected String mLookupName;
    protected int mSubGeometryCount;

    @Override
    public Object3D getBaseObject3D() {
        if (this.finalObject != null) {
            return this.finalObject;
        }
        if (this.mBaseObjects[0] instanceof SkeletalAnimationChildObject3D) {
            SkeletalAnimationObject3D container = new SkeletalAnimationObject3D();
            for (int i = 0; i < this.mBaseObjects.length; ++i) {
                SkeletalAnimationChildObject3D child = (SkeletalAnimationChildObject3D)this.mBaseObjects[i];
                child.setSkeleton(container);
                container.addChild(child);
            }
            this.finalObject = container;
        } else if (this.mBaseObjects.length == 1) {
            this.finalObject = this.mBaseObjects[0];
        } else {
            Object3D container = new Object3D(this.mLookupName);
            container.isContainer(true);
            for (int i = 0; i < this.mBaseObjects.length; ++i) {
                container.addChild(this.mBaseObjects[i]);
            }
            this.finalObject = container;
        }
        return this.finalObject;
    }

    @Override
    public void parseBlock(LoaderAWD.AWDLittleEndianDataInputStream dis, LoaderAWD.BlockHeader blockHeader) throws Exception {
        this.mLookupName = dis.readVarString();
        this.mSubGeometryCount = dis.readUnsignedShort();
        this.mBaseObjects = new Object3D[this.mSubGeometryCount];
        if (RajLog.isDebugEnabled()) {
            RajLog.d("  Lookup Name: " + this.mLookupName);
            RajLog.d("  Sub Geometry Count: " + this.mSubGeometryCount);
        }
        boolean geoAccuracy = (blockHeader.flags & 2) == 2;
        short geoNr = geoAccuracy ? (short)8 : 7;
        SparseArray properties = new SparseArray();
        properties.put(1, (Object)geoNr);
        properties.put(2, (Object)geoNr);
        dis.readProperties((SparseArray<Short>)properties);
        int geoPrecisionSize = blockHeader.globalPrecisionGeo ? 8 : 4;
        for (int parsedSub = 0; parsedSub < this.mSubGeometryCount; ++parsedSub) {
            long subMeshEnd = dis.getPosition() + dis.readUnsignedInt();
            float[] vertices = null;
            int[] indices = null;
            float[] uvs = null;
            float[] normals = null;
            int[] joints = null;
            float[] weights = null;
            dis.readProperties();
            while (dis.getPosition() < subMeshEnd) {
                int idx = 0;
                int type = dis.readUnsignedByte();
                int typeF = dis.readUnsignedByte();
                long subLength = dis.readUnsignedInt();
                long subEnd = dis.getPosition() + subLength;
                if (RajLog.isDebugEnabled()) {
                    RajLog.d("   Mesh Data: t:" + type + " tf:" + typeF + " l:" + subLength + " ls:" + dis.getPosition() + " le:" + subEnd);
                }
                switch (type) {
                    case 1: {
                        vertices = new float[(int)(subLength / (long)geoPrecisionSize)];
                        while (idx < vertices.length) {
                            vertices[idx++] = (float)dis.readPrecisionNumber(blockHeader.globalPrecisionGeo);
                            vertices[idx++] = (float)dis.readPrecisionNumber(blockHeader.globalPrecisionGeo);
                            vertices[idx++] = (float)(-dis.readPrecisionNumber(blockHeader.globalPrecisionGeo));
                        }
                        break;
                    }
                    case 2: {
                        indices = new int[(int)(subLength / 2L)];
                        while (idx < indices.length) {
                            indices[idx + 2] = dis.readUnsignedShort();
                            indices[idx + 1] = dis.readUnsignedShort();
                            indices[idx] = dis.readUnsignedShort();
                            idx += 3;
                        }
                        break;
                    }
                    case 3: {
                        uvs = new float[(int)(subLength / (long)geoPrecisionSize)];
                        while (idx < uvs.length) {
                            uvs[idx++] = (float)dis.readPrecisionNumber(blockHeader.globalPrecisionGeo);
                        }
                        break;
                    }
                    case 4: {
                        normals = new float[(int)(subLength / (long)geoPrecisionSize)];
                        while (idx < normals.length) {
                            normals[idx++] = (float)dis.readPrecisionNumber(blockHeader.globalPrecisionGeo);
                            normals[idx++] = (float)dis.readPrecisionNumber(blockHeader.globalPrecisionGeo);
                            normals[idx++] = (float)dis.readPrecisionNumber(blockHeader.globalPrecisionGeo);
                        }
                        break;
                    }
                    case 6: {
                        joints = new int[(int)(subLength / 2L)];
                        while (idx < joints.length) {
                            joints[idx++] = dis.readUnsignedShort();
                        }
                        break;
                    }
                    case 7: {
                        weights = new float[(int)(subLength / (long)geoPrecisionSize)];
                        while (idx < weights.length) {
                            weights[idx++] = (float)dis.readPrecisionNumber(blockHeader.globalPrecisionGeo);
                        }
                        break;
                    }
                    default: {
                        dis.skip(subLength);
                    }
                }
                if (dis.getPosition() == subEnd) continue;
                throw new ParsingException("Unexpected ending. Expected " + subEnd + ". Got " + dis.getPosition());
            }
            dis.readUserAttributes(null);
            if (vertices == null) {
                vertices = new float[]{};
            }
            if (normals == null) {
                normals = new float[]{};
            }
            if (uvs == null) {
                uvs = new float[]{};
            }
            if (indices == null) {
                indices = new int[]{};
            }
            if (joints != null && joints.length > 0) {
                SkeletalAnimationChildObject3D obj = new SkeletalAnimationChildObject3D();
                obj.setData(vertices, normals, uvs, null, indices, false);
                int numVertices = vertices.length / 3;
                int weightsPerVertex = weights.length / numVertices;
                int clampWeightsPerVertex = Math.min(weightsPerVertex, 8);
                SkeletalAnimationChildObject3D.BoneVertex[] bvertices = new SkeletalAnimationChildObject3D.BoneVertex[numVertices];
                ArrayList<SkeletalAnimationChildObject3D.BoneWeight> bweights = new ArrayList<SkeletalAnimationChildObject3D.BoneWeight>();
                int maxWeightsPerVertex = 0;
                int vertexWeightIndex = 0;
                for (int vert = 0; vert < numVertices; ++vert) {
                    SkeletalAnimationChildObject3D.BoneVertex bone;
                    bvertices[vert] = bone = new SkeletalAnimationChildObject3D.BoneVertex();
                    bone.weightIndex = bweights.size();
                    vertexWeightIndex = vert * weightsPerVertex;
                    for (int wgt = 0; wgt < clampWeightsPerVertex; ++wgt) {
                        if (weights[vertexWeightIndex + wgt] == 0.0f) continue;
                        SkeletalAnimationChildObject3D.BoneWeight weight = new SkeletalAnimationChildObject3D.BoneWeight();
                        weight.jointIndex = joints[vertexWeightIndex + wgt];
                        weight.weightValue = weights[vertexWeightIndex + wgt];
                        ++bone.numWeights;
                        bweights.add(weight);
                    }
                    maxWeightsPerVertex = Math.max(maxWeightsPerVertex, bone.numWeights);
                }
                SkeletalAnimationChildObject3D.BoneWeight[] boneweights = bweights.toArray(new SkeletalAnimationChildObject3D.BoneWeight[bweights.size()]);
                obj.setMaxBoneWeightsPerVertex(maxWeightsPerVertex);
                obj.setSkeletonMeshData(bvertices, boneweights);
                this.mBaseObjects[parsedSub] = obj;
                continue;
            }
            this.mBaseObjects[parsedSub] = new Object3D();
            this.mBaseObjects[parsedSub].setData(vertices, normals, uvs, null, indices, false);
        }
        dis.readUserAttributes(null);
    }
}

