/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader.awd;

import org.rajawali3d.animation.mesh.SkeletalAnimationFrame;
import org.rajawali3d.animation.mesh.SkeletalAnimationSequence;
import org.rajawali3d.loader.LoaderAWD;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.loader.awd.ABlockParser;
import org.rajawali3d.loader.awd.BlockSkeletonPose;

public class BlockSkeletonAnimation
extends ABlockParser {
    protected SkeletalAnimationSequence mSkelAnim;
    protected String mLookupName;
    protected int mNumFrames;

    @Override
    public void parseBlock(LoaderAWD.AWDLittleEndianDataInputStream dis, LoaderAWD.BlockHeader blockHeader) throws Exception {
        this.mLookupName = dis.readVarString();
        this.mNumFrames = dis.readUnsignedShort();
        dis.readProperties(null);
        SkeletalAnimationFrame[] frames = new SkeletalAnimationFrame[this.mNumFrames];
        double[] frameDurations = new double[this.mNumFrames];
        for (int i = 0; i < this.mNumFrames; ++i) {
            long poseAddr = dis.readUnsignedInt();
            int duration = dis.readUnsignedShort();
            SkeletalAnimationFrame frame = this.lookup(blockHeader, poseAddr);
            frame.setFrameIndex(i);
            frameDurations[i] = duration;
            frames[i] = frame;
        }
        dis.readProperties(null);
        this.mSkelAnim = new SkeletalAnimationSequence(this.mLookupName);
        this.mSkelAnim.setFrameData(frameDurations);
        this.mSkelAnim.setFrames(frames);
    }

    private SkeletalAnimationFrame lookup(LoaderAWD.BlockHeader blockHeader, long addr) throws ParsingException {
        LoaderAWD.BlockHeader lookupHeader = (LoaderAWD.BlockHeader)blockHeader.blockHeaders.get((int)addr);
        if (lookupHeader == null || lookupHeader.parser == null || !(lookupHeader.parser instanceof BlockSkeletonPose)) {
            throw new ParsingException("Invalid block reference.");
        }
        return ((BlockSkeletonPose)lookupHeader.parser).mPose;
    }

    public SkeletalAnimationSequence getAnimation() {
        return this.mSkelAnim;
    }
}

