/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader.awd;

import android.graphics.Bitmap;
import android.util.SparseArray;
import java.util.HashMap;
import java.util.UUID;
import org.rajawali3d.loader.LoaderAWD;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.loader.awd.ATextureBlockParser;
import org.rajawali3d.loader.awd.BlockBitmapTexture;
import org.rajawali3d.loader.awd.exceptions.NotParsableException;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.methods.DiffuseMethod;
import org.rajawali3d.materials.methods.SpecularMethod;
import org.rajawali3d.materials.textures.NormalMapTexture;
import org.rajawali3d.materials.textures.SpecularMapTexture;
import org.rajawali3d.materials.textures.Texture;
import org.rajawali3d.util.RajLog;

public class BlockSimpleMaterial
extends ATextureBlockParser {
    public static final byte MATERIAL_TYPE_COLOR = 1;
    public static final byte MATERIAL_TYPE_TEXTURE = 2;
    protected static final int TYPE_COLOR = 1;
    protected static final int TYPE_TEXTURE = 2;
    protected static final short PROP_COLOR = 1;
    protected static final short PROP_TEXTURE = 2;
    protected static final short PROP_NORMAL_TEXTURE = 3;
    protected static final short PROP_SPEZIAL_ID = 4;
    protected static final short PROP_SMOOTH = 5;
    protected static final short PROP_MIPMAP = 6;
    protected static final short PROP_BOTH_SIDES = 7;
    protected static final short PROP_PRE_MULTIPLIED = 8;
    protected static final short PROP_BLEND_MODE = 9;
    protected static final short PROP_ALPHA = 10;
    protected static final short PROP_ALPHA_BLENDING = 11;
    protected static final short PROP_BINARY_ALPHA_THRESHOLD = 12;
    protected static final short PROP_REPEAT = 13;
    protected static final short PROP_DIFFUSE_LEVEL = 14;
    protected static final short PROP_AMBIENT_LEVEL = 15;
    protected static final short PROP_AMBIENT_COLOR = 16;
    protected static final short PROP_AMBIENT_TEXTURE = 17;
    protected static final short PROP_SPECULAR_LEVEL = 18;
    protected static final short PROP_SPECULAR_GLOSS = 19;
    protected static final short PROP_SPECULAR_COLOR = 20;
    protected static final short PROP_SPECULAR_TEXTURE = 21;
    protected static final short PROP_LIGHT_PICKER = 22;
    private static final SparseArray<Short> EXPECTED_PROPS = new SparseArray();
    protected Material mMaterial;
    protected String mLookupName;
    protected byte mMaterialType;
    protected byte mShadingMethodCount;
    protected int mSpezialType;
    private static final String TEX_PREFIX = "TEX_";

    @Override
    public Material getMaterial() {
        return this.mMaterial;
    }

    @Override
    public void parseBlock(LoaderAWD.AWDLittleEndianDataInputStream dis, LoaderAWD.BlockHeader blockHeader) throws Exception {
        this.mLookupName = dis.readVarString();
        this.mMaterialType = dis.readByte();
        this.mShadingMethodCount = dis.readByte();
        LoaderAWD.AwdProperties properties = dis.readProperties(EXPECTED_PROPS);
        this.mSpezialType = (Integer)properties.get((short)4, 0);
        if (this.mSpezialType >= 2) {
            throw new NotParsableException("Spezial type " + this.mSpezialType + " is not currently supported.");
        }
        if (RajLog.isDebugEnabled()) {
            RajLog.d("  Lookup Name: " + this.mLookupName);
            RajLog.d("  Material Type: " + this.mMaterialType);
            RajLog.d("  Shading Methods: " + this.mShadingMethodCount);
            RajLog.d("  Spezial Type: " + this.mSpezialType);
        }
        for (int i = 0; i < this.mShadingMethodCount; ++i) {
            dis.readUnsignedShort();
            dis.readProperties();
            dis.readUserAttributes(null);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        dis.readUserAttributes(attributes);
        this.mMaterial = new Material();
        long diffuseTexture = 0L;
        long ambientTexture = 0L;
        long diffuseColor = 0L;
        String cleanName = this.cleanName(this.mLookupName);
        switch (this.mMaterialType) {
            case 1: {
                diffuseColor = (Long)properties.get((short)1, 0xCCCCCCL);
                float[] colorFloat = new float[]{(float)(diffuseColor >> 16 & 0xFFL) / 255.0f, (float)(diffuseColor >> 8 & 0xFFL) / 255.0f, (float)(diffuseColor & 0xFFL) / 255.0f, (float)((int)((Double)properties.get((short)10, 1.0) * 255.0) & 0xFF) / 255.0f};
                this.mMaterial.setColor(colorFloat);
                break;
            }
            case 2: {
                diffuseTexture = (Long)properties.get((short)2, 0L);
                ambientTexture = (Long)properties.get((short)17, 0L);
                if (diffuseTexture == 0L && ambientTexture == 0L) {
                    throw new ParsingException("Texture ID can not be 0, document corrupt or unsupported version.");
                }
                if (diffuseTexture > 0L) {
                    this.mMaterial.addTexture(new Texture(cleanName + diffuseTexture, this.lookup(blockHeader, diffuseTexture)));
                }
                if (ambientTexture > 0L) {
                    this.mMaterial.addTexture(new Texture(cleanName + ambientTexture, this.lookup(blockHeader, ambientTexture)));
                }
                this.mMaterial.setColorInfluence(0.0f);
            }
        }
        long specularTexture = (Long)properties.get((short)21, 0L);
        long normalTexture = (Long)properties.get((short)3, 0L);
        double diffuseLevel = (Double)properties.get((short)14, 1.0);
        long ambientColor = (Long)properties.get((short)16, -1L);
        double ambientLevel = (Double)properties.get((short)15, 1.0);
        long specularColor = (Long)properties.get((short)20, -1L);
        double specularGloss = (Double)properties.get((short)19, 50.0);
        double specularLevel = (Double)properties.get((short)18, 1.0);
        if (specularTexture > 0L) {
            this.mMaterial.addTexture(new SpecularMapTexture(cleanName + specularTexture, this.lookup(blockHeader, specularTexture)));
        }
        if (normalTexture > 0L) {
            this.mMaterial.addTexture(new NormalMapTexture(cleanName + normalTexture, this.lookup(blockHeader, normalTexture)));
        }
        ambientLevel = ambientLevel < 1.0 ? ambientLevel : 0.0;
        this.mMaterial.setAmbientIntensity(ambientLevel, ambientLevel, ambientLevel);
        this.mMaterial.setAmbientColor((int)ambientColor);
        if (diffuseLevel > 0.0) {
            this.mMaterial.setDiffuseMethod(new DiffuseMethod.Lambert());
        }
        if (specularLevel > 0.0) {
            SpecularMethod.Phong phong = new SpecularMethod.Phong();
            phong.setSpecularColor((int)specularColor);
            phong.setShininess((float)specularGloss);
            phong.setIntensity((float)specularLevel);
            this.mMaterial.setSpecularMethod(phong);
        }
        if (diffuseLevel > 0.0 || specularLevel > 0.0) {
            this.mMaterial.enableLighting(true);
        }
    }

    private Bitmap lookup(LoaderAWD.BlockHeader blockHeader, long texref) throws ParsingException {
        LoaderAWD.BlockHeader lookupHeader = (LoaderAWD.BlockHeader)blockHeader.blockHeaders.get((int)((short)texref));
        if (lookupHeader == null || lookupHeader.parser == null || !(lookupHeader.parser instanceof BlockBitmapTexture)) {
            throw new ParsingException("Invalid block reference.");
        }
        return ((BlockBitmapTexture)lookupHeader.parser).mBitmap;
    }

    private String cleanName(String name) {
        String clean;
        String string = clean = name == null ? "" : name.replaceAll("\\W", "");
        if (clean.length() == 0 || Character.isDigit(clean.charAt(0))) {
            clean = TEX_PREFIX + UUID.randomUUID().toString().replaceAll("\\W", "");
        }
        return clean;
    }

    static {
        EXPECTED_PROPS.put(1, (Object)6);
        EXPECTED_PROPS.put(2, (Object)23);
        EXPECTED_PROPS.put(3, (Object)23);
        EXPECTED_PROPS.put(4, (Object)4);
        EXPECTED_PROPS.put(5, (Object)21);
        EXPECTED_PROPS.put(6, (Object)21);
        EXPECTED_PROPS.put(7, (Object)21);
        EXPECTED_PROPS.put(8, (Object)21);
        EXPECTED_PROPS.put(9, (Object)4);
        EXPECTED_PROPS.put(10, (Object)-1);
        EXPECTED_PROPS.put(11, (Object)21);
        EXPECTED_PROPS.put(12, (Object)-1);
        EXPECTED_PROPS.put(13, (Object)21);
        EXPECTED_PROPS.put(14, (Object)-1);
        EXPECTED_PROPS.put(15, (Object)-1);
        EXPECTED_PROPS.put(16, (Object)6);
        EXPECTED_PROPS.put(17, (Object)23);
        EXPECTED_PROPS.put(18, (Object)-1);
        EXPECTED_PROPS.put(19, (Object)-1);
        EXPECTED_PROPS.put(20, (Object)6);
        EXPECTED_PROPS.put(21, (Object)23);
        EXPECTED_PROPS.put(22, (Object)23);
    }
}

