/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader.awd;

import org.rajawali3d.Object3D;
import org.rajawali3d.loader.LoaderAWD;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.loader.awd.ABaseObjectBlockParser;
import org.rajawali3d.util.RajLog;

public class BlockPrimitiveGeometry
extends ABaseObjectBlockParser {
    protected Object3D mBaseObject;
    protected int mPrimitiveType;
    protected String mLookupName;

    @Override
    public Object3D getBaseObject3D() {
        return this.mBaseObject;
    }

    @Override
    public void parseBlock(LoaderAWD.AWDLittleEndianDataInputStream dis, LoaderAWD.BlockHeader blockHeader) throws Exception {
        this.mLookupName = dis.readVarString();
        this.mPrimitiveType = dis.readUnsignedByte();
        if (RajLog.isDebugEnabled()) {
            RajLog.d("  Lookup Name: " + this.mLookupName);
            RajLog.d("  Primitive Type: " + this.mPrimitiveType);
        }
        switch (PrimitiveType.values()[this.mPrimitiveType - 1]) {
            case CUBE: {
                float width = dis.readFloat();
                float height = dis.readFloat();
                float depth = dis.readFloat();
                int segmentsW = dis.readUnsignedShort();
                int segmentsH = dis.readUnsignedShort();
                int segmentsD = dis.readUnsignedShort();
                boolean tile6 = dis.readBoolean();
                throw new ParsingException("Type of Cube is not yet supported!");
            }
            case CAPSULE: {
                throw new ParsingException("Type of Capsule is not yet supported!");
            }
            case CONE: {
                throw new ParsingException("Type of Cone is not yet supported!");
            }
            case CYLINDER: {
                float radiusTop = dis.readFloat();
                float radiusBottom = dis.readFloat();
                float height = dis.readFloat();
                int segmentsW = dis.readUnsignedShort();
                int segmentsH = dis.readUnsignedShort();
                boolean topClosed = dis.readBoolean();
                boolean bottomClosed = dis.readBoolean();
                boolean yUp = dis.readBoolean();
                boolean surfaceClosed = dis.readBoolean();
                throw new ParsingException("Type of Cylinder is not yet supported!");
            }
            case PLANE: {
                float width = dis.readFloat();
                float height = dis.readFloat();
                int segmentsW = dis.readUnsignedShort();
                int segmentsH = dis.readUnsignedShort();
                boolean yUp = dis.readBoolean();
                boolean doubleSided = dis.readBoolean();
                throw new ParsingException("Type of Plane is not yet supported!");
            }
            case SPHERE: {
                float radius = dis.readFloat();
                int segmentsW = dis.readUnsignedShort();
                int segmentsH = dis.readUnsignedShort();
                boolean yUp = dis.readBoolean();
                throw new ParsingException("Type of Cylinder is not yet supported!");
            }
            case TORUS: {
                throw new ParsingException("Type of Torus is not yet supported!");
            }
        }
    }

    static enum PrimitiveType {
        PLANE,
        CUBE,
        SPHERE,
        CYLINDER,
        CONE,
        CAPSULE,
        TORUS;

    }
}

