/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader.awd;

import android.util.SparseArray;
import org.rajawali3d.loader.LoaderAWD;
import org.rajawali3d.loader.awd.ABlockParser;
import org.rajawali3d.util.RajLog;

public class BlockMetaData
extends ABlockParser {
    private static final short PROP_TIMESTAMP = 1;
    private static final short PROP_ENCODER_NAME = 2;
    private static final short PROP_ENCODER_VERSION = 3;
    private static final short PROP_GENERATOR_NAME = 4;
    private static final short PROP_GENERATOR_VERSION = 5;
    private static final SparseArray<Short> EXPECTED_PROPS = new SparseArray();
    private long mTimeStamp;
    private String mEncoderName;
    private String mEncoderVersion;
    private String mGeneratorName;
    private String mGeneratorVersion;

    @Override
    public void parseBlock(LoaderAWD.AWDLittleEndianDataInputStream dis, LoaderAWD.BlockHeader blockHeader) throws Exception {
        LoaderAWD.AwdProperties properties = dis.readProperties(EXPECTED_PROPS);
        this.mTimeStamp = (Long)properties.get((short)1);
        this.mEncoderName = properties.get((short)2).toString();
        this.mEncoderVersion = properties.get((short)3).toString();
        this.mGeneratorName = properties.get((short)4).toString();
        this.mGeneratorVersion = properties.get((short)5).toString();
        if (RajLog.isDebugEnabled()) {
            RajLog.d("  Timestamp: " + this.mTimeStamp);
            RajLog.d("  Encoder Name: " + this.mEncoderName);
            RajLog.d("  Encoder Version: " + this.mEncoderVersion);
            RajLog.d("  Generator Name: " + this.mGeneratorName);
            RajLog.d("  Generator Version: " + this.mGeneratorVersion);
        }
    }

    static {
        EXPECTED_PROPS.put(1, (Object)6);
        EXPECTED_PROPS.put(2, (Object)31);
        EXPECTED_PROPS.put(3, (Object)31);
        EXPECTED_PROPS.put(4, (Object)31);
        EXPECTED_PROPS.put(5, (Object)31);
    }
}

