/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader.awd;

import android.util.SparseArray;
import org.rajawali3d.Object3D;
import org.rajawali3d.loader.LoaderAWD;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.loader.awd.ABaseObjectBlockParser;
import org.rajawali3d.loader.awd.AExportableBlockParser;
import org.rajawali3d.loader.awd.ATextureBlockParser;
import org.rajawali3d.loader.awd.SceneGraphBlock;
import org.rajawali3d.materials.Material;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.Quaternion;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.util.RajLog;

public class BlockMeshInstance
extends AExportableBlockParser {
    protected static final short PROP_CASTS_SHADOW = 5;
    protected Object3D mGeometry;
    protected SceneGraphBlock mSceneGraphBlock;
    protected boolean mCastsShadow;
    protected long mGeometryID;
    private static final SparseArray<Short> EXPECTED_PROPS = new SparseArray();

    @Override
    public Object3D getBaseObject3D() {
        return this.mGeometry;
    }

    @Override
    public void parseBlock(LoaderAWD.AWDLittleEndianDataInputStream dis, LoaderAWD.BlockHeader blockHeader) throws Exception {
        RajLog.d("Parsing SceneGraph Block at position: " + dis.getPosition());
        this.mSceneGraphBlock = new SceneGraphBlock();
        this.mSceneGraphBlock.readGraphData(blockHeader, dis);
        this.mGeometryID = dis.readUnsignedInt();
        LoaderAWD.BlockHeader geomHeader = (LoaderAWD.BlockHeader)blockHeader.blockHeaders.get((int)((short)this.mGeometryID));
        if (geomHeader == null) {
            this.mGeometry = new Object3D(this.mSceneGraphBlock.lookupName);
        } else {
            if (geomHeader.parser == null || !(geomHeader.parser instanceof ABaseObjectBlockParser)) {
                throw new ParsingException("Invalid block reference.");
            }
            this.mGeometry = ((ABaseObjectBlockParser)geomHeader.parser).getBaseObject3D().clone(false, true);
            this.mGeometry.setName(this.mSceneGraphBlock.lookupName);
        }
        int materialCount = dis.readUnsignedShort();
        Material[] materials = new Material[materialCount];
        for (int i = 0; i < materialCount; ++i) {
            long materialID = dis.readUnsignedInt();
            if (materialID == 0L) {
                materials[i] = BlockMeshInstance.getDefaultMaterial();
                materials[i].addTexture(BlockMeshInstance.getDefaultTexture());
                continue;
            }
            LoaderAWD.BlockHeader materialHeader = (LoaderAWD.BlockHeader)blockHeader.blockHeaders.get((int)((short)materialID));
            if (materialHeader == null || materialHeader.parser == null || !(materialHeader.parser instanceof ATextureBlockParser)) {
                throw new ParsingException("Invalid block reference " + materialID);
            }
            materials[i] = ((ATextureBlockParser)materialHeader.parser).getMaterial();
        }
        LoaderAWD.AwdProperties properties = dis.readProperties(EXPECTED_PROPS);
        this.mCastsShadow = (Boolean)properties.get((short)5, true);
        Matrix4 matrix = new Matrix4(this.mSceneGraphBlock.transformMatrix);
        this.mGeometry.setPosition(matrix.getTranslation());
        Vector3 scale = matrix.getScaling();
        this.mGeometry.setScale(scale.y, scale.x, scale.z);
        this.mGeometry.setOrientation(new Quaternion().fromMatrix(matrix));
        int m = 0;
        if (!this.mGeometry.isContainer()) {
            this.mGeometry.setMaterial(materials[m++]);
        }
        for (int i = 0; i < this.mGeometry.getNumChildren(); ++i) {
            this.mGeometry.getChildAt(i).setMaterial(materials[Math.min(materials.length - 1, m++)]);
        }
        dis.skip(blockHeader.blockEnd - dis.getPosition());
    }

    static {
        EXPECTED_PROPS.put(5, (Object)21);
    }
}

