/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader.awd;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import org.rajawali3d.loader.LoaderAWD;
import org.rajawali3d.loader.awd.ABlockParser;
import org.rajawali3d.loader.awd.exceptions.NotImplementedParsingException;
import org.rajawali3d.util.RajLog;

public class BlockBitmapTexture
extends ABlockParser {
    public static final byte IMAGE_TYPE_EXTERNAL = 0;
    public static final byte IMAGE_TYPE_EMBEDDED = 1;
    protected String mLookupName;
    protected byte mImageType;
    protected long mDataLength;
    protected Bitmap mBitmap;

    @Override
    public void parseBlock(LoaderAWD.AWDLittleEndianDataInputStream dis, LoaderAWD.BlockHeader blockHeader) throws Exception {
        this.mLookupName = dis.readVarString();
        this.mImageType = dis.readByte();
        this.mDataLength = dis.readUnsignedInt();
        if (RajLog.isDebugEnabled()) {
            RajLog.d("  Lookup Name: " + this.mLookupName);
            RajLog.d("  Data Length: " + this.mDataLength);
        }
        switch (this.mImageType) {
            case 0: {
                throw new NotImplementedParsingException();
            }
            case 1: {
                byte[] imageData = new byte[(int)this.mDataLength];
                dis.readFully(imageData);
                this.mBitmap = BitmapFactory.decodeByteArray((byte[])imageData, (int)0, (int)imageData.length);
            }
        }
        dis.readProperties();
        dis.readUserAttributes(null);
    }

    public Bitmap getTexture() {
        return this.mBitmap;
    }
}

