/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader.awd;

import android.util.SparseArray;
import org.rajawali3d.Object3D;
import org.rajawali3d.animation.mesh.IAnimationSequence;
import org.rajawali3d.animation.mesh.SkeletalAnimationChildObject3D;
import org.rajawali3d.animation.mesh.SkeletalAnimationFrame;
import org.rajawali3d.animation.mesh.SkeletalAnimationObject3D;
import org.rajawali3d.animation.mesh.SkeletalAnimationSequence;
import org.rajawali3d.loader.LoaderAWD;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.loader.awd.ABlockParser;
import org.rajawali3d.loader.awd.BlockAnimationSet;
import org.rajawali3d.loader.awd.BlockMeshInstance;
import org.rajawali3d.loader.awd.BlockSkeleton;
import org.rajawali3d.materials.plugins.SkeletalAnimationMaterialPlugin;
import org.rajawali3d.math.Matrix4;

public class BlockAnimator
extends ABlockParser {
    private static final int TYPE_SKELETAL_ANIM = 1;
    private static final int TYPE_VERTEX_ANIM = 2;
    protected String mLookupName;
    protected IAnimationSequence[] mAnimSet;
    protected Object3D[] mTargets;
    protected boolean mAutoPlay;
    protected int mActive;
    protected static final short PROP_SKELETON = 1;
    protected static final short PROP_CONDENSED = 701;
    private static final SparseArray<Short> EXPECTED_PROPS = new SparseArray();

    @Override
    public void parseBlock(LoaderAWD.AWDLittleEndianDataInputStream dis, LoaderAWD.BlockHeader blockHeader) throws Exception {
        this.mLookupName = dis.readVarString();
        int type = dis.readUnsignedShort();
        LoaderAWD.AwdProperties properties = null;
        switch (type) {
            case 1: {
                properties = dis.readProperties(EXPECTED_PROPS);
                break;
            }
            case 2: {
                dis.readProperties(null);
            }
        }
        long animSetID = dis.readUnsignedInt();
        this.mAnimSet = this.lookupAnimationSet(blockHeader, animSetID);
        int numTargets = dis.readUnsignedShort();
        this.mTargets = new Object3D[numTargets];
        for (int i = 0; i < numTargets; ++i) {
            this.mTargets[i] = this.lookupMesh(blockHeader, dis.readUnsignedInt());
        }
        this.mActive = dis.readUnsignedShort();
        this.mAutoPlay = dis.readBoolean();
        dis.readProperties(null);
        dis.readProperties(null);
        if (type == 1) {
            this.buildSkeleton(blockHeader, (Long)properties.get((short)1, 0L));
        }
    }

    private void buildSkeleton(LoaderAWD.BlockHeader blockHeader, long skelAddr) throws ParsingException {
        SkeletalAnimationFrame.SkeletonJoint[] joints = this.lookupSkeleton(blockHeader, skelAddr);
        SkeletalAnimationSequence[] skelAnims = new SkeletalAnimationSequence[this.mAnimSet.length];
        for (int i = 0; i < this.mAnimSet.length; ++i) {
            skelAnims[i] = (SkeletalAnimationSequence)this.mAnimSet[i];
        }
        Matrix4 scratch1 = new Matrix4();
        Matrix4 scratch2 = new Matrix4();
        for (SkeletalAnimationSequence skelSeq : skelAnims) {
            for (SkeletalAnimationFrame frame : skelSeq.getFrames()) {
                SkeletalAnimationFrame.SkeletonJoint[] poses = frame.getSkeleton().getJoints();
                for (int i = 0; i < poses.length; ++i) {
                    poses[i].setParentIndex(joints[i].getParentIndex());
                    if (poses[i].getParentIndex() >= 0) {
                        SkeletalAnimationFrame.SkeletonJoint parentPose = poses[poses[i].getParentIndex()];
                        scratch1.setAll(parentPose.getMatrix()).multiply(scratch2.setAll(poses[i].getMatrix()));
                        poses[i].setMatrix(scratch1.getDoubleValues());
                    } else {
                        scratch1.setAll(poses[i].getMatrix());
                    }
                    scratch1.getTranslation(poses[i].getPosition());
                    poses[i].getOrientation().fromMatrix(scratch1);
                    poses[i].getOrientation().computeW();
                }
            }
        }
        for (int i = 0; i < this.mTargets.length; ++i) {
            SkeletalAnimationObject3D obj = (SkeletalAnimationObject3D)this.mTargets[i];
            obj.setJointsWithInverseBindPoseMatrices(joints);
            for (int j = 0; j < obj.getNumChildren(); ++j) {
                SkeletalAnimationChildObject3D child = (SkeletalAnimationChildObject3D)obj.getChildAt(j);
                SkeletalAnimationMaterialPlugin plugin = new SkeletalAnimationMaterialPlugin(child.getNumJoints(), child.getMaxBoneWeightsPerVertex());
                child.getMaterial().addPlugin(plugin);
            }
            obj.setAnimationSequences(skelAnims);
            obj.setAnimationSequence(this.mActive);
            if (!this.mAutoPlay) continue;
            obj.play(true);
        }
    }

    private SkeletalAnimationFrame.SkeletonJoint[] lookupSkeleton(LoaderAWD.BlockHeader blockHeader, long addr) throws ParsingException {
        LoaderAWD.BlockHeader lookupHeader = (LoaderAWD.BlockHeader)blockHeader.blockHeaders.get((int)addr);
        if (lookupHeader == null || lookupHeader.parser == null || !(lookupHeader.parser instanceof BlockSkeleton)) {
            throw new ParsingException("Invalid block reference.");
        }
        return ((BlockSkeleton)lookupHeader.parser).mJoints;
    }

    private IAnimationSequence[] lookupAnimationSet(LoaderAWD.BlockHeader blockHeader, long addr) throws ParsingException {
        LoaderAWD.BlockHeader lookupHeader = (LoaderAWD.BlockHeader)blockHeader.blockHeaders.get((int)addr);
        if (lookupHeader == null || lookupHeader.parser == null || !(lookupHeader.parser instanceof BlockAnimationSet)) {
            throw new ParsingException("Invalid block reference.");
        }
        return ((BlockAnimationSet)lookupHeader.parser).mAnimSet;
    }

    private Object3D lookupMesh(LoaderAWD.BlockHeader blockHeader, long addr) throws ParsingException {
        LoaderAWD.BlockHeader lookupHeader = (LoaderAWD.BlockHeader)blockHeader.blockHeaders.get((int)addr);
        if (lookupHeader == null || lookupHeader.parser == null || !(lookupHeader.parser instanceof BlockMeshInstance)) {
            throw new ParsingException("Invalid block reference.");
        }
        return ((BlockMeshInstance)lookupHeader.parser).getBaseObject3D();
    }

    static {
        EXPECTED_PROPS.put(1, (Object)23);
        EXPECTED_PROPS.put(701, (Object)21);
    }
}

