/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader.awd;

import org.rajawali3d.animation.mesh.IAnimationSequence;
import org.rajawali3d.animation.mesh.SkeletalAnimationSequence;
import org.rajawali3d.loader.LoaderAWD;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.loader.awd.ABlockParser;
import org.rajawali3d.loader.awd.BlockMeshPoseAnimation;
import org.rajawali3d.loader.awd.BlockSkeletonAnimation;

public class BlockAnimationSet
extends ABlockParser {
    protected IAnimationSequence[] mAnimSet;
    protected String mLookupName;
    protected int mNumAnims;

    @Override
    public void parseBlock(LoaderAWD.AWDLittleEndianDataInputStream dis, LoaderAWD.BlockHeader blockHeader) throws Exception {
        this.mLookupName = dis.readVarString();
        this.mNumAnims = dis.readUnsignedShort();
        dis.readProperties(null);
        this.mAnimSet = new IAnimationSequence[this.mNumAnims];
        for (int i = 0; i < this.mNumAnims; ++i) {
            long animaddr = dis.readUnsignedInt();
            this.mAnimSet[i] = this.lookup(blockHeader, animaddr);
        }
        dis.readProperties(null);
    }

    private SkeletalAnimationSequence lookup(LoaderAWD.BlockHeader blockHeader, long addr) throws ParsingException {
        LoaderAWD.BlockHeader lookupHeader = (LoaderAWD.BlockHeader)blockHeader.blockHeaders.get((int)addr);
        if (lookupHeader == null || lookupHeader.parser == null || !(lookupHeader.parser instanceof BlockSkeletonAnimation) && !(lookupHeader.parser instanceof BlockMeshPoseAnimation)) {
            throw new ParsingException("Invalid block reference.");
        }
        if (lookupHeader.parser instanceof BlockSkeletonAnimation) {
            return ((BlockSkeletonAnimation)lookupHeader.parser).mSkelAnim;
        }
        return null;
    }
}

