/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader;

import android.content.res.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.rajawali3d.loader.AMeshLoader;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.materials.textures.TextureManager;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.util.LittleEndianDataInputStream;
import org.rajawali3d.util.RajLog;

public class LoaderSTL
extends AMeshLoader {
    public LoaderSTL(Renderer renderer, File file) {
        super(renderer, file);
    }

    public LoaderSTL(Resources resources, TextureManager textureManager, int resourceId) {
        super(resources, textureManager, resourceId);
    }

    public LoaderSTL(Renderer renderer, String fileOnSDCard) {
        super(renderer, fileOnSDCard);
    }

    @Override
    public AMeshLoader parse() throws ParsingException {
        return this.parse(StlType.UNKNOWN);
    }

    public AMeshLoader parse(StlType type) throws ParsingException {
        super.parse();
        try {
            BufferedReader buffer = null;
            LittleEndianDataInputStream dis = null;
            switch (type) {
                case UNKNOWN: {
                    buffer = this.getBufferedReader();
                    boolean isASCII = LoaderSTL.isASCII(buffer);
                    if (isASCII) {
                        this.readASCII(buffer);
                        break;
                    }
                    buffer.close();
                    dis = this.getLittleEndianInputStream();
                    this.readBinary(dis);
                    break;
                }
                case ASCII: {
                    buffer = this.getBufferedReader();
                    this.readASCII(buffer);
                    break;
                }
                case BINARY: {
                    dis = this.getLittleEndianInputStream();
                    this.readBinary(dis);
                }
            }
            if (buffer != null) {
                buffer.close();
            }
            if (dis != null) {
                dis.close();
            }
        }
        catch (FileNotFoundException e) {
            RajLog.e("[" + this.getClass().getCanonicalName() + "] Could not find file.");
            throw new ParsingException("File not found.", e);
        }
        catch (NumberFormatException e) {
            RajLog.e(e.getMessage());
            throw new ParsingException("Unexpected value.", e);
        }
        catch (IOException e) {
            RajLog.e(e.getMessage());
            throw new ParsingException("File reading failed.", e);
        }
        catch (Exception e) {
            RajLog.e(e.getMessage());
            throw new ParsingException("Unexpected exception occured.", e);
        }
        return this;
    }

    private void readASCII(BufferedReader buffer) throws NumberFormatException, IOException {
        int i;
        RajLog.i("StlPaser: Reading ASCII");
        ArrayList<Float> vertices = new ArrayList<Float>();
        ArrayList<Float> normals = new ArrayList<Float>();
        float[] tempNorms = new float[3];
        String line = buffer.readLine();
        while ((line = buffer.readLine()) != null) {
            int prevOffset;
            int nextOffset;
            if (line.contains("facet normal ")) {
                nextOffset = line.lastIndexOf(" ");
                tempNorms[2] = Float.parseFloat(line.substring(nextOffset + 1));
                prevOffset = nextOffset;
                nextOffset = line.lastIndexOf(" ", prevOffset - 1);
                tempNorms[1] = Float.parseFloat(line.substring(nextOffset + 1, prevOffset));
                prevOffset = nextOffset;
                nextOffset = line.lastIndexOf(" ", prevOffset - 1);
                tempNorms[0] = Float.parseFloat(line.substring(nextOffset + 1, prevOffset));
                for (i = 0; i < 3; ++i) {
                    normals.add(Float.valueOf(tempNorms[0]));
                    normals.add(Float.valueOf(tempNorms[1]));
                    normals.add(Float.valueOf(tempNorms[2]));
                }
                continue;
            }
            if (!line.contains("vertex ")) continue;
            int insert = vertices.size();
            nextOffset = line.lastIndexOf(" ");
            vertices.add(Float.valueOf(Float.parseFloat(line.substring(nextOffset + 1))));
            prevOffset = nextOffset;
            nextOffset = line.lastIndexOf(" ", prevOffset - 1);
            vertices.add(insert, Float.valueOf(Float.parseFloat(line.substring(nextOffset + 1, prevOffset))));
            prevOffset = nextOffset;
            nextOffset = line.lastIndexOf(" ", prevOffset - 1);
            vertices.add(insert, Float.valueOf(Float.parseFloat(line.substring(nextOffset + 1, prevOffset))));
        }
        float[] verticesArr = new float[vertices.size()];
        float[] normalsArr = new float[normals.size()];
        for (i = 0; i < verticesArr.length; ++i) {
            verticesArr[i] = ((Float)vertices.get(i)).floatValue();
            normalsArr[i] = ((Float)normals.get(i)).floatValue();
        }
        vertices.clear();
        normals.clear();
        int[] indicesArr = new int[verticesArr.length / 3];
        for (i = 0; i < indicesArr.length; ++i) {
            indicesArr[i] = i;
        }
        this.mRootObject.setData(verticesArr, normalsArr, null, null, indicesArr, false);
    }

    private void readBinary(LittleEndianDataInputStream dis) throws IOException {
        RajLog.i("StlPaser: Reading Binary");
        dis.skip(80);
        int facetCount = dis.readInt();
        float[] verticesArr = new float[facetCount * 9];
        float[] normalsArr = new float[facetCount * 9];
        int[] indicesArr = new int[facetCount * 3];
        float[] tempNorms = new float[3];
        int vertPos = 0;
        int normPos = 0;
        for (int i = 0; i < indicesArr.length; ++i) {
            indicesArr[i] = i;
        }
        while (dis.available() > 0) {
            int j;
            for (j = 0; j < 3; ++j) {
                tempNorms[j] = dis.readFloat();
                if (!Float.isNaN(tempNorms[j]) && !Float.isInfinite(tempNorms[j])) continue;
                RajLog.w("STL contains bad normals of NaN or Infinite!");
                tempNorms[0] = 0.0f;
                tempNorms[1] = 0.0f;
                tempNorms[2] = 0.0f;
                break;
            }
            for (j = 0; j < 3; ++j) {
                normalsArr[normPos++] = tempNorms[0];
                normalsArr[normPos++] = tempNorms[1];
                normalsArr[normPos++] = tempNorms[2];
            }
            for (j = 0; j < 9; ++j) {
                verticesArr[vertPos++] = dis.readFloat();
            }
            dis.skip(2);
        }
        this.mRootObject.setData(verticesArr, normalsArr, null, null, indicesArr, false);
    }

    public static final boolean isASCII(File file) throws IOException, StlParseException {
        if (file.exists()) {
            throw new StlParseException("Passed file does not exist.");
        }
        if (!file.isFile()) {
            throw new StlParseException("This is not a file.");
        }
        BufferedReader buffer = new BufferedReader(new FileReader(file));
        boolean isASCII = LoaderSTL.isASCII(buffer);
        buffer.close();
        return isASCII;
    }

    public static final boolean isASCII(Resources res, int resId) throws IOException, Resources.NotFoundException {
        BufferedReader buffer = new BufferedReader(new InputStreamReader(res.openRawResource(resId)));
        boolean isASCII = LoaderSTL.isASCII(buffer);
        buffer.close();
        return isASCII;
    }

    public static final boolean isASCII(BufferedReader buffer) throws IOException {
        char[] readAhead = new char[300];
        buffer.mark(readAhead.length);
        buffer.read(readAhead, 0, readAhead.length);
        buffer.reset();
        String readAheadString = new String(readAhead);
        return readAheadString.contains("facet normal") && readAheadString.contains("outer loop");
    }

    public static final class StlParseException
    extends ParsingException {
        private static final long serialVersionUID = -5098120548044169618L;

        public StlParseException(String msg) {
            super(msg);
        }
    }

    public static enum StlType {
        UNKNOWN,
        ASCII,
        BINARY;

    }
}

