/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader;

import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import org.rajawali3d.Object3D;
import org.rajawali3d.loader.AMeshLoader;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.methods.DiffuseMethod;
import org.rajawali3d.materials.methods.SpecularMethod;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.Etc1Texture;
import org.rajawali3d.materials.textures.NormalMapTexture;
import org.rajawali3d.materials.textures.SpecularMapTexture;
import org.rajawali3d.materials.textures.Texture;
import org.rajawali3d.materials.textures.TextureManager;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.util.RajLog;

public class LoaderOBJ
extends AMeshLoader {
    protected final String VERTEX = "v";
    protected final String FACE = "f";
    protected final String TEXCOORD = "vt";
    protected final String NORMAL = "vn";
    protected final String OBJECT = "o";
    protected final String GROUP = "g";
    protected final String MATERIAL_LIB = "mtllib";
    protected final String USE_MATERIAL = "usemtl";
    protected final String NEW_MATERIAL = "newmtl";
    protected final String DIFFUSE_COLOR = "Kd";
    protected final String DIFFUSE_TEX_MAP = "map_Kd";
    private boolean mNeedToRenameMtl = true;
    private static Field mParent;

    public LoaderOBJ(Renderer renderer, String fileOnSDCard) {
        super(renderer, fileOnSDCard);
        this.mNeedToRenameMtl = false;
    }

    public LoaderOBJ(Renderer renderer, int resourceId) {
        this(renderer.getContext().getResources(), renderer.getTextureManager(), resourceId);
    }

    public LoaderOBJ(Resources resources, TextureManager textureManager, int resourceId) {
        super(resources, textureManager, resourceId);
    }

    public LoaderOBJ(Renderer renderer, File file) {
        super(renderer, file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LoaderOBJ parse() throws ParsingException {
        int j;
        int numObjects;
        super.parse();
        BufferedReader buffer = null;
        if (this.mFile == null) {
            InputStream fileIn = this.mResources.openRawResource(this.mResourceId);
            buffer = new BufferedReader(new InputStreamReader(fileIn));
        } else {
            try {
                buffer = new BufferedReader(new FileReader(this.mFile));
            }
            catch (FileNotFoundException e) {
                RajLog.e("[" + this.getClass().getCanonicalName() + "] Could not find file.");
                e.printStackTrace();
            }
        }
        ObjIndexData currObjIndexData = new ObjIndexData(new Object3D(LoaderOBJ.generateObjectName()));
        ArrayList<ObjIndexData> objIndices = new ArrayList<ObjIndexData>();
        ArrayList<Float> vertices = new ArrayList<Float>();
        ArrayList<Float> texCoords = new ArrayList<Float>();
        ArrayList<Float> normals = new ArrayList<Float>();
        MaterialLib matLib = new MaterialLib();
        String currentMaterialName = null;
        boolean currentObjHasFaces = false;
        Object3D currentGroup = this.mRootObject;
        this.mRootObject.setName("default");
        HashMap<String, Object3D> groups = new HashMap<String, Object3D>();
        try {
            block8: while (true) {
                Object3D previousGroup;
                int numGroups;
                StringTokenizer parts;
                block53: {
                    boolean hasn;
                    boolean hasuv;
                    StringTokenizer subParts;
                    int[] quadnids;
                    int[] quadtids;
                    int[] quadvids;
                    boolean isQuad;
                    int numTokens;
                    block56: {
                        block55: {
                            String line;
                            if ((line = buffer.readLine()) == null) break block55;
                            if (line.length() == 0 || line.charAt(0) == '#' || (numTokens = (parts = new StringTokenizer(line, " ")).countTokens()) == 0) continue;
                            String type = parts.nextToken();
                            if (type.equals("v")) {
                                vertices.add(Float.valueOf(Float.parseFloat(parts.nextToken())));
                                vertices.add(Float.valueOf(Float.parseFloat(parts.nextToken())));
                                vertices.add(Float.valueOf(Float.parseFloat(parts.nextToken())));
                                continue;
                            }
                            if (type.equals("f")) {
                                boolean emptyVt;
                                currentObjHasFaces = true;
                                isQuad = numTokens == 5;
                                quadvids = new int[4];
                                quadtids = new int[4];
                                quadnids = new int[4];
                                boolean bl = emptyVt = line.indexOf("//") > -1;
                                if (emptyVt) {
                                    line = line.replace("//", "/");
                                }
                                parts = new StringTokenizer(line);
                                parts.nextToken();
                                subParts = new StringTokenizer(parts.nextToken(), "/");
                                int partLength = subParts.countTokens();
                                hasuv = partLength >= 2 && !emptyVt;
                                hasn = partLength == 3 || partLength == 2 && emptyVt;
                                break block56;
                            } else {
                                if (type.equals("vt")) {
                                    texCoords.add(Float.valueOf(Float.parseFloat(parts.nextToken())));
                                    texCoords.add(Float.valueOf(1.0f - Float.parseFloat(parts.nextToken())));
                                    continue;
                                }
                                if (type.equals("vn")) {
                                    normals.add(Float.valueOf(Float.parseFloat(parts.nextToken())));
                                    normals.add(Float.valueOf(Float.parseFloat(parts.nextToken())));
                                    normals.add(Float.valueOf(Float.parseFloat(parts.nextToken())));
                                    continue;
                                }
                                if (type.equals("g")) {
                                    numGroups = parts.countTokens();
                                    previousGroup = null;
                                    break block53;
                                } else {
                                    if (type.equals("o")) {
                                        String objName;
                                        String string = objName = parts.hasMoreTokens() ? parts.nextToken() : LoaderOBJ.generateObjectName();
                                        if (currentObjHasFaces) {
                                            objIndices.add(currObjIndexData);
                                            currObjIndexData = new ObjIndexData(new Object3D(currObjIndexData.targetObj.getName()));
                                            currObjIndexData.materialName = currentMaterialName;
                                            LoaderOBJ.addChildSetParent(currentGroup, currObjIndexData.targetObj);
                                            RajLog.i("Parsing object: " + currObjIndexData.targetObj.getName());
                                            currentObjHasFaces = false;
                                        }
                                        currObjIndexData.targetObj.setName(objName);
                                        continue;
                                    }
                                    if (type.equals("mtllib")) {
                                        if (!parts.hasMoreTokens()) continue;
                                        String materialLibPath = this.mNeedToRenameMtl ? parts.nextToken().replace(".", "_") : parts.nextToken();
                                        RajLog.d("Found Material Lib: " + materialLibPath);
                                        if (this.mFile != null) {
                                            matLib.parse(materialLibPath, null, null);
                                            continue;
                                        }
                                        matLib.parse(materialLibPath, this.mResources.getResourceTypeName(this.mResourceId), this.mResources.getResourcePackageName(this.mResourceId));
                                        continue;
                                    }
                                    if (!type.equals("usemtl")) continue;
                                    currentMaterialName = parts.nextToken();
                                    if (currentObjHasFaces) {
                                        objIndices.add(currObjIndexData);
                                        currObjIndexData = new ObjIndexData(new Object3D(LoaderOBJ.generateObjectName()));
                                        RajLog.i("Parsing object: " + currObjIndexData.targetObj.getName());
                                        LoaderOBJ.addChildSetParent(currentGroup, currObjIndexData.targetObj);
                                        currentObjHasFaces = false;
                                    }
                                    currObjIndexData.materialName = currentMaterialName;
                                    continue;
                                }
                            }
                        }
                        buffer.close();
                        if (currentObjHasFaces) {
                            RajLog.i("Parsing object: " + currObjIndexData.targetObj.getName());
                            objIndices.add(currObjIndexData);
                        }
                        numObjects = objIndices.size();
                        j = 0;
                        break;
                    }
                    for (int i = 1; i < numTokens; ++i) {
                        int idx;
                        if (i > 1) {
                            subParts = new StringTokenizer(parts.nextToken(), "/");
                        }
                        idx = (idx = Integer.parseInt(subParts.nextToken())) < 0 ? vertices.size() / 3 + idx : --idx;
                        if (!isQuad) {
                            currObjIndexData.vertexIndices.add(idx);
                        } else {
                            quadvids[i - 1] = idx;
                        }
                        if (hasuv) {
                            idx = Integer.parseInt(subParts.nextToken());
                            idx = idx < 0 ? texCoords.size() / 2 + idx : --idx;
                            if (!isQuad) {
                                currObjIndexData.texCoordIndices.add(idx);
                            } else {
                                quadtids[i - 1] = idx;
                            }
                        }
                        if (!hasn) continue;
                        idx = Integer.parseInt(subParts.nextToken());
                        idx = idx < 0 ? normals.size() / 3 + idx : --idx;
                        if (!isQuad) {
                            currObjIndexData.normalIndices.add(idx);
                            continue;
                        }
                        quadnids[i - 1] = idx;
                    }
                    if (!isQuad) continue;
                    int[] indices = new int[]{0, 1, 2, 0, 2, 3};
                    int i = 0;
                    while (true) {
                        if (i >= 6) continue block8;
                        int index = indices[i];
                        currObjIndexData.vertexIndices.add(quadvids[index]);
                        currObjIndexData.texCoordIndices.add(quadtids[index]);
                        currObjIndexData.normalIndices.add(quadnids[index]);
                        ++i;
                    }
                }
                for (int i = 0; i < numGroups; ++i) {
                    String groupName = parts.nextToken();
                    if (!groups.containsKey(groupName)) {
                        groups.put(groupName, new Object3D(groupName));
                    }
                    Object3D group = (Object3D)groups.get(groupName);
                    if (previousGroup != null) {
                        LoaderOBJ.addChildSetParent(group, previousGroup);
                    } else {
                        currentGroup = group;
                    }
                    previousGroup = group;
                }
                RajLog.i("Parsing group: " + currentGroup.getName());
                if (currentObjHasFaces) {
                    objIndices.add(currObjIndexData);
                    currObjIndexData = new ObjIndexData(new Object3D(LoaderOBJ.generateObjectName()));
                    RajLog.i("Parsing object: " + currObjIndexData.targetObj.getName());
                    currObjIndexData.materialName = currentMaterialName;
                    currentObjHasFaces = false;
                }
                LoaderOBJ.addChildSetParent(currentGroup, currObjIndexData.targetObj);
            }
        }
        catch (IOException e) {
            throw new ParsingException(e);
        }
        while (true) {
            int ti;
            int i;
            int[] aIndices;
            float[] aColors;
            float[] aNormals;
            float[] aTexCoords;
            float[] aVertices;
            ObjIndexData oid;
            if (j < numObjects) {
                oid = (ObjIndexData)objIndices.get(j);
                aVertices = new float[oid.vertexIndices.size() * 3];
                aTexCoords = new float[oid.texCoordIndices.size() * 2];
                aNormals = new float[oid.normalIndices.size() * 3];
                aColors = new float[oid.colorIndices.size() * 4];
                aIndices = new int[oid.vertexIndices.size()];
            } else {
                for (Object3D group : groups.values()) {
                    if (group.getParent() != null) continue;
                    LoaderOBJ.addChildSetParent(this.mRootObject, group);
                }
                if (this.mRootObject.getNumChildren() == 1 && !this.mRootObject.getChildAt(0).isContainer()) {
                    this.mRootObject = this.mRootObject.getChildAt(0);
                }
                int i2 = 0;
                while (true) {
                    if (i2 >= this.mRootObject.getNumChildren()) {
                        return this;
                    }
                    this.mergeGroupsAsObjects(this.mRootObject.getChildAt(i2));
                    ++i2;
                }
            }
            for (i = 0; i < oid.vertexIndices.size(); ++i) {
                int faceIndex = oid.vertexIndices.get(i) * 3;
                int vertexIndex = i * 3;
                try {
                    aVertices[vertexIndex] = ((Float)vertices.get(faceIndex)).floatValue();
                    aVertices[vertexIndex + 1] = ((Float)vertices.get(faceIndex + 1)).floatValue();
                    aVertices[vertexIndex + 2] = ((Float)vertices.get(faceIndex + 2)).floatValue();
                    aIndices[i] = i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    RajLog.d("Obj array index out of bounds: " + vertexIndex + ", " + faceIndex);
                }
            }
            if (texCoords != null && texCoords.size() > 0) {
                for (i = 0; i < oid.texCoordIndices.size(); ++i) {
                    int texCoordIndex = oid.texCoordIndices.get(i) * 2;
                    ti = i * 2;
                    aTexCoords[ti] = ((Float)texCoords.get(texCoordIndex)).floatValue();
                    aTexCoords[ti + 1] = ((Float)texCoords.get(texCoordIndex + 1)).floatValue();
                }
            }
            for (i = 0; i < oid.colorIndices.size(); ++i) {
                int colorIndex = oid.colorIndices.get(i) * 4;
                ti = i * 4;
                aTexCoords[ti] = ((Float)texCoords.get(colorIndex)).floatValue();
                aTexCoords[ti + 1] = ((Float)texCoords.get(colorIndex + 1)).floatValue();
                aTexCoords[ti + 2] = ((Float)texCoords.get(colorIndex + 2)).floatValue();
                aTexCoords[ti + 3] = ((Float)texCoords.get(colorIndex + 3)).floatValue();
            }
            for (i = 0; i < oid.normalIndices.size(); ++i) {
                int normalIndex = oid.normalIndices.get(i) * 3;
                int ni = i * 3;
                if (normals.size() == 0) {
                    RajLog.e("[" + this.getClass().getName() + "] There are no normals specified for this model. Please re-export with normals.");
                    throw new ParsingException("[" + this.getClass().getName() + "] There are no normals specified for this model. Please re-export with normals.");
                }
                aNormals[ni] = ((Float)normals.get(normalIndex)).floatValue();
                aNormals[ni + 1] = ((Float)normals.get(normalIndex + 1)).floatValue();
                aNormals[ni + 2] = ((Float)normals.get(normalIndex + 2)).floatValue();
            }
            oid.targetObj.setData(aVertices, aNormals, aTexCoords, aColors, aIndices, false);
            try {
                matLib.setMaterial(oid.targetObj, oid.materialName);
            }
            catch (ATexture.TextureException tme) {
                throw new ParsingException(tme);
            }
            if (oid.targetObj.getParent() == null) {
                LoaderOBJ.addChildSetParent(this.mRootObject, oid.targetObj);
            }
            ++j;
        }
    }

    private void mergeGroupsAsObjects(Object3D object) {
        if (object.isContainer() && object.getNumChildren() == 1 && object.getChildAt(0).getName().startsWith("Object")) {
            Object3D child = object.getChildAt(0);
            object.removeChild(child);
            child.setName(object.getName());
            LoaderOBJ.addChildSetParent(object.getParent(), child);
            object.getParent().removeChild(object);
            object = child;
        }
        for (int i = 0; i < object.getNumChildren(); ++i) {
            this.mergeGroupsAsObjects(object.getChildAt(i));
        }
    }

    private static String generateObjectName() {
        return "Object" + (int)(Math.random() * 10000.0);
    }

    private void buildObjectGraph(Object3D parent, StringBuffer sb, String prefix) {
        sb.append(prefix).append("-->").append((parent.isContainer() ? "GROUP " : "") + parent.getName()).append('\n');
        for (int i = 0; i < parent.getNumChildren(); ++i) {
            this.buildObjectGraph(parent.getChildAt(i), sb, prefix + "\t");
        }
    }

    private static void addChildSetParent(Object3D parent, Object3D object) {
        try {
            parent.addChild(object);
            mParent.set(object, parent);
        }
        catch (Exception e) {
            RajLog.e("Reflection error Object3D.mParent");
        }
    }

    public String toString() {
        if (this.mRootObject == null) {
            return "Object not parsed";
        }
        StringBuffer sb = new StringBuffer();
        this.buildObjectGraph(this.mRootObject, sb, "");
        return sb.toString();
    }

    static {
        try {
            mParent = Object3D.class.getDeclaredField("mParent");
            mParent.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            RajLog.e("Reflection error Object3D.mParent");
        }
    }

    protected class MaterialLib {
        private final String MATERIAL_NAME = "newmtl";
        private final String AMBIENT_COLOR = "Ka";
        private final String DIFFUSE_COLOR = "Kd";
        private final String SPECULAR_COLOR = "Ks";
        private final String SPECULAR_COEFFICIENT = "Ns";
        private final String ALPHA_1 = "d";
        private final String ALPHA_2 = "Tr";
        private final String AMBIENT_TEXTURE = "map_Ka";
        private final String DIFFUSE_TEXTURE = "map_Kd";
        private final String SPECULAR_COLOR_TEXTURE = "map_Ks";
        private final String SPECULAR_HIGHLIGHT_TEXTURE = "map_Ns";
        private final String ALPHA_TEXTURE_1 = "map_d";
        private final String ALPHA_TEXTURE_2 = "map_Tr";
        private final String BUMP_TEXTURE = "map_Bump";
        private Stack<AMeshLoader.MaterialDef> mMaterials = new Stack();
        private String mResourcePackage;

        public void parse(String materialLibPath, String resourceType, String resourcePackage) {
            BufferedReader buffer = null;
            if (LoaderOBJ.this.mFile == null) {
                this.mResourcePackage = resourcePackage;
                int identifier = LoaderOBJ.this.mResources.getIdentifier(materialLibPath, resourceType, resourcePackage);
                try {
                    InputStream fileIn = LoaderOBJ.this.mResources.openRawResource(identifier);
                    buffer = new BufferedReader(new InputStreamReader(fileIn));
                }
                catch (Exception e) {
                    RajLog.e("[" + this.getClass().getCanonicalName() + "] Could not find material library file (.mtl).");
                    return;
                }
            }
            try {
                File materialFile = new File(LoaderOBJ.this.mFile.getParent() + File.separatorChar + materialLibPath);
                buffer = new BufferedReader(new FileReader(materialFile));
            }
            catch (Exception e) {
                RajLog.e("[" + this.getClass().getCanonicalName() + "] Could not find file.");
                e.printStackTrace();
                return;
            }
            AMeshLoader.MaterialDef matDef = null;
            try {
                String line;
                while ((line = buffer.readLine()) != null) {
                    StringTokenizer parts;
                    int numTokens;
                    if (line.length() == 0 || line.charAt(0) == '#' || (numTokens = (parts = new StringTokenizer(line, " ")).countTokens()) == 0) continue;
                    String type = parts.nextToken();
                    type = type.replaceAll("\\t", "");
                    if ((type = type.replaceAll(" ", "")).equals("newmtl")) {
                        if (matDef != null) {
                            this.mMaterials.add(matDef);
                        }
                        matDef = new AMeshLoader.MaterialDef();
                        matDef.name = parts.hasMoreTokens() ? parts.nextToken() : "";
                        RajLog.d("Parsing material: " + matDef.name);
                        continue;
                    }
                    if (type.equals("Kd")) {
                        matDef.diffuseColor = this.getColorFromParts(parts);
                        continue;
                    }
                    if (type.equals("Ka")) {
                        matDef.ambientColor = this.getColorFromParts(parts);
                        continue;
                    }
                    if (type.equals("Ks")) {
                        matDef.specularColor = this.getColorFromParts(parts);
                        continue;
                    }
                    if (type.equals("Ns")) {
                        matDef.specularCoefficient = Float.parseFloat(parts.nextToken());
                        continue;
                    }
                    if (type.equals("d") || type.equals("Tr")) {
                        matDef.alpha = Float.parseFloat(parts.nextToken());
                        continue;
                    }
                    if (type.equals("map_Ka")) {
                        matDef.ambientTexture = parts.nextToken();
                        continue;
                    }
                    if (type.equals("map_Kd")) {
                        matDef.diffuseTexture = parts.nextToken();
                        continue;
                    }
                    if (type.equals("map_Ks")) {
                        matDef.specularColorTexture = parts.nextToken();
                        continue;
                    }
                    if (type.equals("map_Ns")) {
                        matDef.specularHighlightTexture = parts.nextToken();
                        continue;
                    }
                    if (type.equals("map_d") || type.equals("map_Tr")) {
                        matDef.alphaTexture = parts.nextToken();
                        continue;
                    }
                    if (!type.equals("map_Bump")) continue;
                    matDef.bumpTexture = parts.nextToken();
                }
                if (matDef != null) {
                    this.mMaterials.add(matDef);
                }
                buffer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMaterial(Object3D object, String materialName) throws ATexture.TextureException {
            if (materialName == null) {
                RajLog.i(object.getName() + " has no material definition.");
                return;
            }
            AMeshLoader.MaterialDef matDef = null;
            for (int i = 0; i < this.mMaterials.size(); ++i) {
                if (!((AMeshLoader.MaterialDef)this.mMaterials.get((int)i)).name.equals(materialName)) continue;
                matDef = (AMeshLoader.MaterialDef)this.mMaterials.get(i);
                break;
            }
            boolean hasTexture = matDef != null && matDef.diffuseTexture != null;
            boolean hasBump = matDef != null && matDef.bumpTexture != null;
            boolean hasSpecularTexture = matDef != null && matDef.specularColorTexture != null;
            boolean hasSpecular = matDef != null && matDef.specularColor > -16777216 && matDef.specularCoefficient > 0.0f;
            Material mat = new Material();
            mat.enableLighting(true);
            mat.setDiffuseMethod(new DiffuseMethod.Lambert());
            if (matDef != null) {
                int alpha = (int)(matDef.alpha * 255.0f);
                mat.setColor(alpha << 24 & 0xFF000000 | matDef.diffuseColor & 0xFFFFFF);
            } else {
                mat.setColor((int)(Math.random() * 1.6777215E7));
            }
            if (hasSpecular || hasSpecularTexture) {
                SpecularMethod.Phong method = new SpecularMethod.Phong();
                method.setSpecularColor(matDef.specularColor);
                method.setShininess(matDef.specularCoefficient);
            }
            if (hasTexture) {
                if (LoaderOBJ.this.mFile == null) {
                    String fileNameWithoutExtension = LoaderOBJ.this.getFileNameWithoutExtension(matDef.diffuseTexture);
                    int id = LoaderOBJ.this.mResources.getIdentifier(fileNameWithoutExtension, "drawable", this.mResourcePackage);
                    int etc1Id = LoaderOBJ.this.mResources.getIdentifier(fileNameWithoutExtension, "raw", this.mResourcePackage);
                    if (etc1Id != 0) {
                        mat.addTexture(new Texture(object.getName() + fileNameWithoutExtension, new Etc1Texture(object.getName() + etc1Id, etc1Id, id != 0 ? BitmapFactory.decodeResource((Resources)LoaderOBJ.this.mResources, (int)id) : null)));
                    } else if (id != 0) {
                        mat.addTexture(new Texture(object.getName() + fileNameWithoutExtension, id));
                    }
                } else {
                    String filePath = LoaderOBJ.this.mFile.getParent() + File.separatorChar + LoaderOBJ.this.getOnlyFileName(matDef.diffuseTexture);
                    if (filePath.endsWith(".pkm")) {
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(filePath);
                            mat.addTexture(new Texture(LoaderOBJ.this.getFileNameWithoutExtension(matDef.diffuseTexture), new Etc1Texture(LoaderOBJ.this.getFileNameWithoutExtension(matDef.diffuseTexture) + "etc1", fis, null)));
                        }
                        catch (FileNotFoundException e) {
                            RajLog.e("File decode error");
                        }
                        finally {
                            try {
                                fis.close();
                            }
                            catch (IOException e) {}
                        }
                    } else {
                        mat.addTexture(new Texture(LoaderOBJ.this.getFileNameWithoutExtension(matDef.diffuseTexture), BitmapFactory.decodeFile((String)filePath)));
                    }
                }
                mat.setColorInfluence(0.0f);
            }
            if (hasBump) {
                if (LoaderOBJ.this.mFile == null) {
                    int identifier = LoaderOBJ.this.mResources.getIdentifier(LoaderOBJ.this.getFileNameWithoutExtension(matDef.bumpTexture), "drawable", this.mResourcePackage);
                    mat.addTexture(new NormalMapTexture(object.getName() + identifier, identifier));
                } else {
                    String filePath = LoaderOBJ.this.mFile.getParent() + File.separatorChar + LoaderOBJ.this.getOnlyFileName(matDef.bumpTexture);
                    mat.addTexture(new NormalMapTexture(LoaderOBJ.this.getOnlyFileName(matDef.bumpTexture), BitmapFactory.decodeFile((String)filePath)));
                }
            }
            if (hasSpecularTexture) {
                if (LoaderOBJ.this.mFile == null) {
                    int identifier = LoaderOBJ.this.mResources.getIdentifier(LoaderOBJ.this.getFileNameWithoutExtension(matDef.specularColorTexture), "drawable", this.mResourcePackage);
                    mat.addTexture(new SpecularMapTexture(object.getName() + identifier, identifier));
                } else {
                    String filePath = LoaderOBJ.this.mFile.getParent() + File.separatorChar + LoaderOBJ.this.getOnlyFileName(matDef.specularColorTexture);
                    mat.addTexture(new SpecularMapTexture(LoaderOBJ.this.getOnlyFileName(matDef.specularColorTexture), BitmapFactory.decodeFile((String)filePath)));
                }
            }
            object.setMaterial(mat);
            if (matDef != null && matDef.alpha < 1.0f) {
                object.setTransparent(true);
            }
        }

        private int getColorFromParts(StringTokenizer parts) {
            int r = (int)(Float.parseFloat(parts.nextToken()) * 255.0f);
            int g = (int)(Float.parseFloat(parts.nextToken()) * 255.0f);
            int b = (int)(Float.parseFloat(parts.nextToken()) * 255.0f);
            return Color.rgb((int)r, (int)g, (int)b);
        }
    }

    protected class ObjIndexData {
        public Object3D targetObj;
        public ArrayList<Integer> vertexIndices;
        public ArrayList<Integer> texCoordIndices;
        public ArrayList<Integer> colorIndices;
        public ArrayList<Integer> normalIndices;
        public String materialName;

        public ObjIndexData(Object3D targetObj) {
            this.targetObj = targetObj;
            this.vertexIndices = new ArrayList();
            this.texCoordIndices = new ArrayList();
            this.colorIndices = new ArrayList();
            this.normalIndices = new ArrayList();
        }
    }
}

