/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Stack;
import org.rajawali3d.animation.mesh.AAnimationObject3D;
import org.rajawali3d.animation.mesh.IAnimationFrame;
import org.rajawali3d.animation.mesh.VertexAnimationFrame;
import org.rajawali3d.animation.mesh.VertexAnimationObject3D;
import org.rajawali3d.loader.AMeshLoader;
import org.rajawali3d.loader.IAnimatedMeshLoader;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.methods.DiffuseMethod;
import org.rajawali3d.materials.plugins.VertexAnimationMaterialPlugin;
import org.rajawali3d.materials.textures.Texture;
import org.rajawali3d.materials.textures.TextureManager;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.util.LittleEndianDataInputStream;
import org.rajawali3d.util.RajLog;

public class LoaderMD2
extends AMeshLoader
implements IAnimatedMeshLoader {
    private MD2Header mHeader;
    private String mCurrentTextureName;
    private Stack<IAnimationFrame> mFrames;
    private Bitmap mTexture;
    private VertexAnimationObject3D mObject;
    private float[][] mFrameVerts;
    private int[] mIndices;
    private float[] mTextureCoords;

    public LoaderMD2(Renderer renderer, String fileOnSDCard) {
        super(renderer, fileOnSDCard);
    }

    public LoaderMD2(Renderer renderer, int resourceId) {
        this(renderer.getContext().getResources(), renderer.getTextureManager(), resourceId);
    }

    public LoaderMD2(Resources resources, TextureManager textureManager, int resourceId) {
        super(resources, textureManager, resourceId);
    }

    public LoaderMD2(Renderer renderer, File file) {
        super(renderer, file);
    }

    @Override
    public AAnimationObject3D getParsedAnimationObject() {
        return (AAnimationObject3D)this.mRootObject;
    }

    @Override
    public LoaderMD2 parse() throws ParsingException {
        super.parse();
        BufferedInputStream stream = null;
        if (this.mFile == null) {
            InputStream fileIn = this.mResources.openRawResource(this.mResourceId);
            stream = new BufferedInputStream(fileIn);
        } else {
            try {
                stream = new BufferedInputStream(new FileInputStream(this.mFile));
            }
            catch (FileNotFoundException e) {
                RajLog.e("[" + this.getClass().getCanonicalName() + "] Could not find file.");
                throw new ParsingException(e);
            }
        }
        this.mObject = new VertexAnimationObject3D();
        this.mObject.setFps(10);
        this.mHeader = new MD2Header();
        try {
            this.mHeader.parse(stream);
            this.mFrames = new Stack();
            for (int i = 0; i < this.mHeader.numFrames; ++i) {
                this.mFrames.add(new VertexAnimationFrame());
            }
            byte[] bytes = new byte[this.mHeader.offsetEnd - 68];
            stream.read(bytes);
            this.getMaterials(stream, bytes);
            float[] texCoords = this.getTexCoords(stream, bytes);
            this.getFrames(stream, bytes);
            this.getTriangles(stream, bytes, texCoords);
            this.mObject.setFrames(this.mFrames);
            IAnimationFrame firstFrame = (IAnimationFrame)this.mFrames.get(0);
            Material material = new Material();
            material.enableLighting(true);
            material.setDiffuseMethod(new DiffuseMethod.Lambert());
            material.addPlugin(new VertexAnimationMaterialPlugin());
            this.mObject.getGeometry().copyFromGeometry3D(firstFrame.getGeometry());
            this.mObject.setData(firstFrame.getGeometry().getVertexBufferInfo(), firstFrame.getGeometry().getNormalBufferInfo(), this.mTextureCoords, null, this.mIndices, false);
            this.mObject.setMaterial(material);
            this.mObject.setColor(-1);
            if (this.mTexture != null) {
                material.addTexture(new Texture(this.mCurrentTextureName, this.mTexture));
                material.setColorInfluence(0.0f);
            }
            stream.close();
        }
        catch (Exception e) {
            throw new ParsingException(e);
        }
        this.mObject.isContainer(false);
        this.mRootObject = this.mObject;
        return this;
    }

    private void getMaterials(BufferedInputStream stream, byte[] bytes) throws IOException {
        ByteArrayInputStream ba = new ByteArrayInputStream(bytes, this.mHeader.offsetSkins - 68, bytes.length - this.mHeader.offsetSkins);
        LittleEndianDataInputStream is = new LittleEndianDataInputStream(ba);
        for (int i = 0; i < this.mHeader.numSkins; ++i) {
            String skinPath = is.readString(64);
            skinPath = skinPath.substring(skinPath.lastIndexOf("/") + 1, skinPath.length());
            StringBuffer textureName = new StringBuffer(skinPath.toLowerCase(Locale.ENGLISH));
            this.mCurrentTextureName = textureName.toString().trim();
            if (this.mFile != null) continue;
            int dotIndex = textureName.lastIndexOf(".");
            if (dotIndex > -1) {
                textureName = new StringBuffer(textureName.substring(0, dotIndex));
            }
            this.mCurrentTextureName = textureName.toString();
        }
        is.close();
        if (this.mFile == null) {
            if (this.mCurrentTextureName == null) {
                RajLog.e("[" + this.getClass().getCanonicalName() + "] No texture name was specified. No material will be created.");
                return;
            }
            int identifier = this.mResources.getIdentifier(this.mCurrentTextureName, "drawable", this.mResources.getResourcePackageName(this.mResourceId));
            this.mTexture = BitmapFactory.decodeResource((Resources)this.mResources, (int)identifier);
        } else {
            try {
                String filePath = this.mFile.getParent() + File.separatorChar + this.mCurrentTextureName;
                this.mTexture = BitmapFactory.decodeFile((String)filePath);
            }
            catch (Exception e) {
                RajLog.e("[" + this.getClass().getCanonicalName() + "] Could not find file " + this.mCurrentTextureName);
                e.printStackTrace();
                return;
            }
        }
    }

    private float[] getTexCoords(BufferedInputStream stream, byte[] bytes) throws IOException {
        ByteArrayInputStream ba = new ByteArrayInputStream(bytes, this.mHeader.offsetTexCoord - 68, bytes.length - this.mHeader.offsetTexCoord);
        LittleEndianDataInputStream is = new LittleEndianDataInputStream(ba);
        float[] coords = new float[this.mHeader.numTexCoord * 2];
        int buffIndex = 0;
        for (int i = 0; i < this.mHeader.numTexCoord; ++i) {
            buffIndex = i * 2;
            coords[buffIndex] = (float)is.readShort() / (float)this.mHeader.skinWidth;
            coords[buffIndex + 1] = (float)is.readShort() / (float)this.mHeader.skinHeight;
        }
        is.close();
        return coords;
    }

    private void getFrames(BufferedInputStream stream, byte[] bytes) throws IOException {
        ByteArrayInputStream ba = new ByteArrayInputStream(bytes, this.mHeader.offsetFrames - 68, bytes.length - this.mHeader.offsetFrames);
        LittleEndianDataInputStream is = new LittleEndianDataInputStream(ba);
        this.mFrameVerts = new float[this.mHeader.numFrames][];
        for (int i = 0; i < this.mHeader.numFrames; ++i) {
            float scaleX = is.readFloat();
            float scaleY = is.readFloat();
            float scaleZ = is.readFloat();
            float translateX = is.readFloat();
            float translateY = is.readFloat();
            float translateZ = is.readFloat();
            String name = is.readString(16);
            IAnimationFrame frame = (IAnimationFrame)this.mFrames.get(i);
            name = name.indexOf("_") > 0 ? name.subSequence(0, name.lastIndexOf("_")).toString() : name.trim().replaceAll("[0-9]{1,2}$", "");
            frame.setName(name);
            float[] vertices = new float[this.mHeader.numVerts * 3];
            int index = 0;
            Vector3 v = new Vector3();
            for (int j = 0; j < this.mHeader.numVerts; ++j) {
                v.x = scaleX * (float)is.readUnsignedByte() + translateX;
                v.y = scaleY * (float)is.readUnsignedByte() + translateY;
                v.z = scaleZ * (float)is.readUnsignedByte() + translateZ;
                v.rotateZ(-90.0);
                v.rotateX(-90.0);
                vertices[index + 0] = (float)v.x;
                vertices[index + 1] = (float)v.y;
                vertices[index + 2] = (float)v.z;
                index += 3;
                is.readUnsignedByte();
            }
            this.mFrameVerts[i] = vertices;
        }
        is.close();
    }

    private void getTriangles(BufferedInputStream stream, byte[] bytes, float[] texCoords) throws IOException {
        int i;
        int j;
        ByteArrayInputStream ba = new ByteArrayInputStream(bytes, this.mHeader.offsetTriangles - 68, bytes.length - this.mHeader.offsetTriangles);
        LittleEndianDataInputStream is = new LittleEndianDataInputStream(ba);
        int[] indices = new int[this.mHeader.numTriangles * 3];
        int[] uvIndices = new int[this.mHeader.numTriangles * 3];
        int index = 0;
        int uvIndex = 0;
        for (int i2 = 0; i2 < this.mHeader.numTriangles; ++i2) {
            indices[index + 2] = is.readShort();
            indices[index + 1] = is.readShort();
            indices[index] = is.readShort();
            index += 3;
            uvIndices[uvIndex + 2] = is.readShort();
            uvIndices[uvIndex + 1] = is.readShort();
            uvIndices[uvIndex] = is.readShort();
            uvIndex += 3;
        }
        is.close();
        short newVertexIndex = (short)this.mHeader.numVerts;
        int numIndices = indices.length;
        Stack<VertexIndices> changedIndices = new Stack<VertexIndices>();
        for (int i3 = 0; i3 < numIndices; ++i3) {
            for (j = i3 + 1; j < numIndices; ++j) {
                if (indices[i3] != indices[j] || uvIndices[i3] == uvIndices[j]) continue;
                changedIndices.add(new VertexIndices((short)j, indices[j], newVertexIndex));
                for (int k = j + 1; k < numIndices; ++k) {
                    if (indices[j] != indices[k] || uvIndices[j] != uvIndices[k]) continue;
                    indices[k] = newVertexIndex;
                }
                indices[j] = newVertexIndex;
                newVertexIndex = (short)(newVertexIndex + 1);
            }
        }
        int[] cIndices = new int[changedIndices.size()];
        for (j = 0; j < changedIndices.size(); ++j) {
            cIndices[j] = ((VertexIndices)changedIndices.get((int)j)).oldVertexIndex;
        }
        float[] reorderedTexCoords = new float[(this.mHeader.numVerts + changedIndices.size()) * 2];
        for (i = 0; i < indices.length; ++i) {
            int fid = indices[i];
            int uvid = uvIndices[i];
            reorderedTexCoords[fid * 2] = texCoords[uvid * 2];
            reorderedTexCoords[fid * 2 + 1] = texCoords[uvid * 2 + 1];
        }
        this.mTextureCoords = reorderedTexCoords;
        this.mIndices = indices;
        for (i = 0; i < this.mHeader.numFrames; ++i) {
            VertexAnimationFrame frame = (VertexAnimationFrame)this.mFrames.get(i);
            this.duplicateAndAppendVertices(i, cIndices);
            frame.getGeometry().setVertices(this.mFrameVerts[i]);
            frame.getGeometry().setNormals(frame.calculateNormals(indices));
            frame.getGeometry().createVertexAndNormalBuffersOnly();
        }
    }

    public void duplicateAndAppendVertices(int frameNumber, int[] indices) {
        float[] frameVerts = this.mFrameVerts[frameNumber];
        int offset = frameVerts.length;
        float[] newVerts = new float[offset + indices.length * 3];
        for (int i = 0; i < indices.length; ++i) {
            int vi = offset + i * 3;
            int ovi = indices[i] * 3;
            newVerts[vi] = frameVerts[ovi];
            newVerts[vi + 1] = frameVerts[ovi + 1];
            newVerts[vi + 2] = frameVerts[ovi + 2];
        }
        System.arraycopy(frameVerts, 0, newVerts, 0, offset);
        this.mFrameVerts[frameNumber] = newVerts;
    }

    private class MD2Header {
        public int id;
        public int version;
        public int skinWidth;
        public int skinHeight;
        public int frameSize;
        public int numSkins;
        public int numVerts;
        public int numTexCoord;
        public int numTriangles;
        public int numGLCommands;
        public int numFrames;
        public int offsetSkins;
        public int offsetTexCoord;
        public int offsetTriangles;
        public int offsetFrames;
        public int offsetGLCommands;
        public int offsetEnd;

        private MD2Header() {
        }

        public void parse(InputStream stream) throws Exception {
            this.id = LoaderMD2.this.readInt(stream);
            this.version = LoaderMD2.this.readInt(stream);
            if (this.id != 844121161 || this.version != 8) {
                throw new Exception("This is not a valid MD2 file.");
            }
            this.skinWidth = LoaderMD2.this.readInt(stream);
            this.skinHeight = LoaderMD2.this.readInt(stream);
            this.frameSize = LoaderMD2.this.readInt(stream);
            this.numSkins = LoaderMD2.this.readInt(stream);
            this.numVerts = LoaderMD2.this.readInt(stream);
            this.numTexCoord = LoaderMD2.this.readInt(stream);
            this.numTriangles = LoaderMD2.this.readInt(stream);
            this.numGLCommands = LoaderMD2.this.readInt(stream);
            this.numFrames = LoaderMD2.this.readInt(stream);
            this.offsetSkins = LoaderMD2.this.readInt(stream);
            this.offsetTexCoord = LoaderMD2.this.readInt(stream);
            this.offsetTriangles = LoaderMD2.this.readInt(stream);
            this.offsetFrames = LoaderMD2.this.readInt(stream);
            this.offsetGLCommands = LoaderMD2.this.readInt(stream);
            this.offsetEnd = LoaderMD2.this.readInt(stream);
        }
    }

    private class VertexIndices {
        public int index;
        public int oldVertexIndex;
        public int newVertexIndex;

        public VertexIndices(int index, int oldVertexIndex, int newVertexIndex) {
            this.index = index;
            this.oldVertexIndex = oldVertexIndex;
            this.newVertexIndex = newVertexIndex;
        }
    }
}

