/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader;

import android.content.res.Resources;
import android.graphics.Color;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Stack;
import org.rajawali3d.Object3D;
import org.rajawali3d.loader.AMeshLoader;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.materials.textures.TextureManager;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.primitives.Line3D;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.util.RajLog;

public class LoaderGCode
extends AMeshLoader {
    private HashMap<String, String> metaData;

    public LoaderGCode(String filename) {
        super(filename);
        this.init();
    }

    public LoaderGCode(File file) {
        super(file);
        this.init();
    }

    public LoaderGCode(Renderer renderer, File file) {
        super(renderer, file);
        this.init();
    }

    public LoaderGCode(Renderer renderer, String fileOnSDCard) {
        super(renderer, fileOnSDCard);
        this.init();
    }

    public LoaderGCode(Resources resources, TextureManager textureManager, int resourceId) {
        super(resources, textureManager, resourceId);
        this.init();
    }

    public void init() {
    }

    public HashMap<String, String> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(HashMap<String, String> metaData) {
        this.metaData = metaData;
    }

    @Override
    public AMeshLoader parse() throws ParsingException {
        super.parse();
        try {
            BufferedInputStream buffer = null;
            buffer = this.getBufferedInputStream();
            GCodeFlavor type = LoaderGCode.tasteFlavor(buffer);
            switch (type) {
                case SLIC3R: {
                    this.metaData = this.readSlic3rComments(buffer);
                    this.mRootObject = this.readGCode(buffer);
                    break;
                }
                case SKEINFORGE: {
                    this.metaData = this.readSkeinforgeComments(buffer);
                    this.mRootObject = this.readGCode(buffer);
                }
                default: {
                    this.mRootObject = this.readGCode(buffer);
                }
            }
            if (buffer != null) {
                buffer.close();
            }
        }
        catch (FileNotFoundException e) {
            RajLog.e("[" + this.getClass().getCanonicalName() + "] Could not find file.");
            throw new ParsingException("File not found.", e);
        }
        catch (NumberFormatException e) {
            RajLog.e(Log.getStackTraceString((Throwable)e));
            throw new ParsingException("Unexpected value.", e);
        }
        catch (IOException e) {
            RajLog.e(Log.getStackTraceString((Throwable)e));
            throw new ParsingException("File reading failed.", e);
        }
        catch (Exception e) {
            RajLog.e(Log.getStackTraceString((Throwable)e));
            throw new ParsingException("Unexpected exception occured.", e);
        }
        return this;
    }

    @Override
    protected BufferedInputStream getBufferedInputStream() throws FileNotFoundException {
        return super.getBufferedInputStream(512);
    }

    protected HashMap<String, String> readSlic3rComments(BufferedInputStream buffer) throws IOException {
        buffer.mark(4096);
        HashMap<String, String> ret = new HashMap<String, String>();
        StringBuilder lnBuilder = new StringBuilder(1024);
        for (int i = 0; buffer.available() > 0 && i < 4096; ++i) {
            byte b = (byte)buffer.read();
            if (b != 10) {
                lnBuilder.append((char)b);
                continue;
            }
            String line = lnBuilder.toString();
            lnBuilder.delete(0, lnBuilder.length() > 0 ? lnBuilder.length() - 1 : 0);
            if (!line.startsWith(";")) break;
            String[] parts = line.split("=");
            if (parts.length < 2) continue;
            String key = parts[0].trim();
            String value = parts[1].trim();
            ret.put(key, value);
        }
        buffer.reset();
        return ret;
    }

    protected HashMap<String, String> readSkeinforgeComments(BufferedInputStream buffer) throws IOException {
        return new HashMap<String, String>();
    }

    protected Object3D readGCode(BufferedInputStream buffer) throws IOException {
        RajLog.i("GCodePaser: reading file");
        Object3D ret = new Object3D();
        SupportedCommands cmd = null;
        GCodeLine motion = null;
        GCodeLine prevMotion = null;
        GCodeLayer currentLayer = new GCodeLayer();
        float lastZPos = 0.0f;
        float lastExtrudeZ = 0.0f;
        float units = 1.0f;
        boolean relative = false;
        prevMotion = new GCodeLine();
        prevMotion.setX(0.0f);
        prevMotion.setY(0.0f);
        prevMotion.setZ(0.0f);
        prevMotion.setE(0.0f);
        prevMotion.setF(0.0f);
        StringBuilder lnBuilder = new StringBuilder(1024);
        boolean lineNum = false;
        while (buffer.available() > 0) {
            String[] tokens;
            byte b = (byte)buffer.read();
            if (b != 10) {
                lnBuilder.append((char)b);
                continue;
            }
            String codeLine = lnBuilder.toString();
            lnBuilder.delete(0, lnBuilder.length());
            if (codeLine.startsWith(";") || null == (tokens = codeLine.split(" ")) || tokens.length == 0) continue;
            try {
                cmd = SupportedCommands.fromString(tokens[0]);
            }
            catch (IllegalArgumentException e) {
                RajLog.w("encountered unsupported gcode:" + tokens[0]);
                continue;
            }
            switch (cmd) {
                case G1: {
                    float y;
                    motion = new GCodeLine(codeLine);
                    motion.setOrigin(prevMotion);
                    if (motion.getX() == -1.0f && motion.getY() == -1.0f && motion.getZ() == -1.0f) break;
                    float x = motion.getX() == -1.0f ? 0.0f : motion.getX();
                    float f = y = motion.getY() == -1.0f ? 0.0f : motion.getY();
                    if (motion.getZ() != -1.0f) {
                        lastZPos = motion.getZ();
                        if (x == 0.0f && y == 0.0f) break;
                    }
                    currentLayer.getPoints().add(new Vector3(x, y, lastZPos));
                    if (motion.getE() != -1.0f) {
                        float delta;
                        if (relative) {
                            delta = motion.getE() - prevMotion.getE();
                        } else {
                            delta = motion.getE();
                            if (delta == -1.0f) {
                                delta = 0.0f;
                            }
                        }
                        if (delta > 0.0f && lastZPos > lastExtrudeZ) {
                            lastExtrudeZ = lastZPos;
                            ret.addChild(new Line3D(currentLayer.getPoints(), 1.0f, Color.argb((int)255, (int)85, (int)17, (int)239)));
                            currentLayer = new GCodeLayer();
                        }
                    }
                    prevMotion = motion;
                    break;
                }
                case G21: {
                    units = 1.0f;
                    break;
                }
                case G90: {
                    relative = false;
                    break;
                }
                case G91: {
                    relative = true;
                    break;
                }
                case G92: {
                    motion = new GCodeLine(codeLine);
                    if (motion.getX() != 1.0f) {
                        prevMotion.setX(motion.getX());
                    }
                    if (motion.getY() != 1.0f) {
                        prevMotion.setY(motion.getY());
                    }
                    if (motion.getZ() != 1.0f) {
                        prevMotion.setZ(motion.getZ());
                    }
                    if (motion.getE() == 1.0f) break;
                    prevMotion.setE(motion.getE());
                    break;
                }
                case M82: {
                    break;
                }
            }
        }
        return ret;
    }

    public static final GCodeFlavor tasteFlavor(File file) throws IOException, GCodeParseException {
        if (file.exists()) {
            throw new GCodeParseException("Passed file does not exist.");
        }
        if (!file.isFile()) {
            throw new GCodeParseException("This is not a file.");
        }
        BufferedInputStream buffer = new BufferedInputStream(new FileInputStream(file));
        GCodeFlavor ret = LoaderGCode.tasteFlavor(buffer);
        buffer.close();
        return ret;
    }

    public static final GCodeFlavor tasteFlavor(Resources res, int resId) throws IOException, Resources.NotFoundException {
        BufferedInputStream buffer = new BufferedInputStream(res.openRawResource(resId));
        GCodeFlavor ret = LoaderGCode.tasteFlavor(buffer);
        buffer.close();
        return ret;
    }

    public static final GCodeFlavor tasteFlavor(BufferedInputStream buffer) throws IOException {
        int rl = 200;
        byte[] readAhead = new byte[rl];
        buffer.mark(readAhead.length);
        for (int i = 0; buffer.available() > 0 && i < rl; ++i) {
            readAhead[i] = (byte)buffer.read();
        }
        buffer.reset();
        String readAheadString = new String(readAhead).toLowerCase(Locale.US);
        if (readAheadString.contains("generated by slic3r")) {
            return GCodeFlavor.SLIC3R;
        }
        if (readAheadString.contains("skeinforge")) {
            return GCodeFlavor.SKEINFORGE;
        }
        return GCodeFlavor.UNKNOWN;
    }

    public static class GCodeLayer {
        private Stack<Vector3> points = new Stack();

        public Stack<Vector3> getPoints() {
            return this.points;
        }

        public void setPoints(Stack<Vector3> points) {
            this.points = points;
        }
    }

    public static class GCodeLine {
        public static final float DEFAULT_THICKNESS = 1.0f;
        public static final int DEFAULT_COLOR = 0x9C9C9C;
        private boolean invalidateLine;
        private float thickness = 1.0f;
        private int color = 0x9C9C9C;
        private float origin_x;
        private float origin_y;
        private float origin_z;
        private float origin_e;
        private float origin_f;
        private float x;
        private float y;
        private float z;
        private float e;
        private float f;

        public GCodeLine() {
        }

        public GCodeLine(String in) {
            this.init();
            if (null != in) {
                String gin = in;
                String[] parts = gin.toLowerCase(Locale.US).split(" ");
                for (int i = 0; i < parts.length; ++i) {
                    String part = parts[i].trim();
                    try {
                        String sVal = part.substring(1, part.length() - 1);
                        sVal = sVal.replaceAll("[,;\\s]+", "");
                        if (sVal.trim().length() == 0) continue;
                        float val = Float.parseFloat(sVal);
                        if (part.startsWith("x")) {
                            this.x = val;
                            continue;
                        }
                        if (part.startsWith("y")) {
                            this.y = val;
                            continue;
                        }
                        if (part.startsWith("z")) {
                            this.z = val;
                            continue;
                        }
                        if (part.startsWith("e")) {
                            this.e = val;
                            continue;
                        }
                        if (!part.startsWith("f")) continue;
                        this.f = val;
                        continue;
                    }
                    catch (Exception e) {
                        RajLog.e("there was an error parsing gcode=" + gin);
                    }
                }
            }
        }

        public void init() {
            this.f = -1.0f;
            this.e = -1.0f;
            this.z = -1.0f;
            this.y = -1.0f;
            this.x = -1.0f;
        }

        public float getOrigin_x() {
            return this.origin_x;
        }

        public void setOrigin_x(float origin_x) {
            this.origin_x = origin_x;
        }

        public float getOrigin_y() {
            return this.origin_y;
        }

        public void setOrigin_y(float origin_y) {
            this.origin_y = origin_y;
        }

        public float getOrigin_z() {
            return this.origin_z;
        }

        public void setOrigin_z(float origin_z) {
            this.origin_z = origin_z;
        }

        public float getOrigin_e() {
            return this.origin_e;
        }

        public void setOrigin_e(float origin_e) {
            this.origin_e = origin_e;
        }

        public float getOrigin_f() {
            return this.origin_f;
        }

        public void setOrigin_f(float origin_f) {
            this.origin_f = origin_f;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float x) {
            this.x = x;
            this.invalidateLine = true;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float y) {
            this.y = y;
            this.invalidateLine = true;
        }

        public float getZ() {
            return this.z;
        }

        public void setZ(float z) {
            this.z = z;
            this.invalidateLine = true;
        }

        public float getE() {
            return this.e;
        }

        public void setE(float e) {
            this.e = e;
            this.invalidateLine = true;
        }

        public float getF() {
            return this.f;
        }

        public void setF(float f) {
            this.f = f;
            this.invalidateLine = true;
        }

        public void setOrigin(GCodeLine line) {
            if (null == line) {
                this.origin_f = -1.0f;
                this.origin_e = -1.0f;
                this.origin_z = -1.0f;
                this.origin_y = -1.0f;
                this.origin_x = -1.0f;
            } else {
                this.origin_x = line.getOrigin_x();
                this.origin_y = line.getOrigin_y();
                this.origin_z = line.getOrigin_z();
                this.origin_e = line.getOrigin_e();
                this.origin_f = line.getOrigin_f();
            }
        }
    }

    public static enum SupportedCommands {
        G1(0),
        G21(1),
        G90(2),
        G91(3),
        G92(4),
        M82(5),
        M84(6);

        private int val;

        private SupportedCommands(int val) {
            this.val = val;
        }

        public final int getVal() {
            return this.val;
        }

        public static SupportedCommands fromString(String val) throws IllegalArgumentException {
            if (val == null) {
                return null;
            }
            String tVal = val.trim().toLowerCase(Locale.US);
            if ("g1".equals(tVal)) {
                return G1;
            }
            if ("g21".equals(tVal)) {
                return G21;
            }
            if ("g90".equals(tVal)) {
                return G90;
            }
            if ("g91".equals(tVal)) {
                return G91;
            }
            if ("g92".equals(tVal)) {
                return G92;
            }
            if ("m82".equals(tVal)) {
                return M82;
            }
            if ("m84".equals(tVal)) {
                return M84;
            }
            throw new IllegalArgumentException("unsupported gcode: " + val);
        }

        public String toString() {
            switch (this) {
                case G1: {
                    return "G1";
                }
                case G21: {
                    return "G21";
                }
                case G90: {
                    return "G90";
                }
                case G91: {
                    return "G91";
                }
                case G92: {
                    return "G92";
                }
                case M82: {
                    return "M82";
                }
                case M84: {
                    return "M84";
                }
            }
            return "";
        }
    }

    public static enum GCodeFlavor {
        UNKNOWN(0),
        SLIC3R(1),
        SKEINFORGE(2);

        private int val;

        private GCodeFlavor(int val) {
            this.val = val;
        }

        public final int getVal() {
            return this.val;
        }

        public static GCodeFlavor fromString(String val) {
            GCodeFlavor ret = null;
            if (val == null) {
                return ret;
            }
            String tVal = val.trim().toLowerCase(Locale.US);
            if ("slic3r".equals(tVal)) {
                return SLIC3R;
            }
            if ("skeinforge".equals(tVal)) {
                return SKEINFORGE;
            }
            return UNKNOWN;
        }

        public String toString() {
            switch (this) {
                case UNKNOWN: {
                    return "UNKNOWN";
                }
                case SLIC3R: {
                    return "SLIC3R";
                }
                case SKEINFORGE: {
                    return "SKEINFORGE";
                }
            }
            return "";
        }
    }

    public static final class GCodeParseException
    extends ParsingException {
        private static final long serialVersionUID = 3677613639116796904L;

        public GCodeParseException(String msg) {
            super(msg);
        }
    }
}

