/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader;

import android.content.res.Resources;
import android.os.SystemClock;
import android.util.SparseArray;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.rajawali3d.Object3D;
import org.rajawali3d.loader.AMeshLoader;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.loader.awd.ABlockParser;
import org.rajawali3d.loader.awd.AExportableBlockParser;
import org.rajawali3d.loader.awd.BlockAnimationSet;
import org.rajawali3d.loader.awd.BlockAnimator;
import org.rajawali3d.loader.awd.BlockBitmapTexture;
import org.rajawali3d.loader.awd.BlockCamera;
import org.rajawali3d.loader.awd.BlockCommand;
import org.rajawali3d.loader.awd.BlockContainer;
import org.rajawali3d.loader.awd.BlockCubeTexture;
import org.rajawali3d.loader.awd.BlockLight;
import org.rajawali3d.loader.awd.BlockLightPicker;
import org.rajawali3d.loader.awd.BlockMeshInstance;
import org.rajawali3d.loader.awd.BlockMeshPose;
import org.rajawali3d.loader.awd.BlockMeshPoseAnimation;
import org.rajawali3d.loader.awd.BlockMetaData;
import org.rajawali3d.loader.awd.BlockNamespace;
import org.rajawali3d.loader.awd.BlockPrimitiveGeometry;
import org.rajawali3d.loader.awd.BlockScene;
import org.rajawali3d.loader.awd.BlockShadowMethod;
import org.rajawali3d.loader.awd.BlockSharedMethod;
import org.rajawali3d.loader.awd.BlockSimpleMaterial;
import org.rajawali3d.loader.awd.BlockSkeleton;
import org.rajawali3d.loader.awd.BlockSkeletonAnimation;
import org.rajawali3d.loader.awd.BlockSkeletonPose;
import org.rajawali3d.loader.awd.BlockSkybox;
import org.rajawali3d.loader.awd.BlockTextureProjector;
import org.rajawali3d.loader.awd.BlockTriangleGeometry;
import org.rajawali3d.loader.awd.BlockUVAnimation;
import org.rajawali3d.loader.awd.exceptions.NotImplementedParsingException;
import org.rajawali3d.materials.textures.TextureManager;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.Quaternion;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.util.LittleEndianDataInputStream;
import org.rajawali3d.util.RajLog;

public class LoaderAWD
extends AMeshLoader {
    protected static final int FLAG_HEADER_STREAMING = 1;
    protected static final int FLAG_HEADER_MATRIX_STORAGE_PRECISION = 2;
    protected static final int FLAG_HEADER_GEOMETRY_STORAGE_PRECISION = 4;
    protected static final int FLAG_HEADER_PROPERTIES_STORAGE_PRECISION = 8;
    protected static final int FLAG_HEADER_COMPRESSION = 8;
    protected static final int FLAG_BLOCK_HEADER_PRECISION = 4;
    protected static final byte NS_AWD = 0;
    protected final List<Object3D> baseObjects = new ArrayList<Object3D>();
    protected final SparseArray<BlockHeader> blockDataList = new SparseArray();
    private final List<IBlockParser> blockParsers = new ArrayList<IBlockParser>();
    private final SparseArray<Class<? extends ABlockParser>> blockParserClassesMap = new SparseArray();
    protected int awdHeaderVersion;
    protected int awdHeaderRevision;
    protected int awdHeaderFlags;
    protected int awdHeaderCompression;
    protected long awdHeaderBodyLength;
    protected boolean awdHeaderAccuracyMatrix;
    protected boolean awdHeaderAccuracyGeo;
    protected boolean awdHeaderAccuracyProps;
    protected boolean mAlwaysUseContainer;

    public LoaderAWD(Renderer renderer, File file) {
        super(renderer, file);
        this.init();
    }

    public LoaderAWD(Resources resources, TextureManager textureManager, int resourceId) {
        super(resources, textureManager, resourceId);
        this.init();
    }

    public LoaderAWD(Renderer renderer, String fileOnSDCard) {
        super(renderer, fileOnSDCard);
        this.init();
    }

    protected void init() {
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 1), BlockTriangleGeometry.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 11), BlockPrimitiveGeometry.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 21), BlockScene.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 22), BlockContainer.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 23), BlockMeshInstance.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 31), BlockSkybox.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 41), BlockLight.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 42), BlockCamera.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 43), BlockTextureProjector.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 51), BlockLightPicker.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 81), BlockSimpleMaterial.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 82), BlockBitmapTexture.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 83), BlockCubeTexture.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 91), BlockSharedMethod.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 92), BlockShadowMethod.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 101), BlockSkeleton.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 102), BlockSkeletonPose.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 103), BlockSkeletonAnimation.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 111), BlockMeshPose.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 112), BlockMeshPoseAnimation.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 113), BlockAnimationSet.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 121), BlockUVAnimation.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 122), BlockAnimator.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 253), BlockCommand.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 254), BlockNamespace.class);
        this.blockParserClassesMap.put(LoaderAWD.getClassID(0, 255), BlockMetaData.class);
    }

    @Override
    public AMeshLoader parse() throws ParsingException {
        AWDLittleEndianDataInputStream dis;
        super.parse();
        this.onRegisterBlockClasses(this.blockParserClassesMap);
        long startTime = SystemClock.elapsedRealtime();
        try {
            dis = this.getLittleEndianInputStream(8192);
        }
        catch (Exception e) {
            throw new ParsingException(e);
        }
        try {
            byte[] buf = new byte[3];
            dis.read(buf);
            if (!new String(buf).equals("AWD")) {
                throw new ParsingException("Invalid header designation: " + new String(buf));
            }
            this.awdHeaderVersion = dis.readUnsignedByte();
            this.awdHeaderRevision = dis.readUnsignedByte();
            this.awdHeaderFlags = dis.readUnsignedShort();
            if (this.awdHeaderVersion == 2 && this.awdHeaderRevision == 1) {
                this.awdHeaderAccuracyMatrix = (this.awdHeaderFlags & 2) == 2;
                this.awdHeaderAccuracyGeo = (this.awdHeaderFlags & 4) == 4;
                this.awdHeaderAccuracyProps = (this.awdHeaderFlags & 8) == 8;
            }
            this.awdHeaderCompression = dis.read();
            this.awdHeaderBodyLength = dis.readUnsignedInt();
            long endOfFile = dis.getPosition() + this.awdHeaderBodyLength;
            if (RajLog.isDebugEnabled()) {
                RajLog.d("AWD Header Data");
                RajLog.d(" Version: " + this.awdHeaderVersion + "." + this.awdHeaderRevision);
                RajLog.d(" Flags: " + this.awdHeaderFlags);
                RajLog.d(" Compression: " + (Object)((Object)this.getCompression()));
                RajLog.d(" Body Length: " + this.awdHeaderBodyLength);
                RajLog.d(" End Of File: " + endOfFile);
            }
            if ((this.awdHeaderFlags & 1) == 1) {
                throw new ParsingException("Streaming not supported.");
            }
            if (this.awdHeaderBodyLength < 1L) {
                throw new ParsingException("AWD Body length not provided which indicates model is streaming or corrupt.");
            }
            if (this.getCompression() != Compression.NONE) {
                throw new ParsingException("Compression is not currently supported. Document compressed as: " + (Object)((Object)this.getCompression()));
            }
            try {
                do {
                    Class blockClass;
                    BlockHeader blockHeader = new BlockHeader();
                    blockHeader.blockHeaders = this.blockDataList;
                    blockHeader.awdVersion = this.awdHeaderVersion;
                    blockHeader.awdRevision = this.awdHeaderRevision;
                    blockHeader.id = dis.readInt();
                    blockHeader.namespace = dis.read();
                    blockHeader.type = dis.read();
                    blockHeader.flags = dis.read();
                    blockHeader.dataLength = dis.readUnsignedInt();
                    blockHeader.globalPrecisionGeo = (blockHeader.flags & 2) == 2;
                    blockHeader.globalPrecisionMatrix = (blockHeader.flags & 1) == 1;
                    blockHeader.globalPrecisionProps = (blockHeader.flags & 4) == 4;
                    blockHeader.blockEnd = dis.getPosition() + blockHeader.dataLength;
                    dis.setPropertyPrecision(blockHeader.globalPrecisionProps);
                    if (blockHeader.id != 0) {
                        this.blockDataList.put(blockHeader.id, (Object)blockHeader);
                    }
                    if (RajLog.isDebugEnabled()) {
                        RajLog.d(blockHeader.toString());
                    }
                    if ((blockClass = (Class)this.blockParserClassesMap.get(LoaderAWD.getClassID(blockHeader.namespace, blockHeader.type))) == null) {
                        if (RajLog.isDebugEnabled()) {
                            RajLog.d(" Skipping unknown block " + blockHeader.namespace + " " + blockHeader.type);
                        }
                        dis.skip(blockHeader.dataLength);
                        continue;
                    }
                    ABlockParser parser = (ABlockParser)Class.forName(blockClass.getName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (blockHeader.id != 0) {
                        blockHeader.parser = parser;
                    }
                    this.blockParsers.add(parser);
                    if (RajLog.isDebugEnabled()) {
                        RajLog.d(" Parsing block with: " + parser.getClass().getSimpleName());
                        RajLog.d(" Starting at position: " + dis.getPosition());
                    }
                    try {
                        parser.parseBlock(dis, blockHeader);
                    }
                    catch (NotImplementedParsingException e) {
                        if (RajLog.isDebugEnabled()) {
                            RajLog.d(" Skipping block as not implemented.");
                        }
                        dis.skip(blockHeader.blockEnd - dis.getPosition());
                    }
                    if (blockHeader.blockEnd == dis.getPosition()) continue;
                    throw new ParsingException("Block did not end in the correct location. Expected : " + blockHeader.blockEnd + " Ended : " + dis.getPosition());
                } while (dis.getPosition() < endOfFile);
                if (RajLog.isDebugEnabled()) {
                    RajLog.d("End of blocks reached.");
                }
            }
            catch (IOException e) {
                throw new ParsingException("Buffer overrun; unexpected end of file.", e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParsingException("Unexpected error. File is not in a supported AWD format.", e);
        }
        this.onBlockParsingFinished(this.blockParsers);
        RajLog.d("Finished Parsing in " + (SystemClock.elapsedRealtime() - startTime));
        return this;
    }

    @Override
    public Object3D getParsedObject() {
        if (!this.mAlwaysUseContainer && this.baseObjects.size() == 1) {
            return this.baseObjects.get(0);
        }
        this.mRootObject.isContainer(true);
        int j = this.baseObjects.size();
        for (int i = 0; i < j; ++i) {
            this.mRootObject.addChild(this.baseObjects.get(i));
        }
        return this.mRootObject;
    }

    @Override
    protected AWDLittleEndianDataInputStream getLittleEndianInputStream(int size) throws FileNotFoundException {
        return new AWDLittleEndianDataInputStream(this.getBufferedInputStream(size));
    }

    public BlockHeader getBlockByID(int blockID) {
        if (this.blockDataList.indexOfKey(blockID) < 0) {
            throw new RuntimeException("Block parsing referenced non existant id: " + blockID);
        }
        return (BlockHeader)this.blockDataList.get(blockID);
    }

    public Compression getCompression() {
        try {
            return Compression.values()[this.awdHeaderCompression];
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown compression setting detected!");
        }
    }

    public void onBlockParsingFinished(List<IBlockParser> blockParsers) {
        int j = blockParsers.size();
        for (int i = 0; i < j; ++i) {
            Object3D temp;
            IBlockParser blockParser = blockParsers.get(i);
            if (!(blockParser instanceof AExportableBlockParser) || (temp = ((AExportableBlockParser)blockParser).getBaseObject3D()) == null) continue;
            this.baseObjects.add(temp);
        }
    }

    public void setAlwaysUseContainer(boolean flag) {
        this.mAlwaysUseContainer = flag;
    }

    protected static int getClassID(int namespace, int typeID) {
        return (short)(namespace << 8 | typeID);
    }

    protected void onRegisterBlockClasses(SparseArray<Class<? extends ABlockParser>> blockParserClassesMap) {
    }

    public static final class AwdProperties
    extends HashMap<Short, Object> {
        private static final long serialVersionUID = 221100798331514427L;

        public Object get(short key, Object fallback) {
            return this.containsKey(key) ? this.get(key) : fallback;
        }
    }

    public static final class AWDLittleEndianDataInputStream
    extends LittleEndianDataInputStream {
        public static final short TYPE_NR = -1;
        public static final short TYPE_INT8 = 1;
        public static final short TYPE_INT16 = 2;
        public static final short TYPE_INT32 = 3;
        public static final short TYPE_UINT8 = 4;
        public static final short TYPE_UINT16 = 5;
        public static final short TYPE_UINT32 = 6;
        public static final short TYPE_FLOAT32 = 7;
        public static final short TYPE_FLOAT64 = 8;
        public static final short TYPE_BOOL = 21;
        public static final short TYPE_COLOR = 22;
        public static final short TYPE_BADDR = 23;
        public static final short TYPE_AWDSTRING = 31;
        public static final short TYPE_AWDBYTEARRAY = 32;
        public static final short TYPE_VECTOR2x1 = 41;
        public static final short TYPE_VECTOR3x1 = 42;
        public static final short TYPE_VECTOR4x1 = 43;
        public static final short TYPE_MTX3x2 = 44;
        public static final short TYPE_MTX3x3 = 45;
        public static final short TYPE_MTX4x3 = 46;
        public static final short TYPE_MTX4x4 = 47;
        private boolean mPropPrecision;
        private final Vector3 mTempVector3 = new Vector3();
        private final Quaternion mTempQuaternion = new Quaternion();

        public AWDLittleEndianDataInputStream(InputStream in) {
            super(in);
        }

        public void setPropertyPrecision(boolean flag) {
            this.mPropPrecision = flag;
        }

        public void readMatrix2D(float[] matrix) throws IOException, ParsingException {
            if (matrix == null || matrix.length != 6) {
                throw new ParsingException("Matrix array must be of size 6");
            }
            matrix[0] = this.readFloat();
            matrix[1] = this.readFloat();
            matrix[2] = this.readFloat();
            matrix[3] = this.readFloat();
            matrix[4] = this.readFloat();
            matrix[5] = this.readFloat();
        }

        public void readMatrix3D(Matrix4 matrix, boolean usePrecision, boolean convert) throws ParsingException, IOException {
            double[] m = matrix.getDoubleValues();
            if (m == null || m.length != 16) {
                throw new ParsingException("Matrix array must be of size 16");
            }
            if (convert) {
                m[0] = this.readPrecisionNumber(usePrecision);
                m[4] = this.readPrecisionNumber(usePrecision);
                m[8] = this.readPrecisionNumber(usePrecision);
                m[1] = this.readPrecisionNumber(usePrecision);
                m[5] = this.readPrecisionNumber(usePrecision);
                m[9] = this.readPrecisionNumber(usePrecision);
                m[2] = this.readPrecisionNumber(usePrecision);
                m[6] = this.readPrecisionNumber(usePrecision);
                m[10] = this.readPrecisionNumber(usePrecision);
                m[12] = this.readPrecisionNumber(usePrecision);
                m[13] = this.readPrecisionNumber(usePrecision);
                m[14] = -this.readPrecisionNumber(usePrecision);
                m[3] = 0.0;
                m[7] = 0.0;
                m[11] = 0.0;
                m[15] = 1.0;
                matrix.getTranslation(this.mTempVector3);
                this.mTempQuaternion.fromMatrix(matrix);
                this.mTempQuaternion.computeW();
                this.mTempQuaternion.z = -this.mTempQuaternion.z;
                this.mTempQuaternion.w = -this.mTempQuaternion.w;
                matrix.setAll(this.mTempQuaternion);
                matrix.setTranslation(this.mTempVector3);
            } else {
                m[0] = this.readPrecisionNumber(usePrecision);
                m[1] = this.readPrecisionNumber(usePrecision);
                m[2] = this.readPrecisionNumber(usePrecision);
                m[3] = 0.0;
                m[4] = this.readPrecisionNumber(usePrecision);
                m[5] = this.readPrecisionNumber(usePrecision);
                m[6] = this.readPrecisionNumber(usePrecision);
                m[7] = 0.0;
                m[8] = this.readPrecisionNumber(usePrecision);
                m[9] = this.readPrecisionNumber(usePrecision);
                m[10] = this.readPrecisionNumber(usePrecision);
                m[11] = 0.0;
                m[12] = this.readPrecisionNumber(usePrecision);
                m[13] = this.readPrecisionNumber(usePrecision);
                m[14] = this.readPrecisionNumber(usePrecision);
                m[15] = 1.0;
            }
        }

        public double readPrecisionNumber(boolean usePrecision) throws IOException, ParsingException {
            return usePrecision ? this.readDouble() : (double)this.readFloat();
        }

        public void readProperties() throws IOException {
            this.readProperties(null);
        }

        public AwdProperties readProperties(SparseArray<Short> expected) throws IOException {
            long propsLength = this.readUnsignedInt();
            long endPosition = this.mPosition + propsLength;
            if (expected == null) {
                if (RajLog.isDebugEnabled()) {
                    RajLog.d("  Skipping property values.");
                }
                this.skip(propsLength);
            }
            AwdProperties props = new AwdProperties();
            if (propsLength == 0L) {
                return props;
            }
            while (this.mPosition < endPosition) {
                short propKey = (short)this.readUnsignedShort();
                long propLength = this.readUnsignedInt();
                if (this.mPosition + propLength > endPosition) {
                    RajLog.e("Unexpected properties length. Properties attemped to read past total properties length.");
                    if (endPosition > this.mPosition) {
                        this.skip(endPosition - this.mPosition);
                    }
                    return props;
                }
                if (expected.indexOfKey((int)propKey) > -1) {
                    props.put(propKey, this.parseAttrValue((Short)expected.get((int)propKey), propLength));
                    continue;
                }
                this.skip(propLength);
            }
            return props;
        }

        public HashMap<String, Object> readUserAttributes(HashMap<String, Object> attributes) throws IOException {
            long attributesLength = this.readUnsignedInt();
            long endPosition = this.mPosition + attributesLength;
            if (attributesLength == 0L) {
                return attributes;
            }
            if (attributes == null) {
                this.skip(attributesLength);
                return attributes;
            }
            while (this.mPosition < endPosition) {
                short attrNameSpace = (short)this.readUnsignedByte();
                String attrKey = this.readVarString();
                short attrType = (short)this.readUnsignedByte();
                long attrLength = this.readUnsignedInt();
                if (this.mPosition + attrLength > endPosition) {
                    RajLog.e("Unexpected attribute length. Attributes attempted to read past total attributes length.");
                    if (endPosition > this.mPosition) {
                        this.skip(endPosition - this.mPosition);
                    }
                    return attributes;
                }
                attributes.put(attrKey, this.parseAttrValue(attrType, attrLength));
            }
            return attributes;
        }

        private Object parseAttrValue(short attrType, long attrLength) throws IOException {
            Object attrValue = null;
            switch (attrType) {
                case 31: {
                    attrValue = this.readString((int)attrLength);
                    break;
                }
                case 1: {
                    attrValue = this.readByte();
                    break;
                }
                case 2: {
                    attrValue = this.readShort();
                    break;
                }
                case 3: {
                    attrValue = this.readInt();
                    break;
                }
                case 21: {
                    attrValue = this.readBoolean();
                    break;
                }
                case 4: {
                    attrValue = this.readUnsignedByte();
                    break;
                }
                case 5: {
                    attrValue = this.readUnsignedShort();
                    break;
                }
                case 6: 
                case 23: {
                    attrValue = this.readUnsignedInt();
                    break;
                }
                case 7: {
                    attrValue = Float.valueOf(this.readFloat());
                    break;
                }
                case 8: {
                    attrValue = this.readDouble();
                    break;
                }
                case -1: {
                    attrValue = this.mPropPrecision ? this.readDouble() : (double)this.readFloat();
                    break;
                }
                default: {
                    RajLog.e("Skipping unknown attribute (" + attrType + ")");
                    this.skip(attrLength);
                }
            }
            return attrValue;
        }

        public String readVarString() throws IOException {
            int varStringLength = this.readUnsignedShort();
            return varStringLength == 0 ? "" : this.readString(varStringLength);
        }

        public static enum Precision {
            GEO,
            MATRIX,
            PROPS;

        }
    }

    public static final class BlockHeader {
        public static final int FLAG_ACCURACY_MATRIX = 1;
        public static final int FLAG_ACCURACY_GEO = 2;
        public static final int FLAG_ACCURACY_PROPS = 4;
        public SparseArray<BlockHeader> blockHeaders;
        public ABlockParser parser;
        public int awdVersion;
        public int awdRevision;
        public int id;
        public int namespace;
        public int type;
        public int flags;
        public long dataLength;
        public long blockEnd;
        public boolean globalPrecisionGeo;
        public boolean globalPrecisionMatrix;
        public boolean globalPrecisionProps;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" Block ID: ").append(this.id).append("\n");
            sb.append(" Block Namespace: ").append(this.namespace).append("\n");
            sb.append(" Block Type: ").append(this.type).append("\n");
            sb.append(" Block Precision Geo: ").append(this.globalPrecisionGeo).append("\n");
            sb.append(" Block Precision Matrix: ").append(this.globalPrecisionMatrix).append("\n");
            sb.append(" Block Precision Props: ").append(this.globalPrecisionProps).append("\n");
            sb.append(" Block Length: ").append(this.dataLength).append("\n");
            sb.append(" Block End: ").append(this.blockEnd).append("\n");
            return sb.toString();
        }
    }

    public static interface IBlockParser {
        public void parseBlock(AWDLittleEndianDataInputStream var1, BlockHeader var2) throws Exception;
    }

    static enum Compression {
        NONE,
        ZLIB,
        LZMA;

    }
}

