/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.rajawali3d.Object3D;
import org.rajawali3d.loader.AMeshLoader;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.methods.DiffuseMethod;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.util.RajLog;

public class Loader3DSMax
extends AMeshLoader {
    private final int IDENTIFIER_3DS = 19789;
    private final int MESH_BLOCK = 15677;
    private final int OBJECT_BLOCK = 16384;
    private final int TRIMESH = 16640;
    private final int VERTICES = 16656;
    private final int FACES = 16672;
    private final int TEXCOORD = 16704;
    private final int TEX_MAP = 41472;
    private final int TRI_MATERIAL = 16688;
    private final int TEX_NAME = 40960;
    private final int TEX_FILENAME = 41728;
    private final int MATERIAL = 45055;
    private ArrayList<ArrayList<Vector3>> mVertices = new ArrayList();
    private ArrayList<Vector3[]> mNormals = new ArrayList();
    private ArrayList<ArrayList<Vector3>> mVertNormals = new ArrayList();
    private ArrayList<ArrayList<Vector3>> mTexCoords = new ArrayList();
    private ArrayList<ArrayList<Integer>> mIndices = new ArrayList();
    private ArrayList<String> mObjNames = new ArrayList();
    private int mChunkID;
    private int mChunkEndOffset;
    private boolean mEndReached = false;
    private int mObjects = -1;

    public Loader3DSMax(Renderer renderer, int resourceID) {
        super(renderer.getContext().getResources(), renderer.getTextureManager(), resourceID);
    }

    public Loader3DSMax(Renderer renderer, File file) {
        super(renderer, file);
    }

    @Override
    public AMeshLoader parse() throws ParsingException {
        BufferedInputStream stream;
        RajLog.i("Start parsing 3DS");
        if (this.mFile == null) {
            stream = new BufferedInputStream(this.mResources.openRawResource(this.mResourceId));
        } else {
            try {
                stream = new BufferedInputStream(new FileInputStream(this.mFile));
            }
            catch (Exception e) {
                throw new ParsingException(e);
            }
        }
        try {
            this.readHeader(stream);
            if (this.mChunkID != 19789) {
                RajLog.e("Not a valid 3DS file");
                return null;
            }
            while (!this.mEndReached) {
                this.readChunk(stream);
            }
            try {
                this.build();
            }
            catch (ATexture.TextureException tme) {
                throw new ParsingException(tme);
            }
            if (this.mRootObject.getNumChildren() == 1) {
                this.mRootObject = this.mRootObject.getChildAt(0);
            }
            ((InputStream)stream).close();
            RajLog.i("End parsing 3DS");
        }
        catch (IOException e) {
            RajLog.e("Error parsing");
            throw new ParsingException(e);
        }
        return this;
    }

    void readChunk(InputStream stream) throws IOException {
        this.readHeader(stream);
        switch (this.mChunkID) {
            case 15677: {
                break;
            }
            case 16384: {
                ++this.mObjects;
                this.mObjNames.add(this.readString(stream));
                break;
            }
            case 16640: {
                break;
            }
            case 16656: {
                this.readVertices(stream);
                break;
            }
            case 16672: {
                this.readFaces(stream);
                break;
            }
            case 16704: {
                this.readTexCoords(stream);
                break;
            }
            case 40960: {
                this.skipRead(stream);
                break;
            }
            case 41728: {
                this.skipRead(stream);
                break;
            }
            case 16688: {
                this.skipRead(stream);
                break;
            }
            case 45055: {
                break;
            }
            case 41472: {
                break;
            }
            default: {
                this.skipRead(stream);
            }
        }
    }

    public void build() throws ATexture.TextureException {
        int num = this.mVertices.size();
        for (int j = 0; j < num; ++j) {
            ArrayList<Integer> indices = this.mIndices.get(j);
            ArrayList<Vector3> vertices = this.mVertices.get(j);
            ArrayList<Vector3> texCoords = null;
            ArrayList<Vector3> vertNormals = this.mVertNormals.get(j);
            if (this.mTexCoords.size() > 0) {
                texCoords = this.mTexCoords.get(j);
            }
            int len = indices.size();
            float[] aVertices = new float[len * 3];
            float[] aNormals = new float[len * 3];
            float[] aTexCoords = new float[len * 2];
            int[] aIndices = new int[len];
            int ic = 0;
            int itn = 0;
            int itc = 0;
            int ivi = 0;
            for (int i = 0; i < len; i += 3) {
                int v1 = indices.get(i);
                int v2 = indices.get(i + 1);
                int v3 = indices.get(i + 2);
                Vector3 coord = vertices.get(v1);
                aVertices[ic++] = (float)coord.x;
                aVertices[ic++] = (float)coord.y;
                aVertices[ic++] = (float)coord.z;
                aIndices[ivi] = ivi++;
                coord = vertices.get(v2);
                aVertices[ic++] = (float)coord.x;
                aVertices[ic++] = (float)coord.y;
                aVertices[ic++] = (float)coord.z;
                aIndices[ivi] = ivi++;
                coord = vertices.get(v3);
                aVertices[ic++] = (float)coord.x;
                aVertices[ic++] = (float)coord.y;
                aVertices[ic++] = (float)coord.z;
                aIndices[ivi] = ivi++;
                if (texCoords != null && texCoords.size() > 0) {
                    Vector3 texcoord = texCoords.get(v1);
                    aTexCoords[itc++] = (float)texcoord.x;
                    aTexCoords[itc++] = (float)texcoord.y;
                    texcoord = texCoords.get(v2);
                    aTexCoords[itc++] = (float)texcoord.x;
                    aTexCoords[itc++] = (float)texcoord.y;
                    texcoord = texCoords.get(v3);
                    aTexCoords[itc++] = (float)texcoord.x;
                    aTexCoords[itc++] = (float)texcoord.y;
                }
                Vector3 normal = vertNormals.get(v1);
                aNormals[itn++] = (float)normal.x;
                aNormals[itn++] = (float)normal.y;
                aNormals[itn++] = (float)normal.z;
                normal = vertNormals.get(v2);
                aNormals[itn++] = (float)normal.x;
                aNormals[itn++] = (float)normal.y;
                aNormals[itn++] = (float)normal.z;
                normal = vertNormals.get(v3);
                aNormals[itn++] = (float)normal.x;
                aNormals[itn++] = (float)normal.y;
                aNormals[itn++] = (float)normal.z;
            }
            Object3D targetObj = new Object3D(this.mObjNames.get(j));
            targetObj.setData(aVertices, aNormals, aTexCoords, null, aIndices, false);
            Material material = new Material();
            material.setDiffuseMethod(new DiffuseMethod.Lambert());
            targetObj.setMaterial(material);
            targetObj.setColor(-16777216 + (int)(Math.random() * 1.6777215E7));
            this.mRootObject.addChild(targetObj);
        }
    }

    public void clear() {
        for (int i = 0; i < this.mObjects; ++i) {
            this.mIndices.get(i).clear();
            this.mVertNormals.get(i).clear();
            this.mVertices.get(i).clear();
            this.mTexCoords.get(i).clear();
        }
        this.mIndices.clear();
        this.mVertNormals.clear();
        this.mVertices.clear();
        this.mTexCoords.clear();
    }

    protected void skipRead(InputStream stream) throws IOException {
        for (int i = 0; i < this.mChunkEndOffset - 6 && !this.mEndReached; ++i) {
            this.mEndReached = stream.read() < 0;
        }
    }

    protected void readVertices(InputStream buffer) throws IOException {
        int numVertices = this.readShort(buffer);
        ArrayList<Vector3> vertices = new ArrayList<Vector3>();
        for (int i = 0; i < numVertices; ++i) {
            float x = this.readFloat(buffer);
            float y = this.readFloat(buffer);
            float z = this.readFloat(buffer);
            vertices.add(new Vector3(x, y, z));
        }
        this.mVertices.add(vertices);
    }

    protected void readTexCoords(InputStream buffer) throws IOException {
        int numVertices = this.readShort(buffer);
        ArrayList<Vector3> texCoords = new ArrayList<Vector3>();
        for (int i = 0; i < numVertices; ++i) {
            float x = this.readFloat(buffer);
            float y = 1.0f - this.readFloat(buffer);
            texCoords.add(new Vector3(x, y, 0.0));
        }
        this.mTexCoords.add(texCoords);
    }

    protected void readFaces(InputStream buffer) throws IOException {
        int triangles = this.readShort(buffer);
        Vector3[] normals = new Vector3[triangles];
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < triangles; ++i) {
            Vector3 normal;
            int[] vertexIDs = new int[]{this.readShort(buffer), this.readShort(buffer), this.readShort(buffer)};
            this.readShort(buffer);
            indices.add(vertexIDs[0]);
            indices.add(vertexIDs[1]);
            indices.add(vertexIDs[2]);
            normals[i] = normal = this.calculateFaceNormal(vertexIDs);
        }
        this.mNormals.add(new Vector3[triangles]);
        this.mIndices.add(indices);
        int numVertices = this.mVertices.get(this.mObjects).size();
        int numIndices = indices.size();
        ArrayList<Vector3> vertNormals = new ArrayList<Vector3>();
        for (int i = 0; i < numVertices; ++i) {
            Vector3 vertexNormal = new Vector3();
            for (int j = 0; j < numIndices; j += 3) {
                int id1 = (Integer)indices.get(j);
                int id2 = (Integer)indices.get(j + 1);
                int id3 = (Integer)indices.get(j + 2);
                if (id1 != i && id2 != i && id3 != i) continue;
                vertexNormal.add(normals[j / 3]);
            }
            vertexNormal.normalize();
            vertNormals.add(vertexNormal);
        }
        this.mVertNormals.add(vertNormals);
    }

    private Vector3 calculateFaceNormal(int[] vertexIDs) {
        ArrayList<Vector3> vertices = this.mVertices.get(this.mObjects);
        Vector3 v1 = vertices.get(vertexIDs[0]);
        Vector3 v2 = vertices.get(vertexIDs[2]);
        Vector3 v3 = vertices.get(vertexIDs[1]);
        Vector3 vector1 = Vector3.subtractAndCreate(v2, v1);
        Vector3 vector2 = Vector3.subtractAndCreate(v3, v1);
        Vector3 normal = Vector3.crossAndCreate(vector1, vector2);
        normal.normalize();
        return normal;
    }

    protected void readHeader(InputStream stream) throws IOException {
        this.mChunkID = this.readShort(stream);
        this.mChunkEndOffset = this.readInt(stream);
        this.mEndReached = this.mChunkID < 0;
    }

    @Override
    protected String readString(InputStream stream) throws IOException {
        byte inByte;
        String result = new String();
        while ((inByte = (byte)stream.read()) != 0) {
            result = result + (char)inByte;
        }
        return result;
    }

    @Override
    protected int readInt(InputStream stream) throws IOException {
        return stream.read() | stream.read() << 8 | stream.read() << 16 | stream.read() << 24;
    }

    @Override
    protected int readShort(InputStream stream) throws IOException {
        return stream.read() | stream.read() << 8;
    }

    @Override
    protected float readFloat(InputStream stream) throws IOException {
        return Float.intBitsToFloat(this.readInt(stream));
    }
}

