/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.loader;

import android.content.res.Resources;
import android.os.Environment;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import org.rajawali3d.loader.ILoader;
import org.rajawali3d.loader.ParsingException;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.util.LittleEndianDataInputStream;
import org.rajawali3d.util.RajLog;

public abstract class ALoader
implements ILoader {
    protected Resources mResources;
    protected int mResourceId;
    protected String mFileOnSDCard;
    protected File mFile;
    protected int mTag;

    public ALoader(File file) {
        this(file.getAbsolutePath());
        this.mFile = file;
    }

    public ALoader(String fileOnSDCard) {
        this.mResources = null;
        this.mResourceId = 0;
        this.mFileOnSDCard = fileOnSDCard;
    }

    public ALoader(Renderer renderer, String fileOnSDCard) {
        this(renderer.getContext().getResources(), 0);
        this.mFileOnSDCard = fileOnSDCard;
    }

    public ALoader(Renderer renderer, int resourceId) {
        this(renderer.getContext().getResources(), resourceId);
    }

    public ALoader(Resources resources, int resourceId) {
        this.mResources = resources;
        this.mResourceId = resourceId;
    }

    public ALoader(Renderer renderer, File file) {
        this(renderer.getContext().getResources(), 0);
        this.mFile = file;
    }

    @Override
    public ILoader parse() throws ParsingException {
        if (this.mFile == null && this.mFileOnSDCard != null) {
            this.mFile = new File(Environment.getExternalStorageDirectory(), this.mFileOnSDCard);
        }
        if (this.mFile != null && RajLog.isDebugEnabled()) {
            RajLog.d("Parsing: " + this.mFile.getAbsolutePath());
        }
        return this;
    }

    public int getTag() {
        return this.mTag;
    }

    public void setTag(int tag) {
        this.mTag = tag;
    }

    protected BufferedReader getBufferedReader() throws FileNotFoundException {
        return this.getBufferedReader(8192);
    }

    protected BufferedReader getBufferedReader(int size) throws FileNotFoundException {
        BufferedReader buffer = null;
        buffer = this.mFile == null ? new BufferedReader(new InputStreamReader(this.mResources.openRawResource(this.mResourceId)), size) : new BufferedReader(new FileReader(this.mFile), size);
        return buffer;
    }

    protected BufferedInputStream getBufferedInputStream() throws FileNotFoundException {
        return this.getBufferedInputStream(8192);
    }

    protected BufferedInputStream getBufferedInputStream(int size) throws FileNotFoundException {
        BufferedInputStream bis = this.mFile == null ? new BufferedInputStream(this.mResources.openRawResource(this.mResourceId), size) : new BufferedInputStream(new FileInputStream(this.mFile), size);
        return bis;
    }

    protected LittleEndianDataInputStream getLittleEndianInputStream() throws FileNotFoundException {
        return this.getLittleEndianInputStream(8192);
    }

    protected LittleEndianDataInputStream getLittleEndianInputStream(int size) throws FileNotFoundException {
        return new LittleEndianDataInputStream(this.getBufferedInputStream(size));
    }

    protected String readString(InputStream stream) throws IOException {
        byte inByte;
        String result = new String();
        while ((inByte = (byte)stream.read()) != 0) {
            result = result + (char)inByte;
        }
        return result;
    }

    protected int readInt(InputStream stream) throws IOException {
        return stream.read() | stream.read() << 8 | stream.read() << 16 | stream.read() << 24;
    }

    protected int readShort(InputStream stream) throws IOException {
        return stream.read() | stream.read() << 8;
    }

    protected float readFloat(InputStream stream) throws IOException {
        return Float.intBitsToFloat(this.readInt(stream));
    }

    protected String getOnlyFileName(String fileName) {
        String fName = new String(fileName);
        int indexOf = fName.lastIndexOf("\\");
        if (indexOf > -1) {
            fName = fName.substring(indexOf + 1, fName.length());
        }
        if ((indexOf = fName.lastIndexOf("/")) > -1) {
            fName = fName.substring(indexOf + 1, fName.length());
        }
        return fName.toLowerCase(Locale.ENGLISH).replaceAll("\\s", "_");
    }

    protected String getFileNameWithoutExtension(String fileName) {
        String fName = fileName.substring(0, fileName.lastIndexOf("."));
        int indexOf = fName.lastIndexOf("\\");
        if (indexOf > -1) {
            fName = fName.substring(indexOf + 1, fName.length());
        }
        if ((indexOf = fName.lastIndexOf("/")) > -1) {
            fName = fName.substring(indexOf + 1, fName.length());
        }
        return fName.toLowerCase(Locale.ENGLISH).replaceAll("\\s", "_");
    }
}

