/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.lights;

import org.rajawali3d.lights.DirectionalLight;

public class SpotLight
extends DirectionalLight {
    protected float[] mAttenuation;
    protected float mCutoffAngle;
    protected float mMaxCutoffAngle = 180.0f;
    protected float mFalloff;

    public SpotLight() {
        this.setLightType(2);
        this.mAttenuation = new float[4];
        this.setCutoffAngle(40.0f);
        this.setFalloff(0.4f);
        this.setAttenuation(50.0f, 1.0f, 0.09f, 0.032f);
    }

    public SpotLight(float xDir, float yDir, float zDir) {
        this();
        this.setLookAt(xDir, yDir, zDir);
    }

    public void setAttenuation(float range, float constant, float linear, float quadratic) {
        this.mAttenuation[0] = range;
        this.mAttenuation[1] = constant;
        this.mAttenuation[2] = linear;
        this.mAttenuation[3] = quadratic;
    }

    public void setCutoffAngle(float cutoffAng) {
        if (cutoffAng > this.mMaxCutoffAngle) {
            cutoffAng = this.mMaxCutoffAngle;
        }
        this.mCutoffAngle = cutoffAng;
    }

    public void setFalloff(float falloff) {
        if (Math.abs(falloff) > 1.0f) {
            falloff = 1.0f;
        }
        this.mFalloff = Math.abs(falloff);
    }

    public float[] getAttenuation() {
        return this.mAttenuation;
    }

    public float getCutoffAngle() {
        return this.mCutoffAngle;
    }

    public float getFalloff() {
        return this.mFalloff;
    }
}

