/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.lights;

import org.rajawali3d.ATransformable3D;
import org.rajawali3d.math.vector.Vector3;

public abstract class ALight
extends ATransformable3D {
    public static final int DIRECTIONAL_LIGHT = 0;
    public static final int POINT_LIGHT = 1;
    public static final int SPOT_LIGHT = 2;
    protected final float[] mColor = new float[]{1.0f, 1.0f, 1.0f};
    protected final double[] mPositionArray = new double[3];
    protected final double[] mDirectionArray = new double[3];
    protected float mPower = 0.5f;
    private int mLightType;
    protected boolean mUseObjectTransform;

    public ALight(int lightType) {
        this.mLightType = lightType;
    }

    public void setColor(float r, float g, float b) {
        this.mColor[0] = r;
        this.mColor[1] = g;
        this.mColor[2] = b;
    }

    public void setColor(int color) {
        this.mColor[0] = (float)(color >> 16 & 0xFF) / 255.0f;
        this.mColor[1] = (float)(color >> 8 & 0xFF) / 255.0f;
        this.mColor[2] = (float)(color & 0xFF) / 255.0f;
    }

    public void setColor(Vector3 color) {
        this.setColor((float)color.x, (float)color.y, (float)color.z);
    }

    public float[] getColor() {
        return this.mColor;
    }

    public void setPower(float power) {
        this.mPower = power;
    }

    public float getPower() {
        return this.mPower;
    }

    public boolean shouldUseObjectTransform() {
        return this.mUseObjectTransform;
    }

    public void shouldUseObjectTransform(boolean useObjectTransform) {
        this.mUseObjectTransform = useObjectTransform;
    }

    public int getLightType() {
        return this.mLightType;
    }

    public void setLightType(int lightType) {
        this.mLightType = lightType;
    }

    public double[] getPositionArray() {
        this.mPositionArray[0] = this.mPosition.x;
        this.mPositionArray[1] = this.mPosition.y;
        this.mPositionArray[2] = this.mPosition.z;
        return this.mPositionArray;
    }
}

