/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.extras;

import java.util.ArrayList;
import org.rajawali3d.materials.textures.ASingleTexture;
import org.rajawali3d.math.vector.Vector3;

public class LensFlare {
    protected ArrayList<FlareInfo> mLensFlares = new ArrayList();
    protected Vector3 mPositionScreen = new Vector3();
    protected Vector3 mPosition = new Vector3();
    protected boolean mOccluded;

    public LensFlare(ASingleTexture texture, int size, double distance, Vector3 color) {
        this.addLensFlare(texture, size, distance, color);
    }

    public void addLensFlare(ASingleTexture texture) {
        this.addLensFlare(texture, -1, 0.0, new Vector3(1.0, 1.0, 1.0));
    }

    public void addLensFlare(ASingleTexture texture, int size, double distance, Vector3 color) {
        this.addLensFlare(texture, size, distance, color, 1.0);
    }

    public void addLensFlare(ASingleTexture texture, int size, double distance, Vector3 color, double opacity) {
        distance = Math.min(distance, Math.max(0.0, distance));
        this.mLensFlares.add(new FlareInfo(texture, size, distance, new Vector3(), color, opacity));
    }

    public ArrayList<FlareInfo> getLensFlares() {
        return this.mLensFlares;
    }

    public Vector3 getPosition() {
        return this.mPosition;
    }

    public Vector3 getPositionScreen() {
        return this.mPositionScreen;
    }

    public void setPosition(double x, double y, double z) {
        this.mPosition.setAll(x, y, z);
    }

    public void setPosition(Vector3 position) {
        this.mPosition.setAll(position);
    }

    public void setPositionScreen(double x, double y, double z) {
        this.mPositionScreen.setAll(x, y, z);
    }

    public void setPositionScreen(Vector3 position) {
        this.mPositionScreen.setAll(position);
    }

    public void updateLensFlares() {
        double vecX = -this.mPositionScreen.x * 2.0;
        double vecY = -this.mPositionScreen.y * 2.0;
        for (int f = 0; f < this.mLensFlares.size(); ++f) {
            FlareInfo flare = this.mLensFlares.get(f);
            flare.setScreenPosition(this.mPositionScreen.x + vecX * flare.getDistance(), this.mPositionScreen.y + vecY * flare.getDistance());
            flare.setWantedRotation(flare.getScreenPosition().x * Math.PI * 0.25);
            flare.setRotation(flare.getRotation() + (flare.getWantedRotation() - flare.getRotation()) * 0.25);
        }
    }

    public class FlareInfo {
        protected ASingleTexture mTexture;
        protected int mSize;
        protected double mDistance;
        protected Vector3 mColor;
        protected Vector3 mScreenPosition;
        protected double mOpacity;
        protected double mScale;
        protected double mRotation;
        protected double mWantedRotation;

        public FlareInfo(ASingleTexture texture, int size, double distance, Vector3 screenPosition, Vector3 color, double opacity) {
            this.mTexture = texture;
            this.mSize = size;
            this.mDistance = distance;
            this.mScreenPosition = screenPosition;
            this.mColor = color;
            this.mRotation = 1.0;
            this.mScale = 1.0;
            this.mOpacity = opacity;
            this.mWantedRotation = 0.0;
        }

        public Vector3 getColor() {
            return this.mColor;
        }

        public double getDistance() {
            return this.mDistance;
        }

        public double getOpacity() {
            return this.mOpacity;
        }

        public double getRotation() {
            return this.mRotation;
        }

        public double getScale() {
            return this.mScale;
        }

        public Vector3 getScreenPosition() {
            return this.mScreenPosition;
        }

        public int getSize() {
            return this.mSize;
        }

        public ASingleTexture getTexture() {
            return this.mTexture;
        }

        public double getWantedRotation() {
            return this.mWantedRotation;
        }

        public void setColor(double[] color) {
            this.mColor.x = color[0];
            this.mColor.y = color[1];
            this.mColor.z = color[2];
        }

        public void setColor(Vector3 color) {
            this.setColor(new double[]{color.x, color.y, color.z});
        }

        public void setDistance(double distance) {
            this.mDistance = distance;
        }

        public void setOpacity(double opacity) {
            this.mOpacity = opacity;
        }

        public void setRotation(double rotation) {
            this.mRotation = rotation;
        }

        public void setScale(double scale) {
            this.mScale = scale;
        }

        public void setScreenPosition(double x, double y) {
            this.mScreenPosition.x = x;
            this.mScreenPosition.y = y;
            this.mScreenPosition.z = 0.0;
        }

        public void setScreenPosition(double[] screenPosition) {
            this.mScreenPosition.x = screenPosition[0];
            this.mScreenPosition.y = screenPosition[1];
            this.mScreenPosition.z = screenPosition[2];
        }

        public void setScreenPosition(Vector3 screenPosition) {
            this.mScreenPosition.setAll(screenPosition);
        }

        public void setSize(int size) {
            this.mSize = size;
        }

        public void setTexture(ASingleTexture texture) {
            this.mTexture = texture;
        }

        public void setWantedRotation(double wantedRotation) {
            this.mWantedRotation = wantedRotation;
        }
    }
}

