/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.debug;

import java.util.Stack;
import org.rajawali3d.debug.DebugObject3D;
import org.rajawali3d.materials.Material;
import org.rajawali3d.math.vector.Vector3;

public class GridFloor
extends DebugObject3D {
    private float mSize;
    private int mNumLines;

    public GridFloor() {
        this(10.0f);
    }

    public GridFloor(float size) {
        this(size, -1, 1, 20);
    }

    public GridFloor(float size, int color, int lineThickness, int numLines) {
        super(color, lineThickness);
        this.mSize = size;
        this.mNumLines = numLines;
        this.createGridFloor();
    }

    private void createGridFloor() {
        float sizeHalf = this.mSize * 0.5f;
        float spacing = this.mSize / (float)this.mNumLines;
        this.mPoints = new Stack();
        for (float z = -sizeHalf; z <= sizeHalf; z += spacing) {
            this.mPoints.add(new Vector3(-sizeHalf, 0.0, z));
            this.mPoints.add(new Vector3(sizeHalf, 0.0, z));
        }
        for (float x = -sizeHalf; x <= sizeHalf; x += spacing) {
            this.mPoints.add(new Vector3(x, 0.0, -sizeHalf));
            this.mPoints.add(new Vector3(x, 0.0, sizeHalf));
        }
        this.setMaterial(new Material());
        this.init(true);
        this.setDrawingMode(1);
    }
}

