/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.debug;

import android.opengl.GLDebugHelper;
import java.io.IOException;
import java.io.Writer;
import javax.microedition.khronos.egl.EGL;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;
import org.rajawali3d.util.RajLog;

public class GLDebugger {
    final Writer mWriter;
    final int mConfig;
    final GL10 mGL;
    final EGL mEGL;
    final StringBuilder mBuilder = new StringBuilder();

    private GLDebugger(int config, GL gl, EGL egl) {
        this.mConfig = config;
        this.mWriter = new Writer(){

            @Override
            public void close() throws IOException {
                this.flushBuilder();
            }

            @Override
            public void flush() throws IOException {
                this.flushBuilder();
            }

            @Override
            public void write(char[] buf, int offset, int count) throws IOException {
                for (int i = 0; i < count; ++i) {
                    char c = buf[offset + i];
                    if (c == '\n') {
                        this.flushBuilder();
                        continue;
                    }
                    GLDebugger.this.mBuilder.append(c);
                }
            }

            private void flushBuilder() {
                if (GLDebugger.this.mBuilder.length() > 0) {
                    RajLog.v(GLDebugger.this.mBuilder.toString());
                    GLDebugger.this.mBuilder.delete(0, GLDebugger.this.mBuilder.length());
                }
            }
        };
        this.mGL = gl != null ? (GL10)GLDebugHelper.wrap((GL)gl, (int)config, (Writer)this.mWriter) : null;
        this.mEGL = egl != null ? GLDebugHelper.wrap((EGL)egl, (int)config, (Writer)this.mWriter) : null;
    }

    public GL10 getGL() throws IllegalStateException {
        if (this.mGL == null) {
            throw new IllegalStateException("This debugger was not configured with a GL context.");
        }
        return this.mGL;
    }

    public EGL getEGL() throws IllegalStateException {
        if (this.mEGL == null) {
            throw new IllegalStateException("This debugger was not configured with an EGL context.");
        }
        return this.mEGL;
    }

    public static final class Builder {
        private int mBuilderConfig;
        private GL mGL;
        private EGL mEGL;

        public GLDebugger build() {
            return new GLDebugger(this.mBuilderConfig, this.mGL, this.mEGL);
        }

        public void checkAllGLErrors() {
            this.mBuilderConfig |= 1;
        }

        public void checkSameThread() {
            this.mBuilderConfig |= 2;
        }

        public void enableLogArgumentNames() {
            this.mBuilderConfig |= 4;
        }

        public void setGL(GL gl) {
            this.mGL = gl;
        }

        public void setEGL(EGL egl) {
            this.mEGL = egl;
        }
    }
}

