/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.debug;

import java.util.Stack;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.debug.DebugObject3D;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.materials.Material;
import org.rajawali3d.math.MathUtil;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.primitives.Line3D;

public class DebugLight
extends DebugObject3D {
    private ALight mLight;
    private Line3D mCircle;
    private Line3D mLine;
    private int mColor;

    public DebugLight(ALight light) {
        this(light, -256, 1);
    }

    public DebugLight(ALight light, int color, int lineThickness) {
        super(color, lineThickness);
        this.mLight = light;
        this.mColor = color;
    }

    private void updateLightTransform(Camera camera) {
        if (this.mCircle == null) {
            this.createLines();
        }
        this.mCircle.setLookAt(camera.getPosition());
        this.mCircle.setScale(this.mPosition.distanceTo(camera.getPosition()) * (double)0.1f);
        this.mCircle.setPosition(this.mLight.getPosition());
        this.mLine.setPosition(this.mLight.getPosition());
        this.mLine.setOrientation(this.mLight.getOrientation());
    }

    private void createLines() {
        block7: {
            Material material;
            Stack<Vector3> points;
            block6: {
                points = new Stack<Vector3>();
                float segmentSize = 10.0f;
                float radius = 0.2f;
                int count = 0;
                int i = 0;
                while (i < 360) {
                    if (count++ % 2 != 0) {
                        float radians1 = (float)MathUtil.degreesToRadians(i);
                        float radians2 = (float)MathUtil.degreesToRadians((float)i + segmentSize);
                        Vector3 p1 = new Vector3();
                        p1.x = Math.cos(radians1) * (double)radius;
                        p1.y = Math.sin(radians1) * (double)radius;
                        Vector3 p2 = new Vector3();
                        p2.x = Math.cos(radians2) * (double)radius;
                        p2.y = Math.sin(radians2) * (double)radius;
                        points.add(p1);
                        points.add(p2);
                    }
                    i = (int)((float)i + segmentSize);
                }
                material = new Material();
                this.mCircle = new Line3D(points, this.mLineThickness, this.mColor);
                this.mCircle.setMaterial(material);
                this.mCircle.setDrawingMode(1);
                this.mCircle.enableLookAt();
                this.addChild(this.mCircle);
                points = new Stack();
                if (this.mLight.getLightType() == 0) break block6;
                if (this.mLight.getLightType() != 2) break block7;
            }
            for (int i = 0; i < 20; i += 2) {
                Vector3 p1 = new Vector3();
                p1.z = (float)i * 0.5f;
                Vector3 p2 = new Vector3();
                p2.z = (float)(i + 1) * 0.5f;
                points.add(p1);
                points.add(p2);
            }
            this.mLine = new Line3D(points, this.mLineThickness, this.mColor);
            this.mLine.setMaterial(material);
            this.mLine.setDrawingMode(1);
            this.mLine.enableLookAt();
            this.addChild(this.mLine);
        }
    }

    @Override
    public void render(Camera camera, Matrix4 vpMatrix, Matrix4 projMatrix, Matrix4 vMatrix, Matrix4 parentMatrix, Material sceneMaterial) {
        this.updateLightTransform(camera);
        super.render(camera, vpMatrix, projMatrix, vMatrix, parentMatrix, sceneMaterial);
    }
}

