/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.debug;

import java.nio.FloatBuffer;
import java.util.Stack;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.debug.DebugObject3D;
import org.rajawali3d.materials.Material;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.primitives.Sphere;

public class DebugCamera
extends DebugObject3D {
    private Camera mCamera;
    private Sphere mPositionBall;
    private Material mMaterial = new Material();
    protected Vector3[] mFrustumCornersTransformed;

    public DebugCamera(Camera camera) {
        this(camera, -16776961, 1);
    }

    public DebugCamera(Camera camera, int color, int lineThickness) {
        super(color, lineThickness);
        this.mCamera = camera;
        this.mPositionBall = new Sphere(0.25f, 8, 8);
        this.mPositionBall.setColor(color);
        this.mPositionBall.setMaterial(this.mMaterial);
    }

    public void updateFrustum() {
        this.mCamera.setProjectionMatrix(this.mRenderer.getOverrideViewportWidth(), this.mRenderer.getOverrideViewportHeight());
        if (this.mPoints == null) {
            if (!this.mCamera.isInitialized()) {
                return;
            }
            this.mPoints = new Stack();
            this.mFrustumCornersTransformed = new Vector3[8];
            for (int i = 0; i < 16; ++i) {
                if (i < 8) {
                    this.mFrustumCornersTransformed[i] = new Vector3();
                }
                this.mPoints.push(new Vector3());
            }
            this.init(true);
            this.getGeometry().changeBufferUsage(this.mGeometry.getVertexBufferInfo(), 35048);
            this.setMaterial(this.mMaterial);
        }
        this.mCamera.getFrustumCorners(this.mFrustumCornersTransformed, true, true);
        FloatBuffer b = this.mGeometry.getVertices();
        int index = 0;
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[0]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[1]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[2]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[3]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[0]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[4]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[5]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[1]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[5]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[6]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[2]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[6]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[7]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[3]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[7]);
        this.addVertexToBuffer(b, index++, this.mFrustumCornersTransformed[4]);
        this.mGeometry.changeBufferData(this.mGeometry.getVertexBufferInfo(), this.mGeometry.getVertices(), 0);
    }

    private void addVertexToBuffer(FloatBuffer b, int index, Vector3 vertex) {
        int vertIndex = index * 3;
        b.put(vertIndex, (float)vertex.x);
        b.put(vertIndex + 1, (float)vertex.y);
        b.put(vertIndex + 2, (float)vertex.z);
    }

    @Override
    public void render(Camera camera, Matrix4 vpMatrix, Matrix4 projMatrix, Matrix4 vMatrix, Matrix4 parentMatrix, Material sceneMaterial) {
        this.updateFrustum();
        this.mPositionBall.setPosition(this.mCamera.getPosition());
        this.mPositionBall.render(camera, vpMatrix, projMatrix, vMatrix, parentMatrix, sceneMaterial);
        super.render(camera, vpMatrix, projMatrix, vMatrix, parentMatrix, sceneMaterial);
    }
}

