/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.debug;

import java.nio.FloatBuffer;
import java.util.Stack;
import org.rajawali3d.bounds.BoundingBox;
import org.rajawali3d.debug.DebugObject3D;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.materials.Material;
import org.rajawali3d.math.vector.Vector3;

public class DebugBoundingBox
extends DebugObject3D {
    private Vector3[] mBBoxVertices;

    public DebugBoundingBox() {
        super(-16711681, 1);
    }

    public DebugBoundingBox(ALight light, int color, int lineThickness) {
        super(color, lineThickness);
    }

    public void updateBoundingBox(BoundingBox boundingBox) {
        if (this.mBBoxVertices == null) {
            this.mBBoxVertices = new Vector3[8];
            this.mPoints = new Stack();
            for (int i = 0; i < 16; ++i) {
                this.mPoints.push(new Vector3());
                if (i >= 8) continue;
                this.mBBoxVertices[i] = new Vector3();
            }
            this.init(true);
            this.getGeometry().changeBufferUsage(this.mGeometry.getVertexBufferInfo(), 35048);
            this.setMaterial(new Material());
        }
        this.updateBox(boundingBox);
    }

    private void updateBox(BoundingBox bb) {
        FloatBuffer b = this.mGeometry.getVertices();
        int index = 0;
        bb.copyPoints(this.mBBoxVertices);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[0]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[1]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[2]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[3]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[0]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[4]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[5]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[1]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[5]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[6]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[2]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[6]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[7]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[3]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[7]);
        this.addVertexToBuffer(b, index++, this.mBBoxVertices[4]);
        this.mGeometry.changeBufferData(this.mGeometry.getVertexBufferInfo(), this.mGeometry.getVertices(), 0);
    }

    private void addVertexToBuffer(FloatBuffer b, int index, Vector3 vertex) {
        int vertIndex = index * 3;
        b.put(vertIndex, (float)vertex.x);
        b.put(vertIndex + 1, (float)vertex.y);
        b.put(vertIndex + 2, (float)vertex.z);
    }
}

