/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.curves;

import android.content.Context;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.rajawali3d.curves.CompoundCurve3D;
import org.rajawali3d.curves.CubicBezierCurve3D;
import org.rajawali3d.curves.LinearBezierCurve3D;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.util.RajLog;

public class SVGPath {
    private Vector3 mPreviousPoint;
    private Vector3 mStartPoint;
    private Vector3 mPreviousControlPoint;
    private SVGCommand mCurrentCommand;
    private SVGCommand mPreviousCommand;
    private boolean mCurrentCommandIsRelative;

    public List<CompoundCurve3D> parseString(String pathString) {
        this.mPreviousPoint = new Vector3();
        this.mStartPoint = new Vector3();
        this.mPreviousControlPoint = new Vector3();
        return this.pathStringToLine(pathString);
    }

    public List<CompoundCurve3D> parseResourceString(Context context, int resourceId) {
        InputStream rawResource = context.getResources().openRawResource(resourceId);
        BufferedReader r = new BufferedReader(new InputStreamReader(rawResource));
        StringBuilder s = new StringBuilder();
        try {
            String l;
            while ((l = r.readLine()) != null) {
                s.append(l + "\n");
            }
            rawResource.close();
            r.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.parseString(s.toString());
    }

    private List<CompoundCurve3D> pathStringToLine(String path) {
        if (path == null || path.length() == 0) {
            throw new RuntimeException("Path cannot be null or empty.");
        }
        ArrayList<CompoundCurve3D> paths = new ArrayList<CompoundCurve3D>();
        CompoundCurve3D bezierPath = new CompoundCurve3D();
        this.mPreviousCommand = SVGCommand.CLOSE_PATH;
        path = path.replaceAll("\\s+", "");
        path = path.replaceAll("\\d-", "$0,-");
        path = path.replaceAll("-,", ",");
        path = path.replaceAll("[a-zA-Z]", "\n$0\n");
        String[] components = path.split("\n");
        for (int i = 0; i < components.length; ++i) {
            if (components[i].length() == 0) continue;
            if (components[i].matches("[a-zA-Z]")) {
                boolean shouldClosePath;
                this.inspectCommand(components[i].charAt(0));
                boolean bl = shouldClosePath = this.mCurrentCommand == SVGCommand.CLOSE_PATH || this.mCurrentCommand == SVGCommand.MOVE_TO && this.mPreviousCommand != SVGCommand.CLOSE_PATH;
                if (shouldClosePath) {
                    SVGCommand pc = this.mCurrentCommand;
                    boolean pr = this.mCurrentCommandIsRelative;
                    this.mCurrentCommand = SVGCommand.LINE_TO;
                    this.mCurrentCommandIsRelative = false;
                    this.inspectValues(bezierPath, this.mStartPoint.x + "," + -this.mStartPoint.y);
                    paths.add(bezierPath);
                    bezierPath = new CompoundCurve3D();
                    if (pc == SVGCommand.MOVE_TO) {
                        this.mCurrentCommand = pc;
                        this.mCurrentCommandIsRelative = pr;
                    }
                }
                this.mPreviousCommand = this.mCurrentCommand;
                continue;
            }
            this.inspectValues(bezierPath, components[i]);
        }
        return paths;
    }

    private void inspectValues(CompoundCurve3D bezierPath, String values) {
        Vector3 p;
        String[] vals = values.split(",");
        if (vals.length == 0) {
            throw new RuntimeException("Empty values found.");
        }
        switch (this.mCurrentCommand) {
            case MOVE_TO: {
                Vector3 c = new Vector3(Double.parseDouble(vals[0]), -Double.parseDouble(vals[1]), 0.0);
                p = this.mCurrentCommandIsRelative ? c.addAndSet(this.mPreviousPoint, c) : c;
                break;
            }
            case VERTICAL: {
                Vector3 c = new Vector3(0.0, -Double.parseDouble(vals[0]), 0.0);
                if (this.mCurrentCommandIsRelative) {
                    p = c.addAndSet(this.mPreviousPoint, c);
                } else {
                    c.x = this.mPreviousPoint.x;
                    p = c;
                }
                bezierPath.addCurve(new LinearBezierCurve3D(this.mPreviousPoint.clone(), p));
                break;
            }
            case HORIZONTAL: {
                Vector3 c = new Vector3(Double.parseDouble(vals[0]), 0.0, 0.0);
                if (this.mCurrentCommandIsRelative) {
                    p = c.addAndSet(this.mPreviousPoint, c);
                } else {
                    c.y = this.mPreviousPoint.y;
                    p = c;
                }
                bezierPath.addCurve(new LinearBezierCurve3D(this.mPreviousPoint.clone(), p));
                break;
            }
            case CURVE_TO: {
                Vector3 c = new Vector3(Double.parseDouble(vals[4]), -Double.parseDouble(vals[5]), 0.0);
                p = this.mCurrentCommandIsRelative ? c.addAndSet(this.mPreviousPoint, c) : c;
                Vector3 cp1 = new Vector3(Double.parseDouble(vals[0]), -Double.parseDouble(vals[1]), 0.0);
                if (this.mCurrentCommandIsRelative) {
                    cp1.add(this.mPreviousPoint);
                }
                Vector3 cp2 = new Vector3(Double.parseDouble(vals[2]), -Double.parseDouble(vals[3]), 0.0);
                if (this.mCurrentCommandIsRelative) {
                    cp2.add(this.mPreviousPoint);
                }
                this.mPreviousControlPoint.setAll(cp2);
                bezierPath.addCurve(new CubicBezierCurve3D(this.mPreviousPoint.clone(), cp1, cp2, p));
                break;
            }
            case SMOOTH_CURVE_TO: {
                Vector3 c = new Vector3(Double.parseDouble(vals[2]), -Double.parseDouble(vals[3]), 0.0);
                p = this.mCurrentCommandIsRelative ? c.addAndSet(this.mPreviousPoint, c) : c;
                Vector3 cp1 = this.reflect(this.mPreviousControlPoint, this.mPreviousPoint);
                Vector3 cp2 = new Vector3(Double.parseDouble(vals[0]), -Double.parseDouble(vals[1]), 0.0);
                if (this.mCurrentCommandIsRelative) {
                    cp2.add(this.mPreviousPoint);
                }
                bezierPath.addCurve(new CubicBezierCurve3D(this.mPreviousPoint.clone(), cp1, cp2, p));
                break;
            }
            case LINE_TO: {
                Vector3 c = new Vector3(Double.parseDouble(vals[0]), -Double.parseDouble(vals[1]), 0.0);
                p = this.mCurrentCommandIsRelative ? c.addAndSet(this.mPreviousPoint, c) : c;
                bezierPath.addCurve(new LinearBezierCurve3D(this.mPreviousPoint.clone(), p));
                break;
            }
            default: {
                return;
            }
        }
        if (bezierPath.getNumCurves() == 0) {
            this.mStartPoint.setAll(p);
        }
        this.mPreviousPoint.setAll(p);
    }

    private Vector3 reflect(Vector3 point, Vector3 mirror) {
        double x = mirror.x + (mirror.x - point.x);
        double y = mirror.y + (mirror.y - point.y);
        return new Vector3(x, y, 0.0);
    }

    private void inspectCommand(char command) {
        switch (command) {
            case 'M': 
            case 'm': {
                this.mCurrentCommand = SVGCommand.MOVE_TO;
                this.mCurrentCommandIsRelative = command == 'm';
                break;
            }
            case 'Z': 
            case 'z': {
                this.mCurrentCommand = SVGCommand.CLOSE_PATH;
                break;
            }
            case 'L': 
            case 'l': {
                this.mCurrentCommand = SVGCommand.LINE_TO;
                this.mCurrentCommandIsRelative = command == 'l';
                break;
            }
            case 'H': 
            case 'h': {
                this.mCurrentCommand = SVGCommand.HORIZONTAL;
                this.mCurrentCommandIsRelative = command == 'h';
                break;
            }
            case 'V': 
            case 'v': {
                this.mCurrentCommand = SVGCommand.VERTICAL;
                this.mCurrentCommandIsRelative = command == 'v';
                break;
            }
            case 'C': 
            case 'c': {
                this.mCurrentCommand = SVGCommand.CURVE_TO;
                this.mCurrentCommandIsRelative = command == 'c';
                break;
            }
            case 'S': 
            case 's': {
                this.mCurrentCommand = SVGCommand.SMOOTH_CURVE_TO;
                this.mCurrentCommandIsRelative = command == 's';
                break;
            }
            default: {
                RajLog.e("SVG command not recognized: " + command);
            }
        }
    }

    private static enum SVGCommand {
        MOVE_TO,
        CLOSE_PATH,
        LINE_TO,
        CURVE_TO,
        SMOOTH_CURVE_TO,
        HORIZONTAL,
        VERTICAL;

    }
}

