/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.curves;

import org.rajawali3d.curves.ICurve3D;
import org.rajawali3d.math.vector.Vector3;

public class QuadraticBezierCurve3D
implements ICurve3D {
    private static final double DELTA = 1.0E-5;
    private Vector3 mPoint1;
    private Vector3 mControlPoint;
    private Vector3 mPoint2;
    private Vector3 mTmpPoint1;
    private Vector3 mTmpPoint2;
    private Vector3 mTmpPoint3;
    private Vector3 mTempPointNext = new Vector3();
    private double mCurrent = 0.0;
    private Vector3 mStartTangent;
    private Vector3 mEndTangent;

    public QuadraticBezierCurve3D() {
        this.mTmpPoint1 = new Vector3();
        this.mTmpPoint2 = new Vector3();
        this.mTmpPoint3 = new Vector3();
        this.mStartTangent = new Vector3();
        this.mEndTangent = new Vector3();
    }

    public QuadraticBezierCurve3D(Vector3 point1, Vector3 controlPoint, Vector3 point2) {
        this();
        this.addPoint(point1, controlPoint, point2);
    }

    public void addPoint(Vector3 point1, Vector3 controlPoint, Vector3 point2) {
        this.mPoint1 = point1;
        this.mControlPoint = controlPoint;
        this.mPoint2 = point2;
        this.mStartTangent.setAll(controlPoint).subtract(point1);
        this.mEndTangent.setAll(point2).subtract(controlPoint);
    }

    @Override
    public void calculatePoint(Vector3 result, double t) {
        this.mCurrent = t;
        if (this.mCurrent < 0.0) {
            this.mCurrent = 0.0;
        }
        if (this.mCurrent > 1.0) {
            this.mCurrent = 1.0;
        }
        this.mTmpPoint1.setAll(this.mPoint1);
        this.mTmpPoint1.multiply((1.0 - this.mCurrent) * (1.0 - this.mCurrent));
        this.mTmpPoint2.setAll(this.mControlPoint);
        this.mTmpPoint2.multiply(2.0 * (1.0 - this.mCurrent) * t);
        this.mTmpPoint3.setAll(this.mPoint2);
        this.mTmpPoint3.multiply(this.mCurrent * this.mCurrent);
        this.mTmpPoint2.add(this.mTmpPoint3);
        result.addAndSet(this.mTmpPoint1, this.mTmpPoint2);
    }

    @Override
    public Vector3 getCurrentTangent() {
        Vector3 startPortion = new Vector3(this.mStartTangent).multiply(1.0 - this.mCurrent);
        Vector3 endPortion = new Vector3(this.mEndTangent).multiply(this.mCurrent);
        Vector3 result = startPortion.add(endPortion);
        result.normalize();
        return result;
    }

    @Override
    public void setCalculateTangents(boolean calculateTangents) {
    }
}

