/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.curves;

import org.rajawali3d.curves.ASpiral3D;
import org.rajawali3d.math.vector.Vector3;

public class LogarithmicSpiral3D
extends ASpiral3D {
    public LogarithmicSpiral3D(double density, Vector3 start, Vector3 normal, boolean spiralIn) {
        super(density, start, normal, spiralIn);
        this.a = this.mStart.length();
        this.mThetaOffset = this.mSpiralIn ? this.calculateThetaForRadius(this.mStart.length()) : this.mRotation.getXAxis().angle(this.mStart);
    }

    @Override
    public void calculatePointDegrees(Vector3 result, double theta) {
        this.calculatePoint(result, Math.toRadians(this.mSpiralIn ? this.mThetaOffset - theta : theta + this.mThetaOffset));
    }

    @Override
    public void calculatePoint(Vector3 result, double theta) {
        double angle = this.mSpiralIn ? this.mThetaOffset + theta : theta - this.mThetaOffset;
        double r = this.a * Math.exp(this.mDensity * angle);
        this.mRotation.fromAngleAxis(this.mUp, Math.toDegrees(angle));
        this.mScratch.setAll(this.mRotation.multiply(this.mStart)).normalize();
        result.setAll(this.mScratch.multiply(r));
        if (this.mCalculateTangents) {
            this.mCurrentTangent.crossAndSet(this.mUp, this.mScratch);
        }
    }

    @Override
    public double calculateThetaForRadius(double r) {
        return Math.log(r / this.a) / this.mDensity;
    }

    @Override
    public Vector3 getCurrentTangent() {
        return this.mCurrentTangent;
    }

    @Override
    public void setCalculateTangents(boolean calculateTangents) {
        this.mCalculateTangents = calculateTangents;
    }
}

