/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.curves;

import org.rajawali3d.curves.ICurve3D;
import org.rajawali3d.math.vector.Vector3;

public class LinearBezierCurve3D
implements ICurve3D {
    private Vector3 mPoint1;
    private Vector3 mPoint2;
    private Vector3 mTmpPoint1 = new Vector3();
    private Vector3 mTmpPoint2 = new Vector3();

    public LinearBezierCurve3D() {
    }

    public LinearBezierCurve3D(Vector3 point1, Vector3 point2) {
        this();
        this.addPoint(point1, point2);
    }

    public void addPoint(Vector3 point1, Vector3 point2) {
        this.mPoint1 = point1;
        this.mPoint2 = point2;
    }

    @Override
    public void calculatePoint(Vector3 result, double t) {
        this.mTmpPoint1.setAll(this.mPoint2);
        this.mTmpPoint1.multiply(t);
        this.mTmpPoint2.setAll(this.mPoint1);
        this.mTmpPoint2.multiply(1.0 - t);
        result.addAndSet(this.mTmpPoint1, this.mTmpPoint2);
    }

    @Override
    public Vector3 getCurrentTangent() {
        return null;
    }

    @Override
    public void setCalculateTangents(boolean calculateTangents) {
    }
}

