/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.curves;

import org.rajawali3d.curves.ICurve3D;
import org.rajawali3d.math.vector.Vector3;

public class CubicBezierCurve3D
implements ICurve3D {
    private static final double DELTA = 1.0E-5;
    private Vector3 mPoint1;
    private Vector3 mControlPoint1;
    private Vector3 mControlPoint2;
    private Vector3 mPoint2;
    private Vector3 mTempPoint = new Vector3();
    private double mCurrent = 0.0;
    private Vector3 mStartTangent = new Vector3();
    private Vector3 mTransferTangent = new Vector3();
    private Vector3 mEndTangent = new Vector3();

    public CubicBezierCurve3D() {
    }

    public CubicBezierCurve3D(Vector3 point1, Vector3 controlPoint1, Vector3 controlPoint2, Vector3 point2) {
        this();
        this.addPoint(point1, controlPoint1, controlPoint2, point2);
    }

    public void addPoint(Vector3 point1, Vector3 controlPoint1, Vector3 controlPoint2, Vector3 point2) {
        this.mPoint1 = point1;
        this.mControlPoint1 = controlPoint1;
        this.mControlPoint2 = controlPoint2;
        this.mPoint2 = point2;
        this.mStartTangent.setAll(this.mControlPoint1).subtract(point1);
        this.mTransferTangent.setAll(this.mControlPoint2).subtract(controlPoint1);
        this.mEndTangent.setAll(point2).subtract(this.mControlPoint2);
    }

    @Override
    public void calculatePoint(Vector3 result, double t) {
        double u = 1.0 - t;
        double tt = t * t;
        double uu = u * u;
        double ttt = tt * t;
        double uuu = uu * u;
        result.scaleAndSet(this.mPoint1, uuu);
        this.mTempPoint.scaleAndSet(this.mControlPoint1, 3.0 * uu * t);
        result.add(this.mTempPoint);
        this.mTempPoint.scaleAndSet(this.mControlPoint2, 3.0 * u * tt);
        result.add(this.mTempPoint);
        this.mTempPoint.scaleAndSet(this.mPoint2, ttt);
        result.add(this.mTempPoint);
        this.mCurrent = t;
    }

    @Override
    public Vector3 getCurrentTangent() {
        double t = this.mCurrent;
        Vector3 startPortion = new Vector3(this.mStartTangent).multiply(3.0 * (1.0 - t) * (1.0 - t));
        Vector3 transferPortion = new Vector3(this.mTransferTangent).multiply(6.0 * (1.0 - t) * t);
        Vector3 endPortion = new Vector3(this.mEndTangent).multiply(3.0 * t * t);
        Vector3 result = startPortion.add(transferPortion).add(endPortion);
        result.normalize();
        return result;
    }

    @Override
    public void setCalculateTangents(boolean calculateTangents) {
    }
}

